/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.listeners.SWFListener;
import oracle.dss.graph.flash.jswiff.swfrecords.SWFHeader;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.MalformedTag;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.Tag;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.TagHeader;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.TagReader;

public final class SWFReader {
    private InputBitStream bitStream;
    private List listeners;
    private boolean japanese;

    private void $init$() {
        this.listeners = new ArrayList();
    }

    public SWFReader(InputStream stream) {
        this.$init$();
        this.bitStream = new InputBitStream(stream);
    }

    public void setJapanese(boolean japanese) {
        this.japanese = japanese;
    }

    public void addListener(SWFListener listener) {
        this.listeners.add(listener);
    }

    public void read() {
        SWFHeader header;
        this.preProcess();
        try {
            header = new SWFHeader(this.bitStream);
        }
        catch (Exception e) {
            this.processHeaderReadError(e);
            return;
        }
        this.processHeader(header);
        while (header.getFileLength() - this.bitStream.getOffset() >= (long)2) {
            TagHeader tagHeader = null;
            try {
                tagHeader = TagReader.readTagHeader(this.bitStream);
            }
            catch (Exception e) {
                this.processTagHeaderReadError(e);
                break;
            }
            this.processTagHeader(tagHeader);
            Tag tag = null;
            byte[] tagData = null;
            try {
                tagData = TagReader.readTagData(this.bitStream, tagHeader);
                tag = TagReader.readTag(tagHeader, tagData, header.getVersion(), this.japanese);
                if (tag.getCode() == 0) {
                    break;
                }
            }
            catch (Exception e) {
                if (this.processTagReadError(tagHeader, tagData, e)) break;
                tag = new MalformedTag(tagHeader, tagData, e);
            }
            this.processTag(tag, this.bitStream.getOffset());
        }
        this.postProcess();
        try {
            this.bitStream.close();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void postProcess() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((SWFListener)iterator.next()).postProcess();
        }
    }

    private void preProcess() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((SWFListener)iterator.next()).preProcess();
        }
    }

    private void processHeader(SWFHeader header) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((SWFListener)iterator.next()).processHeader(header);
        }
    }

    private void processHeaderReadError(Exception e) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((SWFListener)iterator.next()).processHeaderReadError(e);
        }
    }

    private void processTag(Tag tag, long streamOffset) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((SWFListener)iterator.next()).processTag(tag, streamOffset);
        }
    }

    private void processTagHeader(TagHeader tagHeader) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((SWFListener)iterator.next()).processTagHeader(tagHeader);
        }
    }

    private void processTagHeaderReadError(Exception e) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((SWFListener)iterator.next()).processTagHeaderReadError(e);
        }
    }

    private boolean processTagReadError(TagHeader tagHeader, byte[] tagData, Exception e) {
        boolean result = false;
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            boolean bl = result = ((SWFListener)iterator.next()).processTagReadError(tagHeader, tagData, e) || result;
        }
        return result;
    }
}

