/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import oracle.dss.graph.flash.jswiff.SWFDocument;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.FileAttributes;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.Metadata;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.SetBackgroundColor;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.Tag;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.TagWriter;

public class SWFWriter {
    private OutputBitStream bitStream;
    private SWFDocument document;
    private boolean japanese;

    public SWFWriter(SWFDocument document, OutputStream stream) {
        this.bitStream = new OutputBitStream(stream);
        this.document = document;
    }

    public void setJapanese(boolean japanese) {
        this.japanese = japanese;
    }

    public void write() throws IOException {
        try {
            byte[] docPropertiesTagsBuffer = this.getDocPropertiesTagsBuffer();
            byte[] tagsBuffer = TagWriter.writeTags(this.document.getTags(), this.document.getVersion(), this.japanese);
            byte[] headerEndData = this.getHeaderEndData();
            long fileLength = 8 + headerEndData.length + tagsBuffer.length + docPropertiesTagsBuffer.length;
            this.writeHeaderStart();
            this.bitStream.writeUI32(fileLength);
            if (this.document.isCompressed()) {
                this.bitStream.enableCompression();
            }
            this.bitStream.writeBytes(headerEndData);
            this.bitStream.writeBytes(docPropertiesTagsBuffer);
            this.bitStream.writeBytes(tagsBuffer);
        }
        finally {
            try {
                this.bitStream.close();
            }
            catch (Exception e) {}
        }
    }

    private byte[] getDocPropertiesTagsBuffer() throws IOException {
        OutputBitStream tagStream = new OutputBitStream();
        if (this.document.getVersion() >= 8) {
            FileAttributes fileAttributes = new FileAttributes();
            fileAttributes.setAllowNetworkAccess(this.document.getAccessMode() == 1);
            TagWriter.writeTag(tagStream, fileAttributes, this.document.getVersion());
            String metadata = this.document.getMetadata();
            if (metadata != null) {
                fileAttributes.setHasMetadata(true);
                TagWriter.writeTag(tagStream, new Metadata(metadata), this.document.getVersion());
            }
        }
        TagWriter.writeTag(tagStream, new SetBackgroundColor(this.document.getBackgroundColor()), this.document.getVersion());
        return tagStream.getData();
    }

    private int getFrameCount() {
        int count = 0;
        Iterator i = this.document.getTags().iterator();
        while (i.hasNext()) {
            if (((Tag)i.next()).getCode() != 1) continue;
            ++count;
        }
        return count;
    }

    private byte[] getHeaderEndData() throws IOException {
        OutputBitStream headerStream = new OutputBitStream();
        this.document.getFrameSize().write(headerStream);
        headerStream.writeUI8((short)0);
        headerStream.writeUI8(this.document.getFrameRate());
        headerStream.writeUI16(this.getFrameCount());
        byte[] headerData = headerStream.getData();
        return headerData;
    }

    private void writeHeaderStart() throws IOException {
        this.bitStream.writeUI8((short)(this.document.isCompressed() ? 67 : 70));
        this.bitStream.writeBytes(new byte[]{87, 83});
        this.bitStream.writeUI8(this.document.getVersion());
    }
}

