/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.hl.factories;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import oracle.dss.graph.flash.jswiff.SWFDocument;
import oracle.dss.graph.flash.jswiff.SWFWriter;
import oracle.dss.graph.flash.jswiff.swfrecords.AlphaBitmapData;
import oracle.dss.graph.flash.jswiff.swfrecords.FillStyle;
import oracle.dss.graph.flash.jswiff.swfrecords.FillStyleArray;
import oracle.dss.graph.flash.jswiff.swfrecords.LineStyleArray;
import oracle.dss.graph.flash.jswiff.swfrecords.Matrix;
import oracle.dss.graph.flash.jswiff.swfrecords.RGB;
import oracle.dss.graph.flash.jswiff.swfrecords.RGBA;
import oracle.dss.graph.flash.jswiff.swfrecords.Rect;
import oracle.dss.graph.flash.jswiff.swfrecords.ShapeRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.ShapeWithStyle;
import oracle.dss.graph.flash.jswiff.swfrecords.StraightEdgeRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.StyleChangeRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineBitsJPEG2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineBitsLossless2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineShape;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefinitionTag;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.PlaceObject2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.ShowFrame;
import oracle.dss.graph.flash.jswiff.util.ImageUtilities;

public class ImageDocumentFactory {
    private static final byte[] JPEG_DATA_HEADER = new byte[]{-1, -39, -1, -40};
    private BufferedImage image;
    private int docWidth;
    private int docHeight;
    private boolean dimensionsSet;
    private RGB backgroundColor;
    private SWFDocument doc;
    private int quality;
    private boolean lossless;

    private void $init$() {
        this.quality = -1;
    }

    public ImageDocumentFactory(BufferedImage image) {
        this.$init$();
        this.image = image;
    }

    public void setBackgroundColor(RGB backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setDimensions(int docWidth, int docHeight) {
        this.docWidth = docWidth;
        this.docHeight = docHeight;
        this.dimensionsSet = true;
    }

    public SWFDocument getDocument() {
        this.initDocument();
        return this.doc;
    }

    public void setLossless(boolean lossless) {
        this.lossless = lossless;
    }

    public void setQuality(int percent) {
        this.quality = percent;
    }

    public static void main(String[] args) throws IOException {
        String imgFileName = args[0];
        String swfFileName = args[1];
        BufferedImage img = ImageUtilities.loadImage(new FileInputStream(imgFileName));
        ImageDocumentFactory documentFactory = new ImageDocumentFactory(img);
        documentFactory.setLossless(true);
        SWFDocument document = documentFactory.getDocument();
        SWFWriter writer = new SWFWriter(document, new FileOutputStream(swfFileName));
        writer.write();
    }

    private Rect getShapeBounds() {
        int shapeWidth;
        int shapeHeight;
        int imageWidth = this.image.getWidth();
        int imageHeight = this.image.getHeight();
        if (!this.dimensionsSet) {
            return new Rect(0L, imageWidth * 20, 0L, imageHeight * 20);
        }
        if ((double)this.docWidth / (double)this.docHeight > (double)imageWidth / (double)imageHeight) {
            shapeHeight = this.docHeight * 20;
            shapeWidth = shapeHeight * imageWidth / imageHeight;
        } else {
            shapeWidth = this.docWidth * 20;
            shapeHeight = shapeWidth * imageHeight / imageWidth;
        }
        return new Rect(0L, shapeWidth, 0L, shapeHeight);
    }

    private DefineBitsJPEG2 createBitsJPEG2() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            if (this.quality >= 0) {
                ImageUtilities.saveImageAsJPEG(this.image, baos, this.quality);
            } else {
                ImageUtilities.saveImageAsJPEG(this.image, baos);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byte[] imageData = baos.toByteArray();
        int imageDataLength = imageData.length;
        int headerLength = JPEG_DATA_HEADER.length;
        byte[] extendedImageData = new byte[headerLength + imageDataLength];
        System.arraycopy(JPEG_DATA_HEADER, 0, extendedImageData, 0, headerLength);
        System.arraycopy(imageData, 0, extendedImageData, headerLength, imageDataLength);
        DefineBitsJPEG2 bitsJPEG2 = new DefineBitsJPEG2(this.doc.getNewCharacterId(), extendedImageData);
        return bitsJPEG2;
    }

    private DefineBitsLossless2 createBitsLossless2() {
        RGBA[] rgbaArray = ImageUtilities.getRGBAArray(this.image);
        AlphaBitmapData alphaBitmap = new AlphaBitmapData(rgbaArray);
        DefineBitsLossless2 bitsLossless2 = new DefineBitsLossless2(this.doc.getNewCharacterId(), 5, this.docWidth, this.docHeight, alphaBitmap);
        return bitsLossless2;
    }

    private DefineShape createImageShape(int imageCharacterId) {
        Rect shapeBounds = this.getShapeBounds();
        ShapeWithStyle styles = this.createShapeWithStyle(shapeBounds, imageCharacterId);
        DefineShape shape = new DefineShape(this.doc.getNewCharacterId(), shapeBounds, styles);
        return shape;
    }

    private PlaceObject2 createPlaceObject2Tag(int imageShapeCharacterId) {
        PlaceObject2 placeObject2 = new PlaceObject2(1);
        placeObject2.setCharacterId(imageShapeCharacterId);
        placeObject2.setMatrix(new Matrix(0, 0));
        return placeObject2;
    }

    private ShapeWithStyle createShapeWithStyle(Rect shapeBounds, int imageCharacterId) {
        Matrix bitmapMatrix = new Matrix(0, 0);
        int shapeXMax = (int)shapeBounds.getXMax();
        int shapeYMax = (int)shapeBounds.getYMax();
        bitmapMatrix.setScale((float)shapeXMax / (float)this.image.getWidth(), (float)shapeYMax / (float)this.image.getHeight());
        FillStyle fillStyle = new FillStyle(imageCharacterId, bitmapMatrix, 65);
        FillStyleArray fillStyles = new FillStyleArray();
        fillStyles.addStyle(fillStyle);
        ShapeRecord[] shapeRecords = new ShapeRecord[5];
        StyleChangeRecord styleChangeRecord = new StyleChangeRecord();
        styleChangeRecord.setFillStyle1(imageCharacterId);
        styleChangeRecord.setMoveTo(shapeXMax, shapeYMax);
        shapeRecords[0] = styleChangeRecord;
        shapeRecords[1] = new StraightEdgeRecord(-shapeXMax, 0);
        shapeRecords[2] = new StraightEdgeRecord(0, -shapeYMax);
        shapeRecords[3] = new StraightEdgeRecord(shapeXMax, 0);
        shapeRecords[4] = new StraightEdgeRecord(0, shapeYMax);
        ShapeWithStyle shapeWithStyle = new ShapeWithStyle(fillStyles, new LineStyleArray(), shapeRecords);
        return shapeWithStyle;
    }

    private void initDocument() {
        this.doc = new SWFDocument();
        if (!this.dimensionsSet) {
            this.docWidth = this.image.getWidth();
            this.docHeight = this.image.getHeight();
        }
        this.doc.setFrameSize(new Rect(0L, this.docWidth * 20, 0L, this.docHeight * 20));
        this.doc.setCompressed(true);
        if (this.backgroundColor != null) {
            this.doc.setBackgroundColor(this.backgroundColor);
        }
        DefinitionTag bitmapTag = this.lossless ? this.createBitsLossless2() : this.createBitsJPEG2();
        int imageCharacterId = bitmapTag.getCharacterId();
        this.doc.addTag(bitmapTag);
        DefineShape imageShape = this.createImageShape(imageCharacterId);
        this.doc.addTag(imageShape);
        this.doc.addTag(this.createPlaceObject2Tag(imageShape.getCharacterId()));
        this.doc.addTag(new ShowFrame());
    }
}

