/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.hl.factories;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import oracle.dss.graph.flash.jswiff.SWFDocument;
import oracle.dss.graph.flash.jswiff.SWFWriter;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.SoundInfo;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineSound;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.ShowFrame;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.SoundStreamHead2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.StartSound;

public class MP3DocumentFactory {
    private static final int[][] BIT_RATES = new int[][]{{0, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160, 0}, {0, 32, 40, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320, 0}};
    private static final int[][] SAMPLING_RATES = new int[][]{{11025, 12000, 8000, 0}, {0, 0, 0, 0}, {22050, 24000, 16000, 0}, {44100, 48000, 32000, 0}};
    private static final int[] CHANNELS = new int[]{2, 2, 2, 1};
    private static final int[] SAMPLES_PER_FRAME = new int[]{576, 576, 576, 1152};
    private byte[] mp3Data;
    private InputBitStream mp3BitStream;
    private byte[] soundData;
    private SWFDocument doc;
    private int sampleCount;
    private int channelCount;
    private int samplingRate;

    public MP3DocumentFactory(InputStream mp3Stream) throws IOException {
        int bytesRead;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1000];
        while ((bytesRead = mp3Stream.read(buffer)) > 0) {
            baos.write(buffer, 0, bytesRead);
        }
        this.mp3Data = baos.toByteArray();
        this.mp3BitStream = new InputBitStream(this.mp3Data);
    }

    public SWFDocument getDocument() throws IOException {
        this.initDocument();
        return this.doc;
    }

    public static void main(String[] args) throws IOException {
        String mp3FileName = args[0];
        String swfFileName = args[1];
        MP3DocumentFactory documentFactory = new MP3DocumentFactory(new FileInputStream(mp3FileName));
        SWFDocument document = documentFactory.getDocument();
        SWFWriter writer = new SWFWriter(document, new FileOutputStream(swfFileName));
        writer.write();
    }

    private byte getSamplingRateCode() {
        switch (this.samplingRate) {
            case 11025: {
                return 1;
            }
            case 22050: {
                return 2;
            }
            case 44100: {
                return 3;
            }
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void countSamples() throws IOException {
        this.sampleCount = 0;
        while (true) {
            int mpegVersion = (int)this.mp3BitStream.readUnsignedBits(2);
            this.mp3BitStream.readUnsignedBits(2);
            this.mp3BitStream.readBooleanBit();
            int bitRate = BIT_RATES[mpegVersion][(int)this.mp3BitStream.readUnsignedBits(4)];
            this.samplingRate = SAMPLING_RATES[mpegVersion][(int)this.mp3BitStream.readUnsignedBits(2)];
            if (bitRate == 0 || this.samplingRate == 0) {
                if (!this.findNextFrame()) return;
                continue;
            }
            int padding = (int)this.mp3BitStream.readUnsignedBits(1);
            this.mp3BitStream.readBooleanBit();
            this.channelCount = CHANNELS[(int)this.mp3BitStream.readUnsignedBits(2)];
            this.mp3BitStream.readUnsignedBits(6);
            this.sampleCount += SAMPLES_PER_FRAME[mpegVersion];
            int frameSize = (mpegVersion == 3 ? 144 : 72) * bitRate * 1000 / this.samplingRate + padding - 4;
            this.mp3BitStream.move(frameSize);
            if (!this.findNextFrame()) return;
        }
    }

    private boolean findNextFrame() {
        try {
            while (true) {
                if (this.mp3BitStream.readUI8() != 255) {
                    continue;
                }
                long value = this.mp3BitStream.readUnsignedBits(3);
                if (value == (long)7) {
                    boolean bl = true;
                    return bl;
                }
                this.mp3BitStream.align();
            }
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
    }

    private void initDocument() throws IOException {
        this.doc = new SWFDocument();
        this.doc.setCompressed(true);
        this.initSoundData();
        this.countSamples();
        this.doc.addTag(new SoundStreamHead2(2, this.getSamplingRateCode(), true, this.channelCount == 2, 0));
        int soundId = this.doc.getNewCharacterId();
        this.doc.addTag(new DefineSound(soundId, 2, this.getSamplingRateCode(), true, this.channelCount == 2, this.sampleCount, this.soundData));
        this.doc.addTag(new StartSound(soundId, new SoundInfo()));
        this.doc.addTag(new ShowFrame());
    }

    private void initSoundData() throws IOException {
        if (!this.findNextFrame()) {
            throw new IOException("MP3 stream contains no frames!");
        }
        int offset = (int)(this.mp3BitStream.getOffset() - (long)2);
        this.soundData = new byte[this.mp3Data.length - offset + 2];
        this.soundData[0] = 0;
        this.soundData[1] = 0;
        System.arraycopy(this.mp3Data, offset, this.soundData, 2, this.mp3Data.length - offset);
    }
}

