/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.hl.factories;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import oracle.dss.graph.flash.jswiff.SWFDocument;
import oracle.dss.graph.flash.jswiff.SWFWriter;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.SoundInfo;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineSound;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.ShowFrame;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.SoundStreamHead2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.StartSound;

public class WAVDocumentFactory {
    private static final int WAVE_FORMAT_DESCRIPTOR = 1163280727;
    private static final int RIFF_CHUNK_DESCRIPTOR = 1179011410;
    private static final int FMT_SUBCHUNK_DESCRIPTOR = 544501094;
    private static final int DATA_SUBCHUNK_DESCRIPTOR = 1635017060;
    private InputBitStream wavBitStream;
    private byte[] soundData;
    private SWFDocument doc;
    private int sampleCount;
    private int sampleSize;
    private int channelCount;
    private int samplingRate;
    private boolean is16BitSample;

    public WAVDocumentFactory(AudioInputStream audioInputStream) throws IOException {
        audioInputStream = AudioSystem.getAudioInputStream(AudioFormat.Encoding.PCM_SIGNED, audioInputStream);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        AudioSystem.write(audioInputStream, AudioFileFormat.Type.WAVE, baos);
        byte[] buffer = baos.toByteArray();
        this.wavBitStream = new InputBitStream(new ByteArrayInputStream(buffer));
    }

    public WAVDocumentFactory(InputStream wavStream) throws IOException {
        this.wavBitStream = new InputBitStream(wavStream);
    }

    public SWFDocument getDocument() throws IOException {
        this.initDocument();
        return this.doc;
    }

    public static AudioInputStream convertSampleRate(AudioInputStream audioInputStream, float sampleRate) {
        AudioFormat sourceFormat = audioInputStream.getFormat();
        AudioFormat targetFormat = new AudioFormat(sourceFormat.getEncoding(), sampleRate, sourceFormat.getSampleSizeInBits(), sourceFormat.getChannels(), sourceFormat.getFrameSize(), sampleRate, sourceFormat.isBigEndian());
        return AudioSystem.getAudioInputStream(targetFormat, audioInputStream);
    }

    public static void main(String[] args) throws IOException, UnsupportedAudioFileException {
        String wavFileName = args[0];
        String swfFileName = args[1];
        WAVDocumentFactory documentFactory = wavFileName.toLowerCase().endsWith("wav") ? new WAVDocumentFactory(new FileInputStream(wavFileName)) : new WAVDocumentFactory(AudioSystem.getAudioInputStream(new BufferedInputStream(new FileInputStream(wavFileName), 1024)));
        SWFDocument document = documentFactory.getDocument();
        SWFWriter writer = new SWFWriter(document, new FileOutputStream(swfFileName));
        writer.write();
    }

    private byte getSamplingRateCode() throws IOException {
        switch (this.samplingRate) {
            case 5512: {
                return 0;
            }
            case 11025: {
                return 1;
            }
            case 22050: {
                return 2;
            }
            case 44100: {
                return 3;
            }
        }
        throw new IOException("Unsupported sampling rate: " + this.samplingRate);
    }

    private void initDocument() throws IOException {
        this.doc = new SWFDocument();
        this.doc.setCompressed(true);
        this.readData();
        this.doc.addTag(new SoundStreamHead2(0, this.getSamplingRateCode(), this.is16BitSample, this.channelCount == 2, 0));
        int soundId = this.doc.getNewCharacterId();
        this.doc.addTag(new DefineSound(soundId, 0, this.getSamplingRateCode(), this.is16BitSample, this.channelCount == 2, this.sampleCount, this.soundData));
        this.doc.addTag(new StartSound(soundId, new SoundInfo()));
        this.doc.addTag(new ShowFrame());
    }

    private void readData() throws IOException {
        if (this.wavBitStream.readUI32() != 1179011410L) {
            throw new IOException("Illegal WAV format, RIFF chunk descriptor missing!");
        }
        this.wavBitStream.readUI32();
        if (this.wavBitStream.readUI32() != 1163280727L) {
            throw new IOException("Illegal WAV format, WAVE format descriptor missing!");
        }
        boolean dataSubchunkFound = false;
        while (!dataSubchunkFound) {
            long subchunkID = this.wavBitStream.readUI32();
            long subchunkSize = this.wavBitStream.readUI32();
            byte[] subchunkData = this.wavBitStream.readBytes((int)subchunkSize);
            if (subchunkID == 544501094L) {
                this.readFMTSubchunk(subchunkData);
                continue;
            }
            if (subchunkID != 1635017060L) continue;
            this.soundData = subchunkData;
            this.sampleCount = (int)(subchunkSize * (long)8 / (long)(this.sampleSize * this.channelCount));
            dataSubchunkFound = true;
        }
    }

    private void readFMTSubchunk(byte[] subchunkData) throws IOException {
        InputBitStream fmtBitStream = new InputBitStream(subchunkData);
        int format = fmtBitStream.readUI16();
        if (format != 1) {
            throw new IOException("Compressed WAV found, only linear quantization (PCM) supported!");
        }
        this.channelCount = fmtBitStream.readUI16();
        this.samplingRate = (int)fmtBitStream.readUI32();
        fmtBitStream.readUI32();
        fmtBitStream.readUI16();
        this.sampleSize = fmtBitStream.readUI16();
        this.is16BitSample = this.sampleSize == 16;
    }
}

