/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.investigator;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.dss.graph.flash.jswiff.SWFDocument;
import oracle.dss.graph.flash.jswiff.SWFReader;
import oracle.dss.graph.flash.jswiff.SWFWriter;
import oracle.dss.graph.flash.jswiff.investigator.ProgressDialog;
import oracle.dss.graph.flash.jswiff.investigator.SWFTreeListener;
import oracle.dss.graph.flash.jswiff.listeners.SWFDocumentReader;

public final class Investigator
extends JFrame {
    static int threadCounter = 0;
    File file;
    JPanel treePanel;
    JTree tree;
    private JToolBar statusBar;
    JTextField searchTextField;
    private JCheckBox caseSenseCheckBox;
    private JCheckBox backwardsCheckBox;
    JButton expandButton;
    private JButton findButton;
    JButton refreshButton;
    JButton openButton;
    JButton infoButton;
    private JButton copyButton;
    DefaultMutableTreeNode rootNode;
    int nodeNumber;
    private Clipboard clipboard;

    private void $init$() {
        this.clipboard = this.getToolkit().getSystemClipboard();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new 1(args));
        ++threadCounter;
    }

    void copy() {
        TreePath[] selectionPaths = this.tree.getSelectionPaths();
        if (selectionPaths == null) {
            return;
        }
        StringBuffer nodeStringBuffer = new StringBuffer();
        int minDepth = Integer.MAX_VALUE;
        int i = 0;
        while (i < selectionPaths.length) {
            TreePath selectionPath = selectionPaths[i];
            minDepth = Math.min(minDepth, selectionPath.getPath().length);
            ++i;
        }
        int i2 = 0;
        while (i2 < selectionPaths.length) {
            TreePath selectionPath = selectionPaths[i2];
            if (selectionPath != null) {
                TreeNode selectedNode = (TreeNode)selectionPath.getLastPathComponent();
                if (i2 > 0) {
                    nodeStringBuffer.append("\n");
                }
                int depth = selectionPath.getPath().length - minDepth;
                int j = 0;
                while (j < depth) {
                    nodeStringBuffer.append(' ');
                    ++j;
                }
                nodeStringBuffer.append(this.filterHTML(selectedNode.toString()));
            }
            ++i2;
        }
        this.clipboard.setContents(new NodeStringTransferable(nodeStringBuffer.toString()), null);
    }

    void displayInfo() {
        this.infoButton.setEnabled(false);
        SplashWindow splashWindow = new SplashWindow(this);
        splashWindow.enableCloseOnClick();
    }

    void displayNodeNumber() {
        this.displayStatus(this.nodeNumber + " nodes.");
    }

    void displayStatus(String status) {
        this.statusBar.removeAll();
        this.statusBar.add(new JLabel(status));
        this.statusBar.revalidate();
        this.statusBar.repaint();
    }

    void displayTree() {
        this.treePanel.removeAll();
        this.rootNode = new DefaultMutableTreeNode(this.file.getAbsolutePath());
        this.tree = new JTree(this.rootNode);
        this.tree.setFont(new Font("Arial Unicode MS", 0, 11));
        this.setAccelerators(this.tree);
        this.read();
        this.tree.setScrollsOnExpand(true);
        this.tree.setRootVisible(true);
        this.tree.setShowsRootHandles(true);
        this.treePanel.add(new JScrollPane(this.tree));
        this.treePanel.revalidate();
        this.treePanel.repaint();
        this.displayStatus(this.nodeNumber + " nodes read.");
    }

    void duplicateFiles() {
        JFileChooser chooser = new JFileChooser(this.file);
        chooser.setFileFilter(new SWFFileFilter(null));
        chooser.setMultiSelectionEnabled(true);
        chooser.setDialogTitle("Choose files to duplicate");
        File[] sourceFiles = null;
        if (chooser.showOpenDialog(this) == 0) {
            sourceFiles = chooser.getSelectedFiles();
        }
        if (sourceFiles != null && sourceFiles.length > 0) {
            try {
                int i = 0;
                while (i < sourceFiles.length) {
                    File sourceFile = sourceFiles[i];
                    System.out.println("Duplicating " + sourceFile);
                    String destPathString = sourceFile.getParentFile().getAbsolutePath() + File.separatorChar + "copies";
                    new File(destPathString).mkdir();
                    File destFile = new File(destPathString + File.separatorChar + sourceFile.getName());
                    SWFReader reader = new SWFReader(new FileInputStream(sourceFile));
                    SWFDocumentReader docReader = new SWFDocumentReader();
                    reader.addListener(docReader);
                    reader.read();
                    SWFDocument doc = docReader.getDocument();
                    SWFWriter writer = new SWFWriter(doc, new FileOutputStream(destFile));
                    writer.write();
                    ++i;
                }
                JOptionPane.showMessageDialog(this, sourceFiles.length + " files processed - check console for details.", "Completed", 1);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    void expand() {
        this.tree.setScrollsOnExpand(false);
        Enumeration<TreeNode> en = this.rootNode.postorderEnumeration();
        ProgressDialog progressDialog = new ProgressDialog(this, "Expanding tree...", "Expanded nodes:", "0", 0, this.nodeNumber, true);
        int nodeCounter = 0;
        progressDialog.setProgressValue(nodeCounter);
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)en.nextElement();
            if (node.isLeaf()) {
                this.tree.makeVisible(this.getPath(node));
            }
            if ((++nodeCounter & 0xF) != 0) continue;
            if (progressDialog.isCanceled()) break;
            progressDialog.setProgressValue(nodeCounter);
            progressDialog.setNote(Integer.toString(nodeCounter));
        }
        progressDialog.close();
        this.expandButton.setEnabled(true);
        this.openButton.setEnabled(true);
        this.refreshButton.setEnabled(true);
        this.tree.setScrollsOnExpand(true);
    }

    void expandRoot() {
        this.tree.expandPath(new TreePath(this.rootNode));
    }

    void expandTree() {
        2 expandThread = new 2();
        this.expandButton.setEnabled(false);
        this.openButton.setEnabled(false);
        this.refreshButton.setEnabled(false);
        expandThread.start();
    }

    void find(String searchText) {
        if (searchText.length() == 0) {
            return;
        }
        boolean backwards = this.backwardsCheckBox.isSelected();
        boolean caseSense = this.caseSenseCheckBox.isSelected();
        TreePath selectionPath = this.tree.getSelectionPath();
        TreeNode selectedNode = selectionPath == null ? this.rootNode : (TreeNode)selectionPath.getLastPathComponent();
        this.findButton.setEnabled(false);
        TreeNode foundNode = this.findNode(selectedNode, searchText, caseSense, backwards);
        if (foundNode == null) {
            this.displayStatus("\"" + searchText + "\" not found!");
        } else {
            TreePath foundPath = this.getPath(foundNode);
            this.tree.setSelectionPath(foundPath);
            this.tree.scrollPathToVisible(foundPath);
        }
        this.findButton.setEnabled(true);
    }

    void openFile() {
        if (this.chooseFile()) {
            this.displayTree();
        }
    }

    void run(String[] args) {
        this.setLAF();
        this.setExtendedState(6);
        this.setVisible(true);
        if (threadCounter == 1) {
            new SplashWindow(this, 5000L).enableCloseOnClick();
        }
        if (args.length != 0) {
            this.file = new File(args[0]);
            if (!this.file.exists() || !this.file.canRead()) {
                JOptionPane.showMessageDialog(this, "Cannot read file " + args[0] + ", please choose another SWF file!", "Error", 0);
                this.file = null;
                this.setTitle("Choose SWF file...");
                this.chooseFile();
            }
        } else {
            this.setTitle("Choose SWF file...");
            this.chooseFile();
        }
        if (this.file == null) {
            System.exit(0);
        }
        this.setTitle();
        this.display();
        this.displayTree();
        this.setVisible(false);
        this.pack();
        this.setExtendedState(6);
        this.setVisible(true);
    }

    private void setAccelerators(JComponent component) {
        component.getActionMap().put("Refresh", new 3("Refresh"));
        component.getInputMap().put(KeyStroke.getKeyStroke(116, 0), "Refresh");
        component.getActionMap().put("Copy", new 4("Copy"));
        component.getInputMap().put(KeyStroke.getKeyStroke("control C"), "Copy");
        component.getActionMap().put("Expand", new 5("Expand"));
        component.getInputMap().put(KeyStroke.getKeyStroke("control E"), "Expand");
        component.getActionMap().put("Find", new 6("Find"));
        component.getInputMap().put(KeyStroke.getKeyStroke(114, 0), "Find");
        component.getActionMap().put("Open", new 7("Open"));
        component.getInputMap().put(KeyStroke.getKeyStroke("control O"), "Open");
        component.getActionMap().put("New", new 8("New"));
        component.getInputMap().put(KeyStroke.getKeyStroke("control N"), "New");
        component.getActionMap().put("Duplicate", new 9("Duplicate"));
        component.getInputMap().put(KeyStroke.getKeyStroke("control D"), "Duplicate");
    }

    private void setLAF() {
        try {
            UIManager.setLookAndFeel("oracle.dss.graph.flash.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private TreePath getPath(TreeNode node) {
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        while (node != null) {
            list.add(node);
            node = node.getParent();
        }
        Collections.reverse(list);
        return new TreePath(list.toArray());
    }

    private void setTitle() {
        this.setTitle("JSwiff Investigator - " + this.file);
    }

    private boolean chooseFile() {
        JFileChooser chooser = this.file != null ? new JFileChooser(this.file) : new JFileChooser();
        chooser.setFileFilter(new SWFFileFilter(null));
        if (chooser.showOpenDialog(this) != 0) {
            return false;
        }
        this.file = chooser.getSelectedFile();
        this.setTitle();
        return true;
    }

    private void display() {
        this.addWindowListener(new 10());
        JToolBar toolBar = new JToolBar();
        this.setAccelerators(toolBar);
        this.displayToolBar(toolBar);
        this.initTreePanel();
        this.getContentPane().add((Component)toolBar, "North");
        this.getContentPane().add(this.treePanel);
        this.statusBar = new JToolBar();
        this.setAccelerators(this.statusBar);
        this.statusBar.setFloatable(false);
        this.getContentPane().add((Component)this.statusBar, "South");
    }

    private void displayToolBar(JToolBar toolBar) {
        toolBar.setFloatable(false);
        this.openButton = new JButton("Open");
        this.openButton.setToolTipText("Open new file (Ctrl+O)");
        this.openButton.addActionListener(new 11());
        this.openButton.addMouseListener(new 12());
        this.refreshButton = new JButton("Refresh");
        this.refreshButton.setToolTipText("Refresh tree (F5)");
        this.refreshButton.addActionListener(new 13());
        this.refreshButton.addMouseListener(new 14());
        this.expandButton = new JButton("Expand");
        this.expandButton.setToolTipText("Expand all nodes (Ctrl+E)");
        this.expandButton.addActionListener(new 15());
        this.expandButton.addMouseListener(new 16());
        this.findButton = new JButton("Find: ");
        this.findButton.setToolTipText("Find text (F3)");
        this.findButton.addActionListener(new 17());
        this.findButton.addMouseListener(new 18());
        this.copyButton = new JButton("Copy");
        this.copyButton.setToolTipText("Copies selected nodes (Ctrl+C)");
        this.copyButton.addActionListener(new 19());
        this.copyButton.addMouseListener(new 20());
        this.caseSenseCheckBox = new JCheckBox("Case sensitive");
        this.caseSenseCheckBox.setToolTipText("Perform case sensitive searches");
        this.setAccelerators(this.caseSenseCheckBox);
        this.backwardsCheckBox = new JCheckBox("Backwards");
        this.backwardsCheckBox.setToolTipText("Search backwards");
        this.setAccelerators(this.backwardsCheckBox);
        this.searchTextField = new JTextField();
        this.searchTextField.setToolTipText("Enter search text");
        this.searchTextField.addMouseListener(new 21());
        this.searchTextField.addKeyListener(new 22());
        this.infoButton = new JButton("Info");
        this.infoButton.setToolTipText("Displays program info");
        this.infoButton.addActionListener(new 23());
        this.infoButton.addMouseListener(new 24());
        toolBar.add(this.openButton);
        toolBar.addSeparator();
        toolBar.add(this.refreshButton);
        toolBar.addSeparator();
        toolBar.add(this.expandButton);
        toolBar.addSeparator();
        toolBar.add(this.copyButton);
        toolBar.addSeparator();
        toolBar.add(this.findButton);
        toolBar.add(this.searchTextField);
        toolBar.add(this.caseSenseCheckBox);
        toolBar.add(this.backwardsCheckBox);
        toolBar.addSeparator();
        toolBar.add(this.infoButton);
    }

    private String filterHTML(String string) {
        StringBuffer result = new StringBuffer();
        boolean tag = false;
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            if (c == '<') {
                tag = true;
            } else if (c == '>') {
                tag = false;
            } else if (!tag) {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    private TreeNode findNode(TreeNode selectedNode, String searchText, boolean caseSense, boolean backwards) {
        block2: {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectedNode;
            if (!caseSense) {
                searchText = searchText.toUpperCase();
            }
            do {
                DefaultMutableTreeNode defaultMutableTreeNode = node = backwards ? node.getPreviousNode() : node.getNextNode();
                if (node == null) break block2;
            } while ((!caseSense || node.toString().lastIndexOf(searchText) == -1) && (caseSense || node.toString().toUpperCase().lastIndexOf(searchText) == -1));
            return node;
        }
        return null;
    }

    private void initTreePanel() {
        this.treePanel = new JPanel();
        this.treePanel.setLayout(new GridLayout(1, 1));
        this.setAccelerators(this.treePanel);
    }

    private void read() {
        25 readThread = new 25();
        readThread.start();
    }

    public Investigator() {
        this.$init$();
    }

    static final class 1
    implements Runnable {
        private final /* synthetic */ String[] v$args;

        public void run() {
            Investigator investigator = new Investigator();
            URL logoUrl = this.getClass().getResource("/com/jswiff/investigator/resources/logo16x16.png");
            investigator.setIconImage(new ImageIcon(logoUrl).getImage());
            investigator.run(this.v$args);
        }

        public 1(String[] stringArray) {
            this.v$args = stringArray;
        }
    }

    final class 2
    extends Thread {
        public void run() {
            Investigator.this.expand();
        }
    }

    final class 3
    extends AbstractAction {
        public void actionPerformed(ActionEvent evt) {
            Investigator.this.displayTree();
        }

        public 3(String string) {
            super(string);
        }
    }

    final class 4
    extends AbstractAction {
        public void actionPerformed(ActionEvent evt) {
            Investigator.this.copy();
        }

        public 4(String string) {
            super(string);
        }
    }

    final class 5
    extends AbstractAction {
        public void actionPerformed(ActionEvent evt) {
            Investigator.this.expand();
        }

        public 5(String string) {
            super(string);
        }
    }

    final class 6
    extends AbstractAction {
        public void actionPerformed(ActionEvent evt) {
            Investigator.this.find(Investigator.this.searchTextField.getText());
        }

        public 6(String string) {
            super(string);
        }
    }

    final class 7
    extends AbstractAction {
        public void actionPerformed(ActionEvent evt) {
            Investigator.this.openFile();
        }

        public 7(String string) {
            super(string);
        }
    }

    final class 8
    extends AbstractAction {
        public void actionPerformed(ActionEvent evt) {
            String[] args = new String[]{Investigator.this.file.getAbsolutePath()};
            Investigator.main(args);
        }

        public 8(String string) {
            super(string);
        }
    }

    final class 9
    extends AbstractAction {
        public void actionPerformed(ActionEvent evt) {
            Investigator.this.duplicateFiles();
        }

        public 9(String string) {
            super(string);
        }
    }

    final class 10
    extends WindowAdapter {
        public void windowClosing(WindowEvent e) {
            if (threadCounter > 1) {
                --threadCounter;
                Investigator.this.setVisible(false);
                Investigator.this.dispose();
            } else {
                System.exit(0);
            }
        }
    }

    final class 11
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            Investigator.this.openFile();
        }
    }

    final class 12
    extends MouseAdapter {
        public void mouseEntered(MouseEvent e) {
            Investigator.this.displayStatus("Opens a new file.");
        }

        public void mouseExited(MouseEvent e) {
            Investigator.this.displayNodeNumber();
        }
    }

    final class 13
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            Investigator.this.displayTree();
        }
    }

    final class 14
    extends MouseAdapter {
        public void mouseEntered(MouseEvent e) {
            Investigator.this.displayStatus("Reads the file again and refreshes the tree view.");
        }

        public void mouseExited(MouseEvent e) {
            Investigator.this.displayNodeNumber();
        }
    }

    final class 15
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            Investigator.this.expandTree();
        }
    }

    final class 16
    extends MouseAdapter {
        public void mouseEntered(MouseEvent e) {
            Investigator.this.displayStatus("Expands all nodes of the tree. This may take long for big files.");
        }

        public void mouseExited(MouseEvent e) {
            Investigator.this.displayNodeNumber();
        }
    }

    final class 17
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            Investigator.this.find(Investigator.this.searchTextField.getText());
        }
    }

    final class 18
    extends MouseAdapter {
        public void mouseEntered(MouseEvent e) {
            Investigator.this.displayStatus("Searches for text in the tree, starting at the selected node.");
        }

        public void mouseExited(MouseEvent e) {
            Investigator.this.displayNodeNumber();
        }
    }

    final class 19
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            Investigator.this.copy();
        }
    }

    final class 20
    extends MouseAdapter {
        public void mouseEntered(MouseEvent e) {
            Investigator.this.displayStatus("Copies selected nodes to clipboard. Use Ctrl/Shift for multiple selections. Selection order and indentation levels are preserved.");
        }

        public void mouseExited(MouseEvent e) {
            Investigator.this.displayNodeNumber();
        }
    }

    final class 21
    extends MouseAdapter {
        public void mouseEntered(MouseEvent e) {
            Investigator.this.displayStatus("Enter here the text you want to search for.");
        }

        public void mouseExited(MouseEvent e) {
            Investigator.this.displayNodeNumber();
        }
    }

    final class 22
    implements KeyListener {
        public void keyPressed(KeyEvent e) {
            if (e.getKeyChar() == '\n') {
                Investigator.this.find(Investigator.this.searchTextField.getText());
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }
    }

    final class 23
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            Investigator.this.displayInfo();
        }
    }

    final class 24
    extends MouseAdapter {
        public void mouseEntered(MouseEvent e) {
            Investigator.this.displayStatus("Displays information about the program.");
        }

        public void mouseExited(MouseEvent e) {
            Investigator.this.displayNodeNumber();
        }
    }

    final class 25
    extends Thread {
        public void run() {
            SWFReader reader;
            Investigator.this.expandButton.setEnabled(false);
            Investigator.this.openButton.setEnabled(false);
            Investigator.this.refreshButton.setEnabled(false);
            try {
                reader = new SWFReader(new FileInputStream(Investigator.this.file));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return;
            }
            SWFTreeListener listener = new SWFTreeListener(Investigator.this.rootNode, Investigator.this);
            reader.addListener(listener);
            reader.read();
            Investigator.this.nodeNumber = listener.getNodeNumber() + 1;
            Investigator.this.displayNodeNumber();
            Investigator.this.tree.setScrollsOnExpand(true);
            Investigator.this.tree.setRootVisible(true);
            Investigator.this.tree.setShowsRootHandles(true);
            Investigator.this.expandButton.setEnabled(true);
            Investigator.this.openButton.setEnabled(true);
            Investigator.this.refreshButton.setEnabled(true);
            Investigator.this.treePanel.revalidate();
            Investigator.this.treePanel.repaint();
            System.gc();
            if (listener.isProtected()) {
                JOptionPane.showMessageDialog(Investigator.this, "This SWF document contains a Protect tag. Make sure you don't violate any copyrights!", "Protected SWF", 2);
            }
        }
    }

    private final class SWFFileFilter
    extends FileFilter {
        public String getDescription() {
            return "Flash files (*.swf)";
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName().toLowerCase();
            return name.endsWith(".swf");
        }

        private SWFFileFilter() {
        }

        SWFFileFilter(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class SplashWindow
    extends JWindow {
        private boolean showLicense;

        public SplashWindow(Frame f) {
            super(f);
            this.showLicense = true;
            this.openSplash(f);
        }

        public SplashWindow(Frame f, long millisecs) {
            super(f);
            1 splashThread = new 1(this, f, millisecs);
            splashThread.start();
        }

        public void enableCloseOnClick() {
            this.addMouseListener(new 2());
        }

        void closeSplash() {
            this.setVisible(false);
            this.dispose();
            if (Investigator.this.infoButton != null) {
                Investigator.this.infoButton.setEnabled(true);
            }
        }

        void openSplash(Frame f) {
            JPanel infoPane = new JPanel(new FlowLayout(1, 20, 0));
            URL logoUrl = ClassLoader.getSystemResource("com/jswiff/investigator/resources/logo.png");
            JLabel logo = new JLabel(new ImageIcon(logoUrl));
            logo.setBorder(new BevelBorder(1));
            infoPane.add(logo);
            JLabel copy = new JLabel("<html><h3>JSwiff Investigator (v 8.0-beta-1)</h3>This software is free, you are welcome to redistribute it<br>under the terms of the GNU General Public License.<br><p>Part of <b>JSwiff</b>, an open source Java framework<br>for Macromedia Flash file generation and manipulation.<br>More information at http://www.jswiff.com<br><br>&copy;&nbsp; 2004-2005 Ralf Terdic.<br></<html>");
            infoPane.add(copy);
            JPanel mainPane = new JPanel();
            mainPane.setLayout(new BoxLayout(mainPane, 1));
            mainPane.setBorder(new SoftBevelBorder(0));
            mainPane.add(infoPane);
            if (this.showLicense) {
                JScrollPane licenseScrollPane = this.getLicenseScrollPane();
                mainPane.add(licenseScrollPane);
            }
            this.getContentPane().add(mainPane);
            this.pack();
            this.setLocationRelativeTo(f);
            this.setVisible(true);
        }

        private JScrollPane getLicenseScrollPane() {
            URL licenseUrl = this.getClass().getResource("/com/jswiff/investigator/resources/license.html");
            JEditorPane licensePane = new JEditorPane();
            licensePane.setEditable(false);
            licensePane.setContentType("text/html");
            try {
                licensePane.setPage(licenseUrl);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            JScrollPane licenseScrollPane = new JScrollPane(licensePane);
            licenseScrollPane.setPreferredSize(new Dimension(440, 150));
            licenseScrollPane.setMaximumSize(new Dimension(440, 150));
            licenseScrollPane.setBorder(new SoftBevelBorder(1));
            return licenseScrollPane;
        }

        final class 1
        extends Thread {
            private final /* synthetic */ Frame v$f;
            private final /* synthetic */ long v$millisecs;
            final /* synthetic */ SplashWindow this$0;

            public void run() {
                this.this$0.openSplash(this.v$f);
                try {
                    try {
                        Thread.sleep(this.v$millisecs);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                finally {
                    this.this$0.closeSplash();
                }
            }

            public 1(SplashWindow splashWindow, Frame frame, long l) {
                this.v$millisecs = l;
                this.v$f = frame;
                this.this$0 = splashWindow;
            }
        }

        final class 2
        extends MouseAdapter {
            public void mousePressed(MouseEvent e) {
                SplashWindow.this.closeSplash();
            }
        }
    }

    private class NodeStringTransferable
    implements Transferable {
        private String nodeString;
        private DataFlavor stringFlavor;

        private void $init$() {
            this.stringFlavor = new DataFlavor(String.class, "String");
        }

        public NodeStringTransferable(String nodeString) {
            this.$init$();
            this.nodeString = nodeString;
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor == this.stringFlavor;
        }

        public Object getTransferData(DataFlavor flavor) {
            return this.nodeString;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{this.stringFlavor};
        }
    }
}

