/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.investigator;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.UIManager;

final class ProgressDialog {
    private JDialog myDialog;
    private JOptionPane pane;
    private JProgressBar myBar;
    private JLabel noteLabel;
    private JLabel messageLabel;
    private Component myParentComponent;
    private String note;
    private String myTitle;
    private String message;
    Object[] selectionOptions;
    private int minValue;
    private int maxValue;
    private int lastDisp;
    private int reportDelta;
    boolean hasCancelButton;

    ProgressDialog(Component parentComponent, String title, String message, String note, int minValue, int maxValue, boolean hasCancelButton) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.myParentComponent = parentComponent;
        if (hasCancelButton) {
            this.selectionOptions = new Object[1];
            this.selectionOptions[0] = UIManager.getString("OptionPane.cancelButtonText");
        } else {
            this.selectionOptions = new Object[0];
        }
        this.reportDelta = (maxValue - minValue) / 100;
        if (this.reportDelta < 1) {
            this.reportDelta = 1;
        }
        this.myTitle = title;
        this.message = message;
        this.note = note;
        this.hasCancelButton = hasCancelButton;
    }

    boolean isCanceled() {
        if (this.pane == null) {
            return false;
        }
        Object paneValue = this.pane.getValue();
        return paneValue != null && this.selectionOptions.length == 1 && paneValue.equals(this.selectionOptions[0]);
    }

    void setMessage(String message) {
        this.message = message;
        if (this.messageLabel != null) {
            this.messageLabel.setText(message);
        }
    }

    void setNote(String note) {
        this.note = note;
        if (this.noteLabel != null) {
            this.noteLabel.setText(note);
        }
    }

    void setProgressValue(int newValue) {
        if (this.myBar == null) {
            this.displayWindow();
        }
        if (newValue >= this.maxValue) {
            this.close();
        } else if (newValue >= this.lastDisp + this.reportDelta) {
            this.lastDisp = newValue;
            this.myBar.setValue(newValue);
        }
    }

    void close() {
        if (this.myDialog != null) {
            this.myDialog.setVisible(false);
            this.myDialog.dispose();
            this.myDialog = null;
            this.pane = null;
            this.myBar = null;
        }
    }

    private void displayWindow() {
        this.myBar = new JProgressBar();
        this.myBar.setMinimum(this.minValue);
        this.myBar.setMaximum(this.maxValue);
        if (this.note != null) {
            this.noteLabel = new JLabel(this.note);
            this.messageLabel = new JLabel(this.message);
        }
        this.pane = new ProgressOptionPane(new Object[]{this.messageLabel, this.noteLabel, this.myBar});
        this.myDialog = this.pane.createDialog(this.myParentComponent, this.myTitle);
        this.myDialog.setDefaultCloseOperation(0);
        this.myDialog.show();
    }

    private class ProgressOptionPane
    extends JOptionPane {
        ProgressOptionPane(Object messageList) {
            super(messageList, -1, -1, null, ProgressDialog.this.selectionOptions, null);
        }

        public JDialog createDialog(Component parentComponent, String title) {
            Frame frame = JOptionPane.getFrameForComponent(parentComponent);
            JDialog dialog = new JDialog(frame, title, false);
            dialog.setResizable(false);
            Container contentPane = dialog.getContentPane();
            contentPane.add((Component)this, "Center");
            dialog.pack();
            dialog.setSize((int)((double)dialog.getSize().width * 1.5), dialog.getSize().height);
            dialog.setLocationRelativeTo(parentComponent);
            dialog.addWindowListener(new 1());
            this.addPropertyChangeListener(new 2(this, dialog));
            return dialog;
        }

        final class 1
        extends WindowAdapter {
            boolean gotFocus;

            private void $init$() {
                this.gotFocus = false;
            }

            public void windowClosing(WindowEvent we) {
                if (ProgressDialog.this.hasCancelButton) {
                    ProgressOptionPane.this.setValue(ProgressDialog.this.selectionOptions[0]);
                }
            }

            public void windowActivated(WindowEvent we) {
                if (!this.gotFocus) {
                    ProgressOptionPane.this.selectInitialValue();
                    this.gotFocus = true;
                }
            }

            public 1() {
                this.$init$();
            }
        }

        final class 2
        implements PropertyChangeListener {
            private final /* synthetic */ JDialog v$dialog;
            final /* synthetic */ ProgressOptionPane this$0;

            public void propertyChange(PropertyChangeEvent event) {
                if (this.v$dialog.isVisible() && event.getSource() == this.this$0 && (event.getPropertyName().equals("value") || event.getPropertyName().equals("inputValue"))) {
                    this.v$dialog.setVisible(false);
                    this.v$dialog.dispose();
                }
            }

            public 2(ProgressOptionPane progressOptionPane, JDialog jDialog) {
                this.v$dialog = jDialog;
                this.this$0 = progressOptionPane;
            }
        }
    }
}

