/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.investigator;

import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dss.graph.flash.jswiff.swfrecords.AlignmentZone;
import oracle.dss.graph.flash.jswiff.swfrecords.AlphaBitmapData;
import oracle.dss.graph.flash.jswiff.swfrecords.AlphaColorMapData;
import oracle.dss.graph.flash.jswiff.swfrecords.BevelFilter;
import oracle.dss.graph.flash.jswiff.swfrecords.BitmapData;
import oracle.dss.graph.flash.jswiff.swfrecords.BlendMode;
import oracle.dss.graph.flash.jswiff.swfrecords.BlurFilter;
import oracle.dss.graph.flash.jswiff.swfrecords.ButtonCondAction;
import oracle.dss.graph.flash.jswiff.swfrecords.ButtonRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.CXform;
import oracle.dss.graph.flash.jswiff.swfrecords.CXformWithAlpha;
import oracle.dss.graph.flash.jswiff.swfrecords.ClipActionRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.ClipActions;
import oracle.dss.graph.flash.jswiff.swfrecords.ClipEventFlags;
import oracle.dss.graph.flash.jswiff.swfrecords.ColorMapData;
import oracle.dss.graph.flash.jswiff.swfrecords.ColorMatrixFilter;
import oracle.dss.graph.flash.jswiff.swfrecords.ConvolutionFilter;
import oracle.dss.graph.flash.jswiff.swfrecords.CurvedEdgeRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.DropShadowFilter;
import oracle.dss.graph.flash.jswiff.swfrecords.FillStyle;
import oracle.dss.graph.flash.jswiff.swfrecords.FillStyleArray;
import oracle.dss.graph.flash.jswiff.swfrecords.Filter;
import oracle.dss.graph.flash.jswiff.swfrecords.FocalGradient;
import oracle.dss.graph.flash.jswiff.swfrecords.FocalMorphGradient;
import oracle.dss.graph.flash.jswiff.swfrecords.GlowFilter;
import oracle.dss.graph.flash.jswiff.swfrecords.GlyphEntry;
import oracle.dss.graph.flash.jswiff.swfrecords.GradRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.Gradient;
import oracle.dss.graph.flash.jswiff.swfrecords.GradientBevelFilter;
import oracle.dss.graph.flash.jswiff.swfrecords.GradientGlowFilter;
import oracle.dss.graph.flash.jswiff.swfrecords.KerningRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.LineStyle;
import oracle.dss.graph.flash.jswiff.swfrecords.LineStyle2;
import oracle.dss.graph.flash.jswiff.swfrecords.LineStyleArray;
import oracle.dss.graph.flash.jswiff.swfrecords.MorphFillStyle;
import oracle.dss.graph.flash.jswiff.swfrecords.MorphFillStyles;
import oracle.dss.graph.flash.jswiff.swfrecords.MorphGradRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.MorphGradient;
import oracle.dss.graph.flash.jswiff.swfrecords.MorphLineStyle;
import oracle.dss.graph.flash.jswiff.swfrecords.MorphLineStyle2;
import oracle.dss.graph.flash.jswiff.swfrecords.MorphLineStyles;
import oracle.dss.graph.flash.jswiff.swfrecords.RGB;
import oracle.dss.graph.flash.jswiff.swfrecords.RGBA;
import oracle.dss.graph.flash.jswiff.swfrecords.Rect;
import oracle.dss.graph.flash.jswiff.swfrecords.RegisterParam;
import oracle.dss.graph.flash.jswiff.swfrecords.SWFHeader;
import oracle.dss.graph.flash.jswiff.swfrecords.Shape;
import oracle.dss.graph.flash.jswiff.swfrecords.ShapeRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.ShapeWithStyle;
import oracle.dss.graph.flash.jswiff.swfrecords.SoundEnvelope;
import oracle.dss.graph.flash.jswiff.swfrecords.SoundInfo;
import oracle.dss.graph.flash.jswiff.swfrecords.StraightEdgeRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.StyleChangeRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.TextRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Action;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.ActionBlock;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.ConstantPool;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.DefineFunction;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.DefineFunction2;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.If;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Jump;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Push;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Try;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.With;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineBits;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineBitsJPEG2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineBitsJPEG3;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineBitsLossless;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineBitsLossless2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineButton;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineButton2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineButtonCXform;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineButtonSound;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineEditText;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineFont;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineFont2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineFont3;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineFontAlignment;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineFontInfo;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineFontInfo2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineMorphShape;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineMorphShape2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineShape;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineShape2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineShape3;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineShape4;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineSound;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineSprite;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineText;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineText2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineVideoStream;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DoAction;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DoInitAction;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.EnableDebugger;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.EnableDebugger2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.ExportAssets;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.FileAttributes;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.FlashTypeSettings;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.FrameLabel;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.ImportAssets;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.ImportAssets2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.JPEGTables;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.MalformedTag;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.Metadata;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.PlaceObject;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.PlaceObject2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.PlaceObject3;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.Protect;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.RemoveObject;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.RemoveObject2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.Scale9Grid;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.ScriptLimits;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.SetBackgroundColor;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.SetTabIndex;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.ShowFrame;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.SoundStreamBlock;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.SoundStreamHead;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.SoundStreamHead2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.StartSound;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.Tag;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.TagConstants;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.UnknownTag;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.VideoFrame;
import oracle.dss.graph.flash.jswiff.util.HexUtils;

final class SWFTreeBuilder {
    private static int nodes;
    private static List constants;

    static void setNodes(int nodes) {
        SWFTreeBuilder.nodes = nodes;
    }

    static int getNodes() {
        return nodes;
    }

    static void addNode(DefaultMutableTreeNode node, Tag tag) {
        switch (tag.getCode()) {
            case 6: {
                SWFTreeBuilder.addNode(node, (DefineBits)tag);
                break;
            }
            case 21: {
                SWFTreeBuilder.addNode(node, (DefineBitsJPEG2)tag);
                break;
            }
            case 35: {
                SWFTreeBuilder.addNode(node, (DefineBitsJPEG3)tag);
                break;
            }
            case 20: {
                SWFTreeBuilder.addNode(node, (DefineBitsLossless)tag);
                break;
            }
            case 36: {
                SWFTreeBuilder.addNode(node, (DefineBitsLossless2)tag);
                break;
            }
            case 7: {
                SWFTreeBuilder.addNode(node, (DefineButton)tag);
                break;
            }
            case 34: {
                SWFTreeBuilder.addNode(node, (DefineButton2)tag);
                break;
            }
            case 23: {
                SWFTreeBuilder.addNode(node, (DefineButtonCXform)tag);
                break;
            }
            case 17: {
                SWFTreeBuilder.addNode(node, (DefineButtonSound)tag);
                break;
            }
            case 37: {
                SWFTreeBuilder.addNode(node, (DefineEditText)tag);
                break;
            }
            case 10: {
                SWFTreeBuilder.addNode(node, (DefineFont)tag);
                break;
            }
            case 48: {
                SWFTreeBuilder.addNode(node, (DefineFont2)tag);
                break;
            }
            case 75: {
                SWFTreeBuilder.addNode(node, (DefineFont3)tag);
                break;
            }
            case 13: {
                SWFTreeBuilder.addNode(node, (DefineFontInfo)tag);
                break;
            }
            case 62: {
                SWFTreeBuilder.addNode(node, (DefineFontInfo2)tag);
                break;
            }
            case 74: {
                SWFTreeBuilder.addNode(node, (FlashTypeSettings)tag);
                break;
            }
            case 73: {
                SWFTreeBuilder.addNode(node, (DefineFontAlignment)tag);
                break;
            }
            case 46: {
                SWFTreeBuilder.addNode(node, (DefineMorphShape)tag);
                break;
            }
            case 84: {
                SWFTreeBuilder.addNode(node, (DefineMorphShape2)tag);
                break;
            }
            case 2: {
                SWFTreeBuilder.addNode(node, (DefineShape)tag);
                break;
            }
            case 22: {
                SWFTreeBuilder.addNode(node, (DefineShape2)tag);
                break;
            }
            case 32: {
                SWFTreeBuilder.addNode(node, (DefineShape3)tag);
                break;
            }
            case 83: {
                SWFTreeBuilder.addNode(node, (DefineShape4)tag);
                break;
            }
            case 14: {
                SWFTreeBuilder.addNode(node, (DefineSound)tag);
                break;
            }
            case 39: {
                SWFTreeBuilder.addNode(node, (DefineSprite)tag);
                break;
            }
            case 11: {
                SWFTreeBuilder.addNode(node, (DefineText)tag);
                break;
            }
            case 33: {
                SWFTreeBuilder.addNode(node, (DefineText2)tag);
                break;
            }
            case 60: {
                SWFTreeBuilder.addNode(node, (DefineVideoStream)tag);
                break;
            }
            case 12: {
                SWFTreeBuilder.addNode(node, (DoAction)tag);
                break;
            }
            case 59: {
                SWFTreeBuilder.addNode(node, (DoInitAction)tag);
                break;
            }
            case 64: {
                SWFTreeBuilder.addNode(node, (EnableDebugger2)tag);
                break;
            }
            case 58: {
                SWFTreeBuilder.addNode(node, (EnableDebugger)tag);
                break;
            }
            case 56: {
                SWFTreeBuilder.addNode(node, (ExportAssets)tag);
                break;
            }
            case 69: {
                SWFTreeBuilder.addNode(node, (FileAttributes)tag);
                break;
            }
            case 43: {
                SWFTreeBuilder.addNode(node, (FrameLabel)tag);
                break;
            }
            case 57: 
            case 71: {
                SWFTreeBuilder.addNode(node, (ImportAssets)tag);
                break;
            }
            case 8: {
                SWFTreeBuilder.addNode(node, (JPEGTables)tag);
                break;
            }
            case 77: {
                SWFTreeBuilder.addNode(node, (Metadata)tag);
                break;
            }
            case 4: {
                SWFTreeBuilder.addNode(node, (PlaceObject)tag);
                break;
            }
            case 26: {
                SWFTreeBuilder.addNode(node, (PlaceObject2)tag);
                break;
            }
            case 70: {
                SWFTreeBuilder.addNode(node, (PlaceObject3)tag);
                break;
            }
            case 24: {
                SWFTreeBuilder.addNode(node, (Protect)tag);
                break;
            }
            case 5: {
                SWFTreeBuilder.addNode(node, (RemoveObject)tag);
                break;
            }
            case 28: {
                SWFTreeBuilder.addNode(node, (RemoveObject2)tag);
                break;
            }
            case 65: {
                SWFTreeBuilder.addNode(node, (ScriptLimits)tag);
                break;
            }
            case 9: {
                SWFTreeBuilder.addNode(node, (SetBackgroundColor)tag);
                break;
            }
            case 66: {
                SWFTreeBuilder.addNode(node, (SetTabIndex)tag);
                break;
            }
            case 1: {
                SWFTreeBuilder.addNode(node, (ShowFrame)tag);
                break;
            }
            case 78: {
                SWFTreeBuilder.addNode(node, (Scale9Grid)tag);
                break;
            }
            case 19: {
                SWFTreeBuilder.addNode(node, (SoundStreamBlock)tag);
                break;
            }
            case 18: {
                SWFTreeBuilder.addNode(node, (SoundStreamHead)tag);
                break;
            }
            case 45: {
                SWFTreeBuilder.addNode(node, (SoundStreamHead2)tag);
                break;
            }
            case 15: {
                SWFTreeBuilder.addNode(node, (StartSound)tag);
                break;
            }
            case 61: {
                SWFTreeBuilder.addNode(node, (VideoFrame)tag);
                break;
            }
            case -1: {
                SWFTreeBuilder.addNode(node, (MalformedTag)tag);
                break;
            }
            default: {
                SWFTreeBuilder.addNode(node, (UnknownTag)tag);
            }
        }
    }

    static void addNode(DefaultMutableTreeNode node, SWFHeader header) {
        DefaultMutableTreeNode headerNode = SWFTreeBuilder.addParentNode(node, "<html><id:1xf><font color=\"#00A000\">SWF Header</html>");
        SWFTreeBuilder.addLeaf(headerNode, "compressed: " + header.isCompressed());
        SWFTreeBuilder.addLeaf(headerNode, "version: " + header.getVersion());
        SWFTreeBuilder.addLeaf(headerNode, "fileLength: " + header.getFileLength());
        SWFTreeBuilder.addLeaf(headerNode, "frameSize: " + header.getFrameSize());
        SWFTreeBuilder.addLeaf(headerNode, "frameRate: " + header.getFrameRate());
        SWFTreeBuilder.addLeaf(headerNode, "frameCount: " + header.getFrameCount());
    }

    private static String getCapStyleString(byte capStyle) {
        switch (capStyle) {
            case 1: {
                return "none";
            }
            case 0: {
                return "round";
            }
            case 2: {
                return "square";
            }
        }
        return "illegal value: " + capStyle;
    }

    private static String getGridFitString(byte gridFit) {
        switch (gridFit) {
            case 0: {
                return "none";
            }
            case 1: {
                return "pixel";
            }
            case 2: {
                return "subpixel";
            }
        }
        return "unknown value: " + gridFit;
    }

    private static String getInterpolationMethodString(byte interpolationMethod) {
        switch (interpolationMethod) {
            case 0: {
                return "RGB";
            }
            case 1: {
                return "linear RGB";
            }
        }
        return "unkown value: " + interpolationMethod;
    }

    private static String getJointStyleString(byte jointStyle) {
        switch (jointStyle) {
            case 1: {
                return "bevel";
            }
            case 2: {
                return "miter";
            }
            case 0: {
                return "round";
            }
        }
        return "illegal value: " + jointStyle;
    }

    private static String getPushDescription(Push push) {
        String result = "Push";
        for (Push.StackValue value : push.getValues()) {
            switch (value.getType()) {
                case 0: {
                    result = result + " string: '" + value.getString() + "'";
                    break;
                }
                case 1: {
                    result = result + " float: " + value.getFloat();
                    break;
                }
                case 4: {
                    result = result + " register: " + value.getRegisterNumber();
                    break;
                }
                case 5: {
                    result = result + " boolean: " + value.getBoolean();
                    break;
                }
                case 6: {
                    result = result + " double: " + value.getDouble();
                    break;
                }
                case 7: {
                    result = result + " integer: " + value.getInteger();
                    break;
                }
                case 8: {
                    short index8 = value.getConstant8();
                    result = result + " c8[" + index8 + "]: '" + constants.get(index8) + "'";
                    break;
                }
                case 9: {
                    int index16 = value.getConstant16();
                    result = result + " c8[" + index16 + "]: '" + constants.get(index16) + "'";
                    break;
                }
                case 3: {
                    result = result + " <b>undefined</b>";
                    break;
                }
                case 2: {
                    result = result + " <b>null</b>";
                    break;
                }
            }
            result = result + ";";
        }
        return result;
    }

    private static String getScaleStrokeString(byte scaleStroke) {
        switch (scaleStroke) {
            case 0: {
                return "none";
            }
            case 2: {
                return "horizontal";
            }
            case 1: {
                return "vertical";
            }
            case 3: {
                return "both";
            }
        }
        return "illegal value: " + scaleStroke;
    }

    private static String getSoundFormatString(byte format) {
        String result = null;
        switch (format) {
            case 1: {
                result = "ADPCM";
                break;
            }
            case 2: {
                result = "mp3";
                break;
            }
            case 6: {
                result = "Nellymoser";
                break;
            }
            case 0: {
                result = "uncompressed";
                break;
            }
            case 3: {
                result = "uncompresed little-endian";
                break;
            }
            default: {
                result = "unknown";
            }
        }
        return result;
    }

    private static String getSoundRateString(byte rate) {
        String result = null;
        switch (rate) {
            case 0: {
                result = "5.5 kHz";
                break;
            }
            case 1: {
                result = "11 kHz";
                break;
            }
            case 2: {
                result = "22 kHz";
                break;
            }
            case 3: {
                result = "44 kHz";
                break;
            }
            default: {
                result = "unknown";
            }
        }
        return result;
    }

    private static String getSpreadMethodString(byte spreadMethod) {
        switch (spreadMethod) {
            case 0: {
                return "pad";
            }
            case 1: {
                return "reflect";
            }
            case 2: {
                return "repeat";
            }
        }
        return "unknown value: " + spreadMethod;
    }

    private static String getThicknessString(byte thickness) {
        switch (thickness) {
            case 0: {
                return "thin";
            }
            case 1: {
                return "medium";
            }
            case 2: {
                return "thick";
            }
        }
        return "unknown value: " + thickness;
    }

    private static void addLeaf(DefaultMutableTreeNode node, String string) {
        node.insert(new DefaultMutableTreeNode(string), node.getChildCount());
        ++nodes;
    }

    private static void addNode(DefaultMutableTreeNode node, MalformedTag tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, "<html><body bgcolor=\"#FF0000\"><font color=\"#FFFFFF\">Malformed tag</font></body></html>");
        short code = tag.getTagHeader().getCode();
        SWFTreeBuilder.addLeaf(tagNode, "code: " + code + " (" + TagConstants.getTagName(code) + ")");
        SWFTreeBuilder.addLeaf(tagNode, "data size: " + tag.getTagHeader().getLength() + " bytes");
        SWFTreeBuilder.addLeaf(tagNode, "error: " + tag.getException().getMessage());
    }

    private static void addNode(DefaultMutableTreeNode node, DefineBits tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatDefTag("DefineBits"));
        SWFTreeBuilder.addLeaf(tagNode, "characterId: " + tag.getCharacterId());
        SWFTreeBuilder.addLeaf(tagNode, "jpegData:  byte[" + tag.getJpegData().length + "]");
    }

    private static void addNode(DefaultMutableTreeNode node, DefineBitsJPEG2 tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatDefTag("DefineBitsJPEG2"));
        SWFTreeBuilder.addLeaf(tagNode, "characterId: " + tag.getCharacterId());
        SWFTreeBuilder.addLeaf(tagNode, "jpegData:  byte[" + tag.getJpegData().length + "]");
    }

    private static void addNode(DefaultMutableTreeNode node, DefineBitsJPEG3 tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatDefTag("DefineBitsJPEG3"));
        SWFTreeBuilder.addLeaf(tagNode, "characterId: " + tag.getCharacterId());
        SWFTreeBuilder.addLeaf(tagNode, "jpegData:  byte[" + tag.getJpegData().length + "]");
        SWFTreeBuilder.addLeaf(tagNode, "bitmapAlphaData:  byte[" + tag.getBitmapAlphaData().length + "]");
    }

    private static void addNode(DefaultMutableTreeNode node, DefineBitsLossless tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatDefTag("DefineBitsLossless"));
        SWFTreeBuilder.addLeaf(tagNode, "characterId: " + tag.getCharacterId());
        short format = tag.getFormat();
        String formatString = "";
        switch (format) {
            case 3: {
                formatString = "8-bit colormapped image";
                break;
            }
            case 4: {
                formatString = "15-bit RGB image";
                break;
            }
            case 5: {
                formatString = "24-bit RGB image";
                break;
            }
        }
        SWFTreeBuilder.addLeaf(tagNode, "format: " + formatString);
        SWFTreeBuilder.addLeaf(tagNode, "width: " + tag.getWidth());
        SWFTreeBuilder.addLeaf(tagNode, "height: " + tag.getHeight());
        if (format == 3) {
            SWFTreeBuilder.addNode(tagNode, "zlibBitmapData: ", (ColorMapData)tag.getZlibBitmapData());
        } else {
            SWFTreeBuilder.addNode(tagNode, "zlibBitmapData: ", (BitmapData)tag.getZlibBitmapData(), format);
        }
    }

    private static void addNode(DefaultMutableTreeNode node, String var, BitmapData data, short format) {
        DefaultMutableTreeNode newNode = SWFTreeBuilder.addParentNode(node, var + "BitmapData");
        if (format == 4) {
            SWFTreeBuilder.addLeaf(newNode, "bitmapPixelData: Pix15[" + data.getBitmapPixelData().length + "]");
        } else {
            SWFTreeBuilder.addLeaf(newNode, "bitmapPixelData: Pix24[" + data.getBitmapPixelData().length + "]");
        }
    }

    private static void addNode(DefaultMutableTreeNode node, String var, ColorMapData data) {
        DefaultMutableTreeNode newNode = SWFTreeBuilder.addParentNode(node, var + "ColorMapData");
        RGB[] colorTable = data.getColorTableRGB();
        DefaultMutableTreeNode colorTableNode = SWFTreeBuilder.addParentNode(newNode, "colorTableRGB: RGB[" + colorTable.length + "]");
        int i = 0;
        while (i < colorTable.length) {
            SWFTreeBuilder.addLeaf(colorTableNode, colorTable[i].toString());
            ++i;
        }
        SWFTreeBuilder.addLeaf(newNode, "colorMapPixelData: short[" + data.getColorMapPixelData().length + "]");
    }

    private static void addNode(DefaultMutableTreeNode node, String var, AlphaColorMapData data) {
        DefaultMutableTreeNode newNode = SWFTreeBuilder.addParentNode(node, var + "AlphaColorMapData");
        RGBA[] colorTable = data.getColorTableRGBA();
        DefaultMutableTreeNode colorTableNode = SWFTreeBuilder.addParentNode(newNode, "colorTableRGBA: RGBA[" + colorTable.length + "]");
        int i = 0;
        while (i < colorTable.length) {
            SWFTreeBuilder.addLeaf(colorTableNode, i + ": " + colorTable[i].toString());
            ++i;
        }
        SWFTreeBuilder.addLeaf(newNode, "colorMapPixelData: short[" + data.getColorMapPixelData().length + "]");
    }

    private static void addNode(DefaultMutableTreeNode node, DefineBitsLossless2 tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatDefTag("DefineBitsLossless2"));
        SWFTreeBuilder.addLeaf(tagNode, "characterId: " + tag.getCharacterId());
        short format = tag.getFormat();
        String formatString = "";
        switch (format) {
            case 3: {
                formatString = "8-bit colormapped image";
                break;
            }
            case 5: {
                formatString = "32-bit RGBA image";
                break;
            }
        }
        SWFTreeBuilder.addLeaf(tagNode, "format: " + formatString);
        SWFTreeBuilder.addLeaf(tagNode, "width: " + tag.getWidth());
        SWFTreeBuilder.addLeaf(tagNode, "height: " + tag.getHeight());
        if (format == 3) {
            SWFTreeBuilder.addNode(tagNode, "zlibBitmapData: ", (AlphaColorMapData)tag.getZlibBitmapData());
        } else {
            DefaultMutableTreeNode zlibNode = SWFTreeBuilder.addParentNode(tagNode, "zlibBitmapData: AlphaBitMapData");
            SWFTreeBuilder.addLeaf(zlibNode, "bitmapPixelData: RGBA[" + ((AlphaBitmapData)tag.getZlibBitmapData()).getBitmapPixelData().length + "]");
        }
    }

    private static void addNode(DefaultMutableTreeNode node, DefineButton tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatDefTag("DefineButton"));
        SWFTreeBuilder.addLeaf(tagNode, "characterId: " + tag.getCharacterId());
        SWFTreeBuilder.addNode(tagNode, "characters: ", tag.getCharacters());
        SWFTreeBuilder.addNode(tagNode, "actions: ", tag.getActions());
    }

    private static void addNode(DefaultMutableTreeNode node, DefineButton2 tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatDefTag("DefineButton2"));
        SWFTreeBuilder.addLeaf(tagNode, "characterId: " + tag.getCharacterId());
        SWFTreeBuilder.addLeaf(tagNode, "trackAsMenu: " + tag.isTrackAsMenu());
        SWFTreeBuilder.addNode(tagNode, "characters: ", tag.getCharacters());
        if (tag.getActions() != null) {
            SWFTreeBuilder.addNode(tagNode, "actions: ", tag.getActions());
        }
    }

    private static void addNode(DefaultMutableTreeNode node, String var, ButtonCondAction[] actions) {
        DefaultMutableTreeNode newNode = SWFTreeBuilder.addParentNode(node, var + "ButtonCondAction[" + actions.length + "]");
        int i = 0;
        while (i < actions.length) {
            DefaultMutableTreeNode actionNode = SWFTreeBuilder.addParentNode(newNode, "ButtonCondAction");
            SWFTreeBuilder.addLeaf(actionNode, "idleToOverDown: " + actions[i].isIdleToOverDown());
            SWFTreeBuilder.addLeaf(actionNode, "outDownToIdle: " + actions[i].isOutDownToIdle());
            SWFTreeBuilder.addLeaf(actionNode, "outDownToOverDown: " + actions[i].isOutDownToOverDown());
            SWFTreeBuilder.addLeaf(actionNode, "overDownToOutDown: " + actions[i].isOverDownToOutDown());
            SWFTreeBuilder.addLeaf(actionNode, "overDownToOverUp: " + actions[i].isOverDownToOverUp());
            SWFTreeBuilder.addLeaf(actionNode, "overUpToOverDown: " + actions[i].isOverUpToOverDown());
            SWFTreeBuilder.addLeaf(actionNode, "overUpToIdle: " + actions[i].isOverUpToIdle());
            SWFTreeBuilder.addLeaf(actionNode, "idleToOverUp: " + actions[i].isIdleToOverUp());
            SWFTreeBuilder.addLeaf(actionNode, "keyPress: " + actions[i].getKeyPress());
            SWFTreeBuilder.addLeaf(actionNode, "overDownToIdle: " + actions[i].isOverDownToIdle());
            SWFTreeBuilder.addNode(actionNode, "actions: ", actions[i].getActions());
            ++i;
        }
    }

    private static void addNode(DefaultMutableTreeNode node, String var, ButtonRecord[] characters) {
        DefaultMutableTreeNode newNode = SWFTreeBuilder.addParentNode(node, var + "ButtonRecord[" + characters.length + "]");
        int i = 0;
        while (i < characters.length) {
            DefaultMutableTreeNode recordNode = SWFTreeBuilder.addParentNode(newNode, "ButtonRecord");
            SWFTreeBuilder.addLeaf(recordNode, "hitState: " + characters[i].isHitState());
            SWFTreeBuilder.addLeaf(recordNode, "downState: " + characters[i].isDownState());
            SWFTreeBuilder.addLeaf(recordNode, "overState: " + characters[i].isOverState());
            SWFTreeBuilder.addLeaf(recordNode, "upState: " + characters[i].isUpState());
            SWFTreeBuilder.addLeaf(recordNode, "characterId: " + characters[i].getCharacterId());
            SWFTreeBuilder.addLeaf(recordNode, "placeDepth: " + characters[i].getPlaceDepth());
            SWFTreeBuilder.addLeaf(recordNode, "placeMatrix: " + characters[i].getPlaceMatrix());
            CXformWithAlpha colorTransform = characters[i].getColorTransform();
            if (colorTransform != null) {
                SWFTreeBuilder.addNode(recordNode, "colorTransform: ", characters[i].getColorTransform());
            }
            ++i;
        }
    }

    private static void addNode(DefaultMutableTreeNode node, DefineButtonCXform tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatDefTag("DefineButtonCXform"));
        SWFTreeBuilder.addLeaf(tagNode, "characterId: " + tag.getCharacterId());
        SWFTreeBuilder.addNode(tagNode, "buttonColorTransform: ", tag.getColorTransform());
    }

    private static void addNode(DefaultMutableTreeNode node, DefineButtonSound tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatDefTag("DefineButtonSound"));
        SWFTreeBuilder.addLeaf(tagNode, "buttonId: " + tag.getButtonId());
        if (tag.getOverUpToIdleSoundId() != 0) {
            SWFTreeBuilder.addLeaf(tagNode, "overUpToIdleSoundId: " + tag.getOverUpToIdleSoundId());
            SWFTreeBuilder.addNode(tagNode, "overUpToIdleSoundInfo: ", tag.getOverUpToIdleSoundInfo());
        }
        if (tag.getIdleToOverUpSoundId() != 0) {
            SWFTreeBuilder.addLeaf(tagNode, "idleToOverUpSoundId: " + tag.getIdleToOverUpSoundId());
            SWFTreeBuilder.addNode(tagNode, "idleToOverUpSoundInfo: ", tag.getIdleToOverUpSoundInfo());
        }
        if (tag.getOverUpToOverDownSoundId() != 0) {
            SWFTreeBuilder.addLeaf(tagNode, "overUpToOverDownSoundId: " + tag.getOverUpToOverDownSoundId());
            SWFTreeBuilder.addNode(tagNode, "overUpToOverDownSoundInfo: ", tag.getOverUpToOverDownSoundInfo());
        }
        if (tag.getOverDownToOverUpSoundId() != 0) {
            SWFTreeBuilder.addLeaf(tagNode, "overDownToOverUpSoundId: " + tag.getOverDownToOverUpSoundId());
            SWFTreeBuilder.addNode(tagNode, "overDownToOverUpSoundInfo: ", tag.getOverDownToOverUpSoundInfo());
        }
    }

    private static void addNode(DefaultMutableTreeNode node, DefineEditText tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatDefTag("DefineEditText"));
        SWFTreeBuilder.addLeaf(tagNode, "characterId: " + tag.getCharacterId());
        SWFTreeBuilder.addLeaf(tagNode, "bounds: " + tag.getBounds());
        SWFTreeBuilder.addLeaf(tagNode, "wordWrap: " + tag.isWordWrap());
        SWFTreeBuilder.addLeaf(tagNode, "multiline: " + tag.isMultiline());
        SWFTreeBuilder.addLeaf(tagNode, "password: " + tag.isPassword());
        SWFTreeBuilder.addLeaf(tagNode, "readOnly: " + tag.isReadOnly());
        SWFTreeBuilder.addLeaf(tagNode, "autoSize: " + tag.isAutoSize());
        SWFTreeBuilder.addLeaf(tagNode, "noSelect: " + tag.isNoSelect());
        SWFTreeBuilder.addLeaf(tagNode, "border: " + tag.isBorder());
        SWFTreeBuilder.addLeaf(tagNode, "html: " + tag.isHtml());
        SWFTreeBuilder.addLeaf(tagNode, "useOutlines: " + tag.isUseOutlines());
        if (tag.getFontId() > 0) {
            SWFTreeBuilder.addLeaf(tagNode, "fontId: " + tag.getFontId());
            SWFTreeBuilder.addLeaf(tagNode, "fontHeight: " + tag.getFontHeight());
        }
        if (tag.getTextColor() != null) {
            SWFTreeBuilder.addLeaf(tagNode, "textColor: " + tag.getTextColor());
        }
        if (tag.getMaxLength() > 0) {
            SWFTreeBuilder.addLeaf(tagNode, "maxLength: " + tag.getMaxLength());
        }
        if (tag.hasLayout()) {
            SWFTreeBuilder.addLeaf(tagNode, "align: " + tag.getAlign());
            SWFTreeBuilder.addLeaf(tagNode, "leftMargin: " + tag.getLeftMargin());
            SWFTreeBuilder.addLeaf(tagNode, "rightMargin: " + tag.getRightMargin());
            SWFTreeBuilder.addLeaf(tagNode, "indent: " + tag.getIndent());
            SWFTreeBuilder.addLeaf(tagNode, "leading: " + tag.getLeading());
        }
        SWFTreeBuilder.addLeaf(tagNode, "variableName: " + tag.getVariableName());
        if (tag.getInitialText() != null) {
            SWFTreeBuilder.addLeaf(tagNode, "initialText: " + tag.getInitialText());
        }
    }

    private static void addNode(DefaultMutableTreeNode node, DefineFont tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatDefTag("DefineFont"));
        SWFTreeBuilder.addLeaf(tagNode, "characterId: " + tag.getCharacterId());
        Shape[] shapes = tag.getGlyphShapeTable();
        DefaultMutableTreeNode shapeNode = SWFTreeBuilder.addParentNode(tagNode, "glyphShapeTable: Shape[" + shapes.length + "]");
        int i = 0;
        while (i < shapes.length) {
            SWFTreeBuilder.addNode(shapeNode, "", shapes[i]);
            ++i;
        }
    }

    private static void addNode(DefaultMutableTreeNode node, DefineFont2 tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatDefTag("DefineFont2"));
        SWFTreeBuilder.addLeaf(tagNode, "characterId: " + tag.getCharacterId());
        SWFTreeBuilder.addLeaf(tagNode, "shiftJIS: " + tag.isShiftJIS());
        SWFTreeBuilder.addLeaf(tagNode, "smallText: " + tag.isSmallText());
        SWFTreeBuilder.addLeaf(tagNode, "ansi: " + tag.isANSI());
        SWFTreeBuilder.addLeaf(tagNode, "italic: " + tag.isItalic());
        SWFTreeBuilder.addLeaf(tagNode, "bold: " + tag.isBold());
        SWFTreeBuilder.addLeaf(tagNode, "LanguageCode: " + tag.getLanguageCode());
        SWFTreeBuilder.addLeaf(tagNode, "fontName: " + tag.getFontName());
        SWFTreeBuilder.addLeaf(tagNode, "hasLayout: " + tag.hasLayout());
        Shape[] shapes = tag.getGlyphShapeTable();
        if (shapes == null) {
            SWFTreeBuilder.addLeaf(tagNode, "numGlyphs: 0");
        } else {
            SWFTreeBuilder.addLeaf(tagNode, "numGlyphs: " + shapes.length);
        }
        if (shapes != null) {
            DefaultMutableTreeNode shapeNode = SWFTreeBuilder.addParentNode(tagNode, "glyphShapeTable: Shape[" + shapes.length + "]");
            int i = 0;
            while (i < shapes.length) {
                SWFTreeBuilder.addNode(shapeNode, "", shapes[i]);
                ++i;
            }
            char[] table = tag.getCodeTable();
            DefaultMutableTreeNode codeTableNode = SWFTreeBuilder.addParentNode(tagNode, "codeTable: char[" + table.length + "]");
            int i2 = 0;
            while (i2 < table.length) {
                SWFTreeBuilder.addLeaf(codeTableNode, "code " + i2 + ": " + table[i2]);
                ++i2;
            }
        }
        if (tag.hasLayout()) {
            KerningRecord[] kerningTable;
            SWFTreeBuilder.addLeaf(tagNode, "ascent: " + tag.getAscent());
            SWFTreeBuilder.addLeaf(tagNode, "descent: " + tag.getDescent());
            SWFTreeBuilder.addLeaf(tagNode, "leading: " + tag.getLeading());
            SWFTreeBuilder.addLeaf(tagNode, "fontAscent: " + tag.getAscent());
            if (shapes != null) {
                short[] advanceTable = tag.getAdvanceTable();
                DefaultMutableTreeNode advanceTableNode = SWFTreeBuilder.addParentNode(tagNode, "advanceTable: short[" + advanceTable.length + "]");
                int i = 0;
                while (i < advanceTable.length) {
                    SWFTreeBuilder.addLeaf(advanceTableNode, i + ": " + advanceTable[i]);
                    ++i;
                }
                Rect[] boundsTable = tag.getBoundsTable();
                DefaultMutableTreeNode boundsTableNode = SWFTreeBuilder.addParentNode(tagNode, "boundsTable: Rect[" + boundsTable.length + "]");
                int i3 = 0;
                while (i3 < boundsTable.length) {
                    SWFTreeBuilder.addLeaf(boundsTableNode, i3 + ": " + boundsTable[i3]);
                    ++i3;
                }
            }
            if ((kerningTable = tag.getKerningTable()) != null && kerningTable.length > 0) {
                DefaultMutableTreeNode kerningTableNode = SWFTreeBuilder.addParentNode(tagNode, "kerningTable: KerningRecord[" + kerningTable.length + "]");
                int i = 0;
                while (i < kerningTable.length) {
                    KerningRecord kerningRecord = kerningTable[i];
                    DefaultMutableTreeNode kerningRecordNode = SWFTreeBuilder.addParentNode(kerningTableNode, "KerningRecord");
                    SWFTreeBuilder.addLeaf(kerningRecordNode, "left: " + kerningRecord.getLeft());
                    SWFTreeBuilder.addLeaf(kerningRecordNode, "right: " + kerningRecord.getRight());
                    SWFTreeBuilder.addLeaf(kerningRecordNode, "adjustment: " + kerningRecord.getAdjustment());
                    ++i;
                }
            }
        }
    }

    private static void addNode(DefaultMutableTreeNode node, DefineFont3 tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatDefTag("DefineFont3"));
        SWFTreeBuilder.addLeaf(tagNode, "characterId: " + tag.getCharacterId());
        SWFTreeBuilder.addLeaf(tagNode, "smallText: " + tag.isSmallText());
        SWFTreeBuilder.addLeaf(tagNode, "italic: " + tag.isItalic());
        SWFTreeBuilder.addLeaf(tagNode, "bold: " + tag.isBold());
        SWFTreeBuilder.addLeaf(tagNode, "LanguageCode: " + tag.getLanguageCode());
        SWFTreeBuilder.addLeaf(tagNode, "fontName: " + tag.getFontName());
        SWFTreeBuilder.addLeaf(tagNode, "hasLayout: " + tag.hasLayout());
        Shape[] shapes = tag.getGlyphShapeTable();
        if (shapes == null) {
            SWFTreeBuilder.addLeaf(tagNode, "numGlyphs: 0");
        } else {
            SWFTreeBuilder.addLeaf(tagNode, "numGlyphs: " + shapes.length);
        }
        if (shapes != null) {
            DefaultMutableTreeNode shapeNode = SWFTreeBuilder.addParentNode(tagNode, "glyphShapeTable: Shape[" + shapes.length + "]");
            int i = 0;
            while (i < shapes.length) {
                SWFTreeBuilder.addNode(shapeNode, "", shapes[i]);
                ++i;
            }
            char[] table = tag.getCodeTable();
            DefaultMutableTreeNode codeTableNode = SWFTreeBuilder.addParentNode(tagNode, "codeTable: char[" + table.length + "]");
            int i2 = 0;
            while (i2 < table.length) {
                SWFTreeBuilder.addLeaf(codeTableNode, "code " + i2 + ": " + table[i2]);
                ++i2;
            }
        }
        if (tag.hasLayout()) {
            KerningRecord[] kerningTable;
            SWFTreeBuilder.addLeaf(tagNode, "ascent: " + tag.getAscent());
            SWFTreeBuilder.addLeaf(tagNode, "descent: " + tag.getDescent());
            SWFTreeBuilder.addLeaf(tagNode, "leading: " + tag.getLeading());
            SWFTreeBuilder.addLeaf(tagNode, "fontAscent: " + tag.getAscent());
            if (shapes != null) {
                short[] advanceTable = tag.getAdvanceTable();
                DefaultMutableTreeNode advanceTableNode = SWFTreeBuilder.addParentNode(tagNode, "advanceTable: short[" + advanceTable.length + "]");
                int i = 0;
                while (i < advanceTable.length) {
                    SWFTreeBuilder.addLeaf(advanceTableNode, i + ": " + advanceTable[i]);
                    ++i;
                }
                Rect[] boundsTable = tag.getBoundsTable();
                DefaultMutableTreeNode boundsTableNode = SWFTreeBuilder.addParentNode(tagNode, "boundsTable: Rect[" + boundsTable.length + "]");
                int i3 = 0;
                while (i3 < boundsTable.length) {
                    SWFTreeBuilder.addLeaf(boundsTableNode, i3 + ": " + boundsTable[i3]);
                    ++i3;
                }
            }
            if ((kerningTable = tag.getKerningTable()) != null && kerningTable.length > 0) {
                DefaultMutableTreeNode kerningTableNode = SWFTreeBuilder.addParentNode(tagNode, "kerningTable: KerningRecord[" + kerningTable.length + "]");
                int i = 0;
                while (i < kerningTable.length) {
                    KerningRecord kerningRecord = kerningTable[i];
                    DefaultMutableTreeNode kerningRecordNode = SWFTreeBuilder.addParentNode(kerningTableNode, "KerningRecord");
                    SWFTreeBuilder.addLeaf(kerningRecordNode, "left: " + kerningRecord.getLeft());
                    SWFTreeBuilder.addLeaf(kerningRecordNode, "right: " + kerningRecord.getRight());
                    SWFTreeBuilder.addLeaf(kerningRecordNode, "adjustment: " + kerningRecord.getAdjustment());
                    ++i;
                }
            }
        }
    }

    private static void addNode(DefaultMutableTreeNode node, DefineFontInfo tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatDefTag("DefineFontInfo"));
        SWFTreeBuilder.addLeaf(tagNode, "fontId: " + tag.getFontId());
        SWFTreeBuilder.addLeaf(tagNode, "fontName: " + tag.getFontName());
        SWFTreeBuilder.addLeaf(tagNode, "smallText: " + tag.isSmallText());
        SWFTreeBuilder.addLeaf(tagNode, "shiftJIS: " + tag.isShiftJIS());
        SWFTreeBuilder.addLeaf(tagNode, "ansi: " + tag.isANSI());
        SWFTreeBuilder.addLeaf(tagNode, "italic: " + tag.isItalic());
        SWFTreeBuilder.addLeaf(tagNode, "bold: " + tag.isBold());
        char[] table = tag.getCodeTable();
        DefaultMutableTreeNode codeTableNode = SWFTreeBuilder.addParentNode(tagNode, "codeTable: char[" + table.length + "]");
        int i = 0;
        while (i < table.length) {
            SWFTreeBuilder.addLeaf(codeTableNode, "code " + i + ": " + table[i]);
            ++i;
        }
    }

    private static void addNode(DefaultMutableTreeNode node, DefineFontInfo2 tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatDefTag("DefineFontInfo2"));
        SWFTreeBuilder.addLeaf(tagNode, "fontId: " + tag.getFontId());
        SWFTreeBuilder.addLeaf(tagNode, "fontName: " + tag.getFontName());
        SWFTreeBuilder.addLeaf(tagNode, "smallText: " + tag.isSmallText());
        SWFTreeBuilder.addLeaf(tagNode, "italic: " + tag.isItalic());
        SWFTreeBuilder.addLeaf(tagNode, "bold: " + tag.isBold());
        SWFTreeBuilder.addLeaf(tagNode, "langCode: " + tag.getLangCode());
        char[] table = tag.getCodeTable();
        DefaultMutableTreeNode codeTableNode = SWFTreeBuilder.addParentNode(tagNode, "codeTable: char[" + table.length + "]");
        int i = 0;
        while (i < table.length) {
            SWFTreeBuilder.addLeaf(codeTableNode, "code " + i + ": " + table[i]);
            ++i;
        }
    }

    private static void addNode(DefaultMutableTreeNode node, FlashTypeSettings tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatDefTag("FlashTypeSettings"));
        SWFTreeBuilder.addLeaf(tagNode, "textId: " + tag.getTextId());
        SWFTreeBuilder.addLeaf(tagNode, "flashType: " + tag.isFlashType());
        SWFTreeBuilder.addLeaf(tagNode, "gridFit: " + SWFTreeBuilder.getGridFitString(tag.getGridFit()));
        SWFTreeBuilder.addLeaf(tagNode, "thickness: " + tag.getThickness());
        SWFTreeBuilder.addLeaf(tagNode, "sharpness: " + tag.getSharpness());
    }

    private static void addNode(DefaultMutableTreeNode node, DefineFontAlignment tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatDefTag("DefineFontAlignment"));
        SWFTreeBuilder.addLeaf(tagNode, "fontId: " + tag.getFontId());
        SWFTreeBuilder.addLeaf(tagNode, "thickness: " + SWFTreeBuilder.getThicknessString(tag.getThickness()));
        AlignmentZone[] alignmentZones = tag.getAlignmentZones();
        SWFTreeBuilder.addNode(tagNode, alignmentZones);
    }

    private static void addNode(DefaultMutableTreeNode node, AlignmentZone[] alignmentZones) {
        DefaultMutableTreeNode newNode = SWFTreeBuilder.addParentNode(node, "alignmentZones: AlignmentZone[" + alignmentZones.length + "]");
        int i = 0;
        while (i < alignmentZones.length) {
            AlignmentZone zone = alignmentZones[i];
            DefaultMutableTreeNode zoneNode = SWFTreeBuilder.addParentNode(newNode, "AlignmentZone " + i);
            if (zone.hasX()) {
                SWFTreeBuilder.addLeaf(zoneNode, "x: left=" + zone.getLeft() + " width=" + zone.getWidth());
            }
            if (zone.hasY()) {
                SWFTreeBuilder.addLeaf(zoneNode, "y: baseline=" + zone.getBaseline() + " height=" + zone.getHeight());
            }
            ++i;
        }
    }

    private static void addNode(DefaultMutableTreeNode node, DefineMorphShape tag) {
        Shape endEdges;
        Shape startEdges;
        MorphLineStyles morphLineStyles;
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatDefTag("DefineMorphShape"));
        SWFTreeBuilder.addLeaf(tagNode, "characterId: " + tag.getCharacterId());
        SWFTreeBuilder.addLeaf(tagNode, "startBounds: " + tag.getStartBounds());
        SWFTreeBuilder.addLeaf(tagNode, "endBounds: " + tag.getEndBounds());
        MorphFillStyles morphFillStyles = tag.getMorphFillStyles();
        if (morphFillStyles != null) {
            SWFTreeBuilder.addNode(tagNode, "morphFillStyles: ", morphFillStyles);
        }
        if ((morphLineStyles = tag.getMorphLineStyles()) != null) {
            SWFTreeBuilder.addNode(tagNode, "morphLineStyles: ", morphLineStyles);
        }
        if ((startEdges = tag.getStartShape()) != null) {
            SWFTreeBuilder.addNode(tagNode, "startEdges: ", startEdges);
        }
        if ((endEdges = tag.getEndShape()) != null) {
            SWFTreeBuilder.addNode(tagNode, "endEdges: ", endEdges);
        }
    }

    private static void addNode(DefaultMutableTreeNode node, DefineMorphShape2 tag) {
        Shape endShape;
        Shape startShape;
        MorphLineStyles morphLineStyles;
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatDefTag("DefineMorphShape2"));
        SWFTreeBuilder.addLeaf(tagNode, "characterId: " + tag.getCharacterId());
        SWFTreeBuilder.addLeaf(tagNode, "startBounds: " + tag.getStartShapeBounds());
        SWFTreeBuilder.addLeaf(tagNode, "endBounds: " + tag.getEndShapeBounds());
        SWFTreeBuilder.addLeaf(tagNode, "startEdgeBounds: " + tag.getStartEdgeBounds());
        SWFTreeBuilder.addLeaf(tagNode, "endEdgeBounds: " + tag.getEndEdgeBounds());
        MorphFillStyles morphFillStyles = tag.getMorphFillStyles();
        if (morphFillStyles != null) {
            SWFTreeBuilder.addNode(tagNode, "morphFillStyles: ", morphFillStyles);
        }
        if ((morphLineStyles = tag.getMorphLineStyles()) != null) {
            SWFTreeBuilder.addNode(tagNode, "morphLineStyles: ", morphLineStyles);
        }
        if ((startShape = tag.getStartShape()) != null) {
            SWFTreeBuilder.addNode(tagNode, "startShape: ", startShape);
        }
        if ((endShape = tag.getEndShape()) != null) {
            SWFTreeBuilder.addNode(tagNode, "endShape: ", endShape);
        }
    }

    private static void addNode(DefaultMutableTreeNode node, String var, Shape shape) {
        DefaultMutableTreeNode newNode = SWFTreeBuilder.addParentNode(node, var + "Shape");
        ShapeRecord[] shapeRecords = shape.getShapeRecords();
        if (shapeRecords.length > 0) {
            DefaultMutableTreeNode recordsNode = SWFTreeBuilder.addParentNode(newNode, "shapeRecords: ShapeRecord[" + shapeRecords.length + "]");
            int i = 0;
            while (i < shapeRecords.length) {
                SWFTreeBuilder.addNode(recordsNode, shapeRecords[i]);
                ++i;
            }
        }
    }

    private static void addNode(DefaultMutableTreeNode node, String var, MorphLineStyles morphLineStyles) {
        DefaultMutableTreeNode newNode = SWFTreeBuilder.addParentNode(node, var + "MorphLineStyles (" + morphLineStyles.getSize() + " styles)");
        int i = 1;
        while (i <= morphLineStyles.getSize()) {
            DefaultMutableTreeNode styleNode = SWFTreeBuilder.addParentNode(newNode, "MorphLineStyle " + i);
            Object style = morphLineStyles.getStyle(i);
            if (style instanceof MorphLineStyle) {
                SWFTreeBuilder.addNode(styleNode, (MorphLineStyle)style);
            } else {
                SWFTreeBuilder.addNode(styleNode, (MorphLineStyle2)style);
            }
            ++i;
        }
    }

    private static void addNode(DefaultMutableTreeNode styleNode, MorphLineStyle style) {
        SWFTreeBuilder.addLeaf(styleNode, "startWidth: " + style.getStartWidth());
        SWFTreeBuilder.addLeaf(styleNode, "endWidth: " + style.getEndWidth());
        SWFTreeBuilder.addLeaf(styleNode, "startColor: " + style.getStartColor());
        SWFTreeBuilder.addLeaf(styleNode, "endColor: " + style.getEndColor());
    }

    private static void addNode(DefaultMutableTreeNode styleNode, MorphLineStyle2 style) {
        SWFTreeBuilder.addLeaf(styleNode, "startWidth: " + style.getStartWidth());
        SWFTreeBuilder.addLeaf(styleNode, "endWidth: " + style.getEndWidth());
        SWFTreeBuilder.addLeaf(styleNode, "startCapStyle: " + SWFTreeBuilder.getCapStyleString(style.getStartCapStyle()));
        SWFTreeBuilder.addLeaf(styleNode, "endCapStyle: " + SWFTreeBuilder.getCapStyleString(style.getEndCapStyle()));
        byte jointStyle = style.getJointStyle();
        SWFTreeBuilder.addLeaf(styleNode, "jointStyle: " + SWFTreeBuilder.getJointStyleString(jointStyle));
        if (jointStyle == 2) {
            SWFTreeBuilder.addLeaf(styleNode, "miterLimit: " + style.getMiterLimit());
        }
        SWFTreeBuilder.addLeaf(styleNode, "pixelHinting: " + style.isPixelHinting());
        SWFTreeBuilder.addLeaf(styleNode, "close: " + style.isClose());
        SWFTreeBuilder.addLeaf(styleNode, "scaleStroke: " + SWFTreeBuilder.getScaleStrokeString(style.getScaleStroke()));
        MorphFillStyle fillStyle = style.getFillStyle();
        if (fillStyle == null) {
            SWFTreeBuilder.addLeaf(styleNode, "startColor: " + style.getStartColor());
            SWFTreeBuilder.addLeaf(styleNode, "endColor: " + style.getEndColor());
        } else {
            SWFTreeBuilder.addNode(styleNode, fillStyle, 0);
        }
    }

    private static void addNode(DefaultMutableTreeNode node, String var, MorphFillStyles morphFillStyles) {
        DefaultMutableTreeNode newNode = SWFTreeBuilder.addParentNode(node, var + "MorphFillStyles (" + morphFillStyles.getSize() + " styles)");
        int i = 1;
        while (i <= morphFillStyles.getSize()) {
            SWFTreeBuilder.addNode(newNode, morphFillStyles.getStyle(i), i);
            ++i;
        }
    }

    private static void addNode(DefaultMutableTreeNode node, MorphFillStyle fillStyle, int index) {
        DefaultMutableTreeNode newNode = SWFTreeBuilder.addParentNode(node, "MorphFillStyle " + index);
        short type = fillStyle.getType();
        switch (type) {
            case 0: {
                SWFTreeBuilder.addLeaf(newNode, "type: solid");
                SWFTreeBuilder.addLeaf(newNode, "startColor: " + fillStyle.getStartColor());
                SWFTreeBuilder.addLeaf(newNode, "endColor: " + fillStyle.getEndColor());
                break;
            }
            case 16: {
                SWFTreeBuilder.addLeaf(newNode, "type: linear gradient");
                SWFTreeBuilder.addLeaf(newNode, "startGradientMatrix: " + fillStyle.getStartGradientMatrix());
                SWFTreeBuilder.addLeaf(newNode, "endGradientMatrix: " + fillStyle.getStartGradientMatrix());
                SWFTreeBuilder.addNode(newNode, fillStyle.getGradient());
                break;
            }
            case 18: {
                SWFTreeBuilder.addLeaf(newNode, "type: radial gradient");
                SWFTreeBuilder.addLeaf(newNode, "startGradientMatrix: " + fillStyle.getStartGradientMatrix());
                SWFTreeBuilder.addLeaf(newNode, "endGradientMatrix: " + fillStyle.getStartGradientMatrix());
                SWFTreeBuilder.addNode(newNode, fillStyle.getGradient());
                break;
            }
            case 19: {
                SWFTreeBuilder.addLeaf(newNode, "type: focal radial gradient");
                SWFTreeBuilder.addLeaf(newNode, "startGradientMatrix: " + fillStyle.getStartGradientMatrix());
                SWFTreeBuilder.addLeaf(newNode, "endGradientMatrix: " + fillStyle.getStartGradientMatrix());
                SWFTreeBuilder.addNode(newNode, fillStyle.getGradient());
                break;
            }
            case 64: {
                SWFTreeBuilder.addLeaf(newNode, "type: repeating bitmap");
                SWFTreeBuilder.addLeaf(newNode, "bitmapId: " + fillStyle.getBitmapId());
                SWFTreeBuilder.addLeaf(newNode, "startBitmapMatrix: " + fillStyle.getStartBitmapMatrix());
                SWFTreeBuilder.addLeaf(newNode, "endBitmapMatrix: " + fillStyle.getEndBitmapMatrix());
                break;
            }
            case 65: {
                SWFTreeBuilder.addLeaf(newNode, "type: clipped bitmap");
                SWFTreeBuilder.addLeaf(newNode, "bitmapId: " + fillStyle.getBitmapId());
                SWFTreeBuilder.addLeaf(newNode, "startBitmapMatrix: " + fillStyle.getStartBitmapMatrix());
                SWFTreeBuilder.addLeaf(newNode, "endBitmapMatrix: " + fillStyle.getEndBitmapMatrix());
                break;
            }
            case 66: {
                SWFTreeBuilder.addLeaf(newNode, "type: non-smoothed repeating bitmap");
                SWFTreeBuilder.addLeaf(newNode, "bitmapId: " + fillStyle.getBitmapId());
                SWFTreeBuilder.addLeaf(newNode, "startBitmapMatrix: " + fillStyle.getStartBitmapMatrix());
                SWFTreeBuilder.addLeaf(newNode, "endBitmapMatrix: " + fillStyle.getEndBitmapMatrix());
                break;
            }
            case 67: {
                SWFTreeBuilder.addLeaf(newNode, "type: non-smoothed clipped bitmap");
                SWFTreeBuilder.addLeaf(newNode, "bitmapId: " + fillStyle.getBitmapId());
                SWFTreeBuilder.addLeaf(newNode, "startBitmapMatrix: " + fillStyle.getStartBitmapMatrix());
                SWFTreeBuilder.addLeaf(newNode, "endBitmapMatrix: " + fillStyle.getEndBitmapMatrix());
                break;
            }
            default: {
                SWFTreeBuilder.addLeaf(newNode, "unknown type: " + type);
            }
        }
    }

    private static void addNode(DefaultMutableTreeNode node, MorphGradient gradient) {
        DefaultMutableTreeNode morphGradNode = SWFTreeBuilder.addParentNode(node, gradient instanceof FocalMorphGradient ? "FocalMorphGradient" : "MorphGradient");
        SWFTreeBuilder.addLeaf(morphGradNode, "spreadMethod: " + SWFTreeBuilder.getSpreadMethodString(gradient.getSpreadMethod()));
        SWFTreeBuilder.addLeaf(morphGradNode, "interpolationMethod: " + SWFTreeBuilder.getInterpolationMethodString(gradient.getInterpolationMethod()));
        if (gradient instanceof FocalMorphGradient) {
            FocalMorphGradient focalMorphGradient = (FocalMorphGradient)gradient;
            SWFTreeBuilder.addLeaf(morphGradNode, "startFocalPointRatio: " + focalMorphGradient.getStartFocalPointRatio());
            SWFTreeBuilder.addLeaf(morphGradNode, "endFocalPointRatio: " + focalMorphGradient.getEndFocalPointRatio());
        }
        MorphGradRecord[] records = gradient.getGradientRecords();
        int i = 0;
        while (i < records.length) {
            DefaultMutableTreeNode recordNode = SWFTreeBuilder.addParentNode(morphGradNode, "MorphGradRecord");
            SWFTreeBuilder.addLeaf(recordNode, "startRatio: " + records[i].getStartRatio());
            SWFTreeBuilder.addLeaf(recordNode, "startColor: " + records[i].getStartColor());
            SWFTreeBuilder.addLeaf(recordNode, "endRatio: " + records[i].getEndRatio());
            SWFTreeBuilder.addLeaf(recordNode, "endColor: " + records[i].getEndColor());
            ++i;
        }
    }

    private static void addNode(DefaultMutableTreeNode node, DefineShape tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatDefTag("DefineShape"));
        SWFTreeBuilder.addLeaf(tagNode, "characterID: " + tag.getCharacterId());
        SWFTreeBuilder.addLeaf(tagNode, "shapeBounds: " + tag.getShapeBounds());
        SWFTreeBuilder.addNode(tagNode, "shapes: ", tag.getShapes());
    }

    private static void addNode(DefaultMutableTreeNode node, DefineShape2 tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatDefTag("DefineShape2"));
        SWFTreeBuilder.addLeaf(tagNode, "characterID: " + tag.getCharacterId());
        SWFTreeBuilder.addLeaf(tagNode, "shapeBounds: " + tag.getShapeBounds());
        SWFTreeBuilder.addNode(tagNode, "shapes: ", tag.getShapes());
    }

    private static void addNode(DefaultMutableTreeNode node, DefineShape3 tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatDefTag("DefineShape3"));
        SWFTreeBuilder.addLeaf(tagNode, "characterID: " + tag.getCharacterId());
        SWFTreeBuilder.addLeaf(tagNode, "shapeBounds: " + tag.getShapeBounds());
        SWFTreeBuilder.addNode(tagNode, "shapes: ", tag.getShapes());
    }

    private static void addNode(DefaultMutableTreeNode node, DefineShape4 tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatDefTag("DefineShape4"));
        SWFTreeBuilder.addLeaf(tagNode, "characterID: " + tag.getCharacterId());
        SWFTreeBuilder.addLeaf(tagNode, "shapeBounds: " + tag.getShapeBounds());
        SWFTreeBuilder.addLeaf(tagNode, "edgeBounds: " + tag.getEdgeBounds());
        SWFTreeBuilder.addNode(tagNode, "shapes: ", tag.getShapes());
    }

    private static void addNode(DefaultMutableTreeNode node, String var, ShapeWithStyle shapeWithStyle) {
        DefaultMutableTreeNode newNode = SWFTreeBuilder.addParentNode(node, var + "ShapeWithStyle");
        SWFTreeBuilder.addNode(newNode, "fillStyles: ", shapeWithStyle.getFillStyles());
        SWFTreeBuilder.addNode(newNode, "lineStyles: ", shapeWithStyle.getLineStyles());
        ShapeRecord[] shapeRecords = shapeWithStyle.getShapeRecords();
        if (shapeRecords.length > 0) {
            DefaultMutableTreeNode recordsNode = SWFTreeBuilder.addParentNode(newNode, "shapeRecords: ShapeRecord[" + shapeRecords.length + "]");
            int i = 0;
            while (i < shapeRecords.length) {
                SWFTreeBuilder.addNode(recordsNode, shapeRecords[i]);
                ++i;
            }
        }
    }

    private static void addNode(DefaultMutableTreeNode node, ShapeRecord record) {
        if (record instanceof StyleChangeRecord) {
            SWFTreeBuilder.addNode(node, (StyleChangeRecord)record);
        } else if (record instanceof StraightEdgeRecord) {
            SWFTreeBuilder.addNode(node, (StraightEdgeRecord)record);
        } else {
            SWFTreeBuilder.addNode(node, (CurvedEdgeRecord)record);
        }
    }

    private static void addNode(DefaultMutableTreeNode node, StraightEdgeRecord record) {
        DefaultMutableTreeNode newNode = SWFTreeBuilder.addParentNode(node, "StraightEdgeRecord");
        SWFTreeBuilder.addLeaf(newNode, "deltaX: " + record.getDeltaX());
        SWFTreeBuilder.addLeaf(newNode, "deltaY: " + record.getDeltaY());
    }

    private static void addNode(DefaultMutableTreeNode node, CurvedEdgeRecord record) {
        DefaultMutableTreeNode newNode = SWFTreeBuilder.addParentNode(node, "CurvedEdgeRecord");
        SWFTreeBuilder.addLeaf(newNode, "controlDeltaX: " + record.getControlDeltaX());
        SWFTreeBuilder.addLeaf(newNode, "controlDeltaX: " + record.getControlDeltaY());
        SWFTreeBuilder.addLeaf(newNode, "anchorDeltaX: " + record.getAnchorDeltaX());
        SWFTreeBuilder.addLeaf(newNode, "anchorDeltaY: " + record.getAnchorDeltaY());
    }

    private static void addNode(DefaultMutableTreeNode node, StyleChangeRecord record) {
        DefaultMutableTreeNode newNode = SWFTreeBuilder.addParentNode(node, "StyleChangeRecord");
        if (record.hasMoveTo()) {
            SWFTreeBuilder.addLeaf(newNode, "moveToX: " + record.getMoveToX());
            SWFTreeBuilder.addLeaf(newNode, "moveToY: " + record.getMoveToY());
        }
        if (record.hasFillStyle0()) {
            SWFTreeBuilder.addLeaf(newNode, "fillStyle0: " + record.getFillStyle0());
        }
        if (record.hasFillStyle1()) {
            SWFTreeBuilder.addLeaf(newNode, "fillStyle1: " + record.getFillStyle1());
        }
        if (record.hasLineStyle()) {
            SWFTreeBuilder.addLeaf(newNode, "lineStyle: " + record.getLineStyle());
        }
        if (record.hasNewStyles()) {
            DefaultMutableTreeNode newStylesNode = SWFTreeBuilder.addParentNode(newNode, "NewStyles");
            SWFTreeBuilder.addNode(newStylesNode, "newFillStyles: ", record.getNewFillStyles());
            SWFTreeBuilder.addNode(newStylesNode, "newLineStyles: ", record.getNewLineStyles());
        }
    }

    private static void addNode(DefaultMutableTreeNode node, String var, FillStyleArray fillStyleArray) {
        DefaultMutableTreeNode newNode = SWFTreeBuilder.addParentNode(node, var + "FillStyleArray (" + fillStyleArray.getSize() + " styles)");
        int i = 1;
        while (i <= fillStyleArray.getSize()) {
            SWFTreeBuilder.addNode(newNode, fillStyleArray.getStyle(i), i);
            ++i;
        }
    }

    private static void addNode(DefaultMutableTreeNode node, FillStyle fillStyle, int index) {
        DefaultMutableTreeNode newNode = index > 0 ? SWFTreeBuilder.addParentNode(node, "FillStyle " + index) : SWFTreeBuilder.addParentNode(node, "FillStyle");
        switch (fillStyle.getType()) {
            case 0: {
                SWFTreeBuilder.addLeaf(newNode, "type: solid");
                SWFTreeBuilder.addLeaf(newNode, "color: " + fillStyle.getColor());
                break;
            }
            case 16: {
                SWFTreeBuilder.addLeaf(newNode, "type: linear gradient");
                SWFTreeBuilder.addLeaf(newNode, "gradientMatrix: " + fillStyle.getGradientMatrix());
                SWFTreeBuilder.addNode(newNode, "gradient", fillStyle.getGradient());
                break;
            }
            case 18: {
                SWFTreeBuilder.addLeaf(newNode, "type: radial gradient");
                SWFTreeBuilder.addLeaf(newNode, "gradientMatrix: " + fillStyle.getGradientMatrix());
                SWFTreeBuilder.addNode(newNode, "gradient", fillStyle.getGradient());
                break;
            }
            case 19: {
                SWFTreeBuilder.addLeaf(newNode, "type: focal radial gradient");
                SWFTreeBuilder.addLeaf(newNode, "gradientMatrix: " + fillStyle.getGradientMatrix());
                SWFTreeBuilder.addNode(newNode, "gradient", fillStyle.getGradient());
                break;
            }
            case 64: {
                SWFTreeBuilder.addLeaf(newNode, "type: repeating bitmap");
                SWFTreeBuilder.addLeaf(newNode, "bitmapId: " + fillStyle.getBitmapId());
                SWFTreeBuilder.addLeaf(newNode, "bitmapMatrix: " + fillStyle.getBitmapMatrix());
                break;
            }
            case 65: {
                SWFTreeBuilder.addLeaf(newNode, "type: clipped bitmap");
                SWFTreeBuilder.addLeaf(newNode, "bitmapId: " + fillStyle.getBitmapId());
                SWFTreeBuilder.addLeaf(newNode, "bitmapMatrix: " + fillStyle.getBitmapMatrix());
                break;
            }
            case 66: {
                SWFTreeBuilder.addLeaf(newNode, "type: non-smoothed repeating bitmap");
                SWFTreeBuilder.addLeaf(newNode, "bitmapId: " + fillStyle.getBitmapId());
                SWFTreeBuilder.addLeaf(newNode, "bitmapMatrix: " + fillStyle.getBitmapMatrix());
                break;
            }
            case 67: {
                SWFTreeBuilder.addLeaf(newNode, "type: non-smoothed clipped bitmap");
                SWFTreeBuilder.addLeaf(newNode, "bitmapId: " + fillStyle.getBitmapId());
                SWFTreeBuilder.addLeaf(newNode, "bitmapMatrix: " + fillStyle.getBitmapMatrix());
                break;
            }
            default: {
                SWFTreeBuilder.addLeaf(newNode, "unknown fill type: " + fillStyle.getType());
            }
        }
    }

    private static void addNode(DefaultMutableTreeNode node, LineStyle lineStyle, int index) {
        DefaultMutableTreeNode newNode = SWFTreeBuilder.addParentNode(node, "LineStyle " + index);
        SWFTreeBuilder.addLeaf(newNode, "width: " + lineStyle.getWidth());
        SWFTreeBuilder.addLeaf(newNode, "color: " + lineStyle.getColor());
    }

    private static void addNode(DefaultMutableTreeNode node, LineStyle2 lineStyle, int index) {
        DefaultMutableTreeNode newNode = SWFTreeBuilder.addParentNode(node, "LineStyle2 " + index);
        SWFTreeBuilder.addLeaf(newNode, "width: " + lineStyle.getWidth());
        SWFTreeBuilder.addLeaf(newNode, "startCapStyle: " + SWFTreeBuilder.getCapStyleString(lineStyle.getStartCapStyle()));
        SWFTreeBuilder.addLeaf(newNode, "endCapStyle: " + SWFTreeBuilder.getCapStyleString(lineStyle.getEndCapStyle()));
        byte jointStyle = lineStyle.getJointStyle();
        SWFTreeBuilder.addLeaf(newNode, "jointStyle: " + SWFTreeBuilder.getJointStyleString(jointStyle));
        if (jointStyle == 2) {
            SWFTreeBuilder.addLeaf(newNode, "miterLimit: " + lineStyle.getMiterLimit());
        }
        SWFTreeBuilder.addLeaf(newNode, "pixelHinting: " + lineStyle.isPixelHinting());
        SWFTreeBuilder.addLeaf(newNode, "close: " + lineStyle.isClose());
        SWFTreeBuilder.addLeaf(newNode, "scaleStroke: " + SWFTreeBuilder.getScaleStrokeString(lineStyle.getScaleStroke()));
        FillStyle fillStyle = lineStyle.getFillStyle();
        if (fillStyle == null) {
            SWFTreeBuilder.addLeaf(newNode, "color: " + lineStyle.getColor());
        } else {
            SWFTreeBuilder.addNode(newNode, fillStyle, 0);
        }
    }

    private static void addNode(DefaultMutableTreeNode node, String var, Gradient gradient) {
        DefaultMutableTreeNode newNode = SWFTreeBuilder.addParentNode(node, gradient instanceof FocalGradient ? "FocalGradient" : "Gradient");
        SWFTreeBuilder.addLeaf(newNode, "spreadMethod: " + SWFTreeBuilder.getSpreadMethodString(gradient.getSpreadMethod()));
        SWFTreeBuilder.addLeaf(newNode, "interpolationMethod: " + SWFTreeBuilder.getInterpolationMethodString(gradient.getInterpolationMethod()));
        if (gradient instanceof FocalGradient) {
            SWFTreeBuilder.addLeaf(newNode, "focalPointRatio: " + ((FocalGradient)gradient).getFocalPointRatio());
        }
        GradRecord[] records = gradient.getGradientRecords();
        int i = 0;
        while (i < records.length) {
            SWFTreeBuilder.addNode(newNode, records[i]);
            ++i;
        }
    }

    private static void addNode(DefaultMutableTreeNode node, GradRecord record) {
        DefaultMutableTreeNode newNode = SWFTreeBuilder.addParentNode(node, "GradientRecord");
        SWFTreeBuilder.addLeaf(newNode, "ratio: " + record.getRatio());
        SWFTreeBuilder.addLeaf(newNode, "color: " + record.getColor());
    }

    private static void addNode(DefaultMutableTreeNode node, String var, LineStyleArray lineStyleArray) {
        DefaultMutableTreeNode newNode = SWFTreeBuilder.addParentNode(node, var + "LineStyleArray (" + lineStyleArray.getSize() + " styles)");
        int i = 1;
        while (i <= lineStyleArray.getSize()) {
            Object style = lineStyleArray.getStyle(i);
            if (style instanceof LineStyle) {
                SWFTreeBuilder.addNode(newNode, (LineStyle)style, i);
            } else {
                SWFTreeBuilder.addNode(newNode, (LineStyle2)style, i);
            }
            ++i;
        }
    }

    private static void addNode(DefaultMutableTreeNode node, DefineSound tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatDefTag("DefineSound"));
        SWFTreeBuilder.addLeaf(tagNode, "characterId: " + tag.getCharacterId());
        byte format = tag.getFormat();
        SWFTreeBuilder.addLeaf(tagNode, "format: " + format + " (" + SWFTreeBuilder.getSoundFormatString(format) + ")");
        byte rate = tag.getRate();
        SWFTreeBuilder.addLeaf(tagNode, "rate: " + rate + " (" + SWFTreeBuilder.getSoundRateString(rate) + ")");
        int sampleSize = tag.is16BitSample() ? 16 : 8;
        SWFTreeBuilder.addLeaf(tagNode, "sampleSize: " + sampleSize + " bits");
        String type = tag.isStereo() ? "stereo" : "mono";
        SWFTreeBuilder.addLeaf(tagNode, "type: " + type);
        SWFTreeBuilder.addLeaf(tagNode, "sampleCount: " + tag.getSampleCount());
        SWFTreeBuilder.addLeaf(tagNode, "soundData:  byte[" + tag.getSoundData().length + "]");
    }

    private static void addNode(DefaultMutableTreeNode node, DefineSprite tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatDefTag("DefineSprite"));
        SWFTreeBuilder.addLeaf(tagNode, "characterId: " + tag.getCharacterId());
        SWFTreeBuilder.addLeaf(tagNode, "frameCount: " + tag.getFrameCount());
        List ctrlTags = tag.getControlTags();
        DefaultMutableTreeNode ctrlTagNode = SWFTreeBuilder.addParentNode(tagNode, "controlTags: Tag[" + ctrlTags.size() + "]");
        int i = 0;
        while (i < ctrlTags.size()) {
            SWFTreeBuilder.addNode(ctrlTagNode, (Tag)ctrlTags.get(i));
            ++i;
        }
    }

    private static void addNode(DefaultMutableTreeNode node, DefineText tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatDefTag("DefineText"));
        SWFTreeBuilder.addLeaf(tagNode, "characterId: " + tag.getCharacterId());
        SWFTreeBuilder.addLeaf(tagNode, "textBounds: " + tag.getTextBounds());
        SWFTreeBuilder.addLeaf(tagNode, "textMatrix: " + tag.getTextMatrix());
        SWFTreeBuilder.addNode(tagNode, "textRecords: ", tag.getTextRecords());
    }

    private static void addNode(DefaultMutableTreeNode node, DefineText2 tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatDefTag("DefineText2"));
        SWFTreeBuilder.addLeaf(tagNode, "characterId: " + tag.getCharacterId());
        SWFTreeBuilder.addLeaf(tagNode, "textBounds: " + tag.getTextBounds());
        SWFTreeBuilder.addLeaf(tagNode, "textMatrix: " + tag.getTextMatrix());
        SWFTreeBuilder.addNode(tagNode, "textRecords: ", tag.getTextRecords());
    }

    private static void addNode(DefaultMutableTreeNode node, String var, TextRecord[] textRecords) {
        DefaultMutableTreeNode newNode = SWFTreeBuilder.addParentNode(node, var + "TextRecord[" + textRecords.length + "]");
        int i = 0;
        while (i < textRecords.length) {
            TextRecord record = textRecords[i];
            DefaultMutableTreeNode recNode = SWFTreeBuilder.addParentNode(newNode, "TextRecord");
            if (record.getFontId() > 0) {
                SWFTreeBuilder.addLeaf(recNode, "fontId: " + record.getFontId());
                SWFTreeBuilder.addLeaf(recNode, "textHeight: " + record.getTextHeight());
            }
            if (record.getTextColor() != null) {
                SWFTreeBuilder.addLeaf(recNode, "textColor: " + record.getTextColor());
            }
            if (record.getXOffset() != 0) {
                SWFTreeBuilder.addLeaf(recNode, "xOffset: " + record.getXOffset());
            }
            if (record.getYOffset() != 0) {
                SWFTreeBuilder.addLeaf(recNode, "yOffset: " + record.getYOffset());
            }
            SWFTreeBuilder.addNode(recNode, "glyphEntries: ", record.getGlyphEntries());
            ++i;
        }
    }

    private static void addNode(DefaultMutableTreeNode node, String var, GlyphEntry[] glyphEntries) {
        DefaultMutableTreeNode newNode = SWFTreeBuilder.addParentNode(node, var + "GlyphEntry[" + glyphEntries.length + "]");
        int i = 0;
        while (i < glyphEntries.length) {
            GlyphEntry entry = glyphEntries[i];
            DefaultMutableTreeNode entryNode = SWFTreeBuilder.addParentNode(newNode, "GlyphEntry");
            SWFTreeBuilder.addLeaf(entryNode, "glyphIndex: " + entry.getGlyphIndex());
            SWFTreeBuilder.addLeaf(entryNode, "glyphAdvance: " + entry.getGlyphAdvance());
            ++i;
        }
    }

    private static void addNode(DefaultMutableTreeNode node, DefineVideoStream tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatDefTag("DefineVideoStream"));
        SWFTreeBuilder.addLeaf(tagNode, "characterId: " + tag.getCharacterId());
        SWFTreeBuilder.addLeaf(tagNode, "numFrames: " + tag.getNumFrames());
        SWFTreeBuilder.addLeaf(tagNode, "width: " + tag.getWidth());
        SWFTreeBuilder.addLeaf(tagNode, "height: " + tag.getHeight());
        String deblocking = "unknown value";
        switch (tag.getDeblocking()) {
            case 1: {
                deblocking = "off";
                break;
            }
            case 2: {
                deblocking = "on";
                break;
            }
            case 0: {
                deblocking = "use video packet setting";
                break;
            }
        }
        SWFTreeBuilder.addLeaf(tagNode, "deblocking: " + deblocking);
        SWFTreeBuilder.addLeaf(tagNode, "smoothing: " + (tag.isSmoothing() ? "on" : "off"));
        String codec = "unknown codec";
        short codecId = tag.getCodecId();
        switch (codecId) {
            case 2: {
                codec = "Sorenson H.263";
                break;
            }
            case 3: {
                codec = "Screen Video";
                break;
            }
            case 4: {
                codec = "On2 VP6";
                break;
            }
            case 5: {
                codec = "On2 VP6 with alpha";
                break;
            }
            case 6: {
                codec = "Screen Video V2";
                break;
            }
            default: {
                codec = "unknown codec: " + codecId;
            }
        }
        SWFTreeBuilder.addLeaf(tagNode, "codec: " + codec);
    }

    private static void addNode(DefaultMutableTreeNode node, DoAction tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatControlTag("DoAction"));
        SWFTreeBuilder.addNode(tagNode, "actions: ", tag.getActions());
    }

    private static void addNode(DefaultMutableTreeNode node, DoInitAction tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatControlTag("DoInitAction"));
        SWFTreeBuilder.addLeaf(tagNode, "spriteId: " + tag.getSpriteId());
        SWFTreeBuilder.addNode(tagNode, "actions: ", tag.getInitActions());
    }

    private static void addNode(DefaultMutableTreeNode node, EnableDebugger tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatControlTag("EnableDebugger"));
        String password = tag.getPassword();
        if (password == null) {
            SWFTreeBuilder.addLeaf(tagNode, "No password");
        } else {
            SWFTreeBuilder.addLeaf(tagNode, "password: " + password);
        }
    }

    private static void addNode(DefaultMutableTreeNode node, EnableDebugger2 tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatControlTag("EnableDebugger2"));
        String password = tag.getPassword();
        if (password == null) {
            SWFTreeBuilder.addLeaf(tagNode, "No password");
        } else {
            SWFTreeBuilder.addLeaf(tagNode, "password: " + password);
        }
    }

    private static void addNode(DefaultMutableTreeNode node, ExportAssets tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatControlTag("ExportAssets"));
        ExportAssets.ExportMapping[] exportMappings = tag.getExportMappings();
        int i = 0;
        while (i < exportMappings.length) {
            SWFTreeBuilder.addLeaf(tagNode, "characterId: " + exportMappings[i].getCharacterId() + ", name: " + exportMappings[i].getName());
            ++i;
        }
    }

    private static void addNode(DefaultMutableTreeNode node, FileAttributes tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatControlTag("FileAttributes"));
        SWFTreeBuilder.addLeaf(tagNode, "allowNetworkAccess: " + tag.isAllowNetworkAccess());
        SWFTreeBuilder.addLeaf(tagNode, "hasMetadata: " + tag.hasMetadata());
    }

    private static void addNode(DefaultMutableTreeNode node, FrameLabel tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatControlTag("FrameLabel"));
        SWFTreeBuilder.addLeaf(tagNode, "name: " + tag.getName());
        SWFTreeBuilder.addLeaf(tagNode, "namedAnchor: " + tag.isNamedAnchor());
    }

    private static void addNode(DefaultMutableTreeNode node, ImportAssets tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatControlTag(tag instanceof ImportAssets2 ? "ImportAssets2" : "ImportAssets"));
        SWFTreeBuilder.addLeaf(tagNode, "url: " + tag.getUrl());
        ImportAssets.ImportMapping[] importMappings = tag.getImportMappings();
        DefaultMutableTreeNode mappingsNode = SWFTreeBuilder.addParentNode(tagNode, "importMappings[" + importMappings.length + "]");
        int i = 0;
        while (i < importMappings.length) {
            SWFTreeBuilder.addLeaf(mappingsNode, "name: " + importMappings[i].getName() + ", characterId: " + importMappings[i].getCharacterId());
            ++i;
        }
    }

    private static void addNode(DefaultMutableTreeNode node, JPEGTables tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatDefTag("JPEGTables"));
        SWFTreeBuilder.addLeaf(tagNode, "jpegData:  byte[" + tag.getJpegData().length + "]");
    }

    private static void addNode(DefaultMutableTreeNode node, Metadata tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatControlTag("Metadata"));
        SWFTreeBuilder.addLeaf(tagNode, "data: " + tag.getDataString());
    }

    private static void addNode(DefaultMutableTreeNode node, PlaceObject tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatControlTag("PlaceObject"));
        SWFTreeBuilder.addLeaf(tagNode, "characterId: " + tag.getCharacterId());
        SWFTreeBuilder.addLeaf(tagNode, "depth: " + tag.getDepth());
        SWFTreeBuilder.addLeaf(tagNode, "matrix: " + tag.getMatrix());
        if (tag.getColorTransform() != null) {
            SWFTreeBuilder.addNode(tagNode, "colorTransform: ", tag.getColorTransform());
        }
    }

    private static void addNode(DefaultMutableTreeNode node, String var, CXform cXform) {
        DefaultMutableTreeNode newNode = SWFTreeBuilder.addParentNode(node, var + "CXform");
        if (cXform.hasMultTerms()) {
            SWFTreeBuilder.addLeaf(newNode, "redMultTerm: " + cXform.getRedMultTerm());
            SWFTreeBuilder.addLeaf(newNode, "greenMultTerm: " + cXform.getGreenMultTerm());
            SWFTreeBuilder.addLeaf(newNode, "blueMultTerm: " + cXform.getBlueMultTerm());
        } else {
            SWFTreeBuilder.addLeaf(newNode, "no multiplication transform");
        }
        if (cXform.hasAddTerms()) {
            SWFTreeBuilder.addLeaf(newNode, "redAddTerm: " + cXform.getRedAddTerm());
            SWFTreeBuilder.addLeaf(newNode, "greenAddTerm: " + cXform.getGreenAddTerm());
            SWFTreeBuilder.addLeaf(newNode, "blueAddTerm: " + cXform.getBlueAddTerm());
        } else {
            SWFTreeBuilder.addLeaf(newNode, "no addition transform");
        }
    }

    private static void addNode(DefaultMutableTreeNode node, String var, CXformWithAlpha xform) {
        DefaultMutableTreeNode newNode = SWFTreeBuilder.addParentNode(node, var + "CXformWithAlpha");
        if (xform.hasMultTerms()) {
            SWFTreeBuilder.addLeaf(newNode, "redMultTerm: " + xform.getRedMultTerm());
            SWFTreeBuilder.addLeaf(newNode, "greenMultTerm: " + xform.getGreenMultTerm());
            SWFTreeBuilder.addLeaf(newNode, "blueMultTerm: " + xform.getBlueMultTerm());
            SWFTreeBuilder.addLeaf(newNode, "alphaMultTerm: " + xform.getAlphaMultTerm());
        } else {
            SWFTreeBuilder.addLeaf(newNode, "no multiplication transform");
        }
        if (xform.hasAddTerms()) {
            SWFTreeBuilder.addLeaf(newNode, "redAddTerm: " + xform.getRedAddTerm());
            SWFTreeBuilder.addLeaf(newNode, "greenAddTerm: " + xform.getGreenAddTerm());
            SWFTreeBuilder.addLeaf(newNode, "blueAddTerm: " + xform.getBlueAddTerm());
            SWFTreeBuilder.addLeaf(newNode, "alphaAddTerm: " + xform.getAlphaAddTerm());
        } else {
            SWFTreeBuilder.addLeaf(newNode, "no addition transform");
        }
    }

    private static void addNode(DefaultMutableTreeNode node, PlaceObject2 tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatControlTag("PlaceObject2"));
        SWFTreeBuilder.addLeaf(tagNode, "depth: " + tag.getDepth());
        SWFTreeBuilder.addLeaf(tagNode, "move: " + tag.isMove());
        if (tag.hasCharacter()) {
            SWFTreeBuilder.addLeaf(tagNode, "characterId: " + tag.getCharacterId());
        }
        if (tag.hasMatrix()) {
            SWFTreeBuilder.addLeaf(tagNode, "matrix: " + tag.getMatrix());
        }
        if (tag.hasColorTransform()) {
            SWFTreeBuilder.addNode(tagNode, "colorTransform: ", tag.getColorTransform());
        }
        if (tag.hasRatio()) {
            SWFTreeBuilder.addLeaf(tagNode, "ratio: " + tag.getRatio());
        }
        if (tag.hasName()) {
            SWFTreeBuilder.addLeaf(tagNode, "name: " + tag.getName());
        }
        if (tag.hasClipDepth()) {
            SWFTreeBuilder.addLeaf(tagNode, "clipDepth: " + tag.getClipDepth());
        }
        if (tag.hasClipActions()) {
            SWFTreeBuilder.addNode(tagNode, "clipActions: ", tag.getClipActions());
        }
    }

    private static void addNode(DefaultMutableTreeNode node, PlaceObject3 tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatControlTag("PlaceObject3"));
        SWFTreeBuilder.addLeaf(tagNode, "depth: " + tag.getDepth());
        SWFTreeBuilder.addLeaf(tagNode, "move: " + tag.isMove());
        if (tag.hasCharacter()) {
            SWFTreeBuilder.addLeaf(tagNode, "characterId: " + tag.getCharacterId());
        }
        if (tag.hasMatrix()) {
            SWFTreeBuilder.addLeaf(tagNode, "matrix: " + tag.getMatrix());
        }
        if (tag.hasColorTransform()) {
            SWFTreeBuilder.addNode(tagNode, "colorTransform: ", tag.getColorTransform());
        }
        if (tag.hasRatio()) {
            SWFTreeBuilder.addLeaf(tagNode, "ratio: " + tag.getRatio());
        }
        if (tag.hasName()) {
            SWFTreeBuilder.addLeaf(tagNode, "name: " + tag.getName());
        }
        if (tag.hasClipDepth()) {
            SWFTreeBuilder.addLeaf(tagNode, "clipDepth: " + tag.getClipDepth());
        }
        SWFTreeBuilder.addLeaf(tagNode, "cacheAsBitmap: " + tag.isCacheAsBitmap());
        if (tag.hasFilters()) {
            List filters = tag.getFilters();
            int count = filters.size();
            DefaultMutableTreeNode filtersNode = SWFTreeBuilder.addParentNode(tagNode, "filters: Filter[" + count + "]");
            int i = 0;
            while (i < count) {
                SWFTreeBuilder.addNode(filtersNode, (Filter)filters.get(i));
                ++i;
            }
        }
        if (tag.hasBlendMode()) {
            short blendMode = tag.getBlendMode();
            SWFTreeBuilder.addLeaf(tagNode, "blendMode: " + BlendMode.getDescription(blendMode));
        }
        if (tag.hasClipActions()) {
            SWFTreeBuilder.addNode(tagNode, "clipActions: ", tag.getClipActions());
        }
    }

    private static void addNode(DefaultMutableTreeNode node, Filter filter) {
        if (filter instanceof ColorMatrixFilter) {
            ColorMatrixFilter colorMatrixFilter = (ColorMatrixFilter)filter;
            DefaultMutableTreeNode filterNode = SWFTreeBuilder.addParentNode(node, "ColorMatrixFilter");
            float[] matrix = colorMatrixFilter.getMatrix();
            StringBuffer matrixBuffer = new StringBuffer("matrix: ");
            int i = 0;
            while (i < matrix.length) {
                matrixBuffer.append(matrix[i]);
                matrixBuffer.append(" ");
                ++i;
            }
            SWFTreeBuilder.addLeaf(filterNode, matrixBuffer.toString());
        } else if (filter instanceof ConvolutionFilter) {
            ConvolutionFilter convolutionFilter = (ConvolutionFilter)filter;
            DefaultMutableTreeNode filterNode = SWFTreeBuilder.addParentNode(node, "ConvolutionFilter");
            SWFTreeBuilder.addLeaf(filterNode, "matrixRows: " + convolutionFilter.getMatrixRows());
            float[] matrix = convolutionFilter.getMatrix();
            StringBuffer matrixBuffer = new StringBuffer("matrix: ");
            int i = 0;
            while (i < matrix.length) {
                matrixBuffer.append(matrix[i]);
                matrixBuffer.append(" ");
                ++i;
            }
            SWFTreeBuilder.addLeaf(filterNode, matrixBuffer.toString());
            SWFTreeBuilder.addLeaf(filterNode, "color: " + convolutionFilter.getColor());
            SWFTreeBuilder.addLeaf(filterNode, "divisor: " + convolutionFilter.getDivisor());
            SWFTreeBuilder.addLeaf(filterNode, "bias: " + convolutionFilter.getBias());
            SWFTreeBuilder.addLeaf(filterNode, "clamp: " + convolutionFilter.isClamp());
            SWFTreeBuilder.addLeaf(filterNode, "preserveAlpha: " + convolutionFilter.isPreserveAlpha());
        } else if (filter instanceof BlurFilter) {
            BlurFilter blurFilter = (BlurFilter)filter;
            DefaultMutableTreeNode filterNode = SWFTreeBuilder.addParentNode(node, "BlurFilter");
            SWFTreeBuilder.addLeaf(filterNode, "x: " + blurFilter.getX());
            SWFTreeBuilder.addLeaf(filterNode, "y: " + blurFilter.getY());
            SWFTreeBuilder.addLeaf(filterNode, "quality: " + blurFilter.getQuality());
        } else if (filter instanceof DropShadowFilter) {
            DropShadowFilter dropShadowFilter = (DropShadowFilter)filter;
            DefaultMutableTreeNode filterNode = SWFTreeBuilder.addParentNode(node, "DropShadowFilter");
            SWFTreeBuilder.addLeaf(filterNode, "color: " + dropShadowFilter.getColor());
            SWFTreeBuilder.addLeaf(filterNode, "x: " + dropShadowFilter.getX());
            SWFTreeBuilder.addLeaf(filterNode, "y: " + dropShadowFilter.getY());
            SWFTreeBuilder.addLeaf(filterNode, "angle: " + dropShadowFilter.getAngle());
            SWFTreeBuilder.addLeaf(filterNode, "distance: " + dropShadowFilter.getDistance());
            SWFTreeBuilder.addLeaf(filterNode, "strength: " + dropShadowFilter.getStrength());
            SWFTreeBuilder.addLeaf(filterNode, "quality: " + dropShadowFilter.getQuality());
            SWFTreeBuilder.addLeaf(filterNode, "inner: " + dropShadowFilter.isInner());
            SWFTreeBuilder.addLeaf(filterNode, "knockout: " + dropShadowFilter.isKnockout());
            SWFTreeBuilder.addLeaf(filterNode, "hideObject: " + dropShadowFilter.isHideObject());
        } else if (filter instanceof GlowFilter) {
            GlowFilter glowFilter = (GlowFilter)filter;
            DefaultMutableTreeNode filterNode = SWFTreeBuilder.addParentNode(node, "GlowFilter");
            SWFTreeBuilder.addLeaf(filterNode, "color: " + glowFilter.getColor());
            SWFTreeBuilder.addLeaf(filterNode, "x: " + glowFilter.getX());
            SWFTreeBuilder.addLeaf(filterNode, "y: " + glowFilter.getY());
            SWFTreeBuilder.addLeaf(filterNode, "strength: " + glowFilter.getStrength());
            SWFTreeBuilder.addLeaf(filterNode, "quality: " + glowFilter.getQuality());
            SWFTreeBuilder.addLeaf(filterNode, "inner: " + glowFilter.isInner());
            SWFTreeBuilder.addLeaf(filterNode, "knockout: " + glowFilter.isKnockout());
        } else if (filter instanceof BevelFilter) {
            BevelFilter bevelFilter = (BevelFilter)filter;
            DefaultMutableTreeNode filterNode = SWFTreeBuilder.addParentNode(node, "BevelFilter");
            SWFTreeBuilder.addLeaf(filterNode, "highlightColor: " + bevelFilter.getHighlightColor());
            SWFTreeBuilder.addLeaf(filterNode, "shadowColor: " + bevelFilter.getShadowColor());
            SWFTreeBuilder.addLeaf(filterNode, "x: " + bevelFilter.getX());
            SWFTreeBuilder.addLeaf(filterNode, "y: " + bevelFilter.getY());
            SWFTreeBuilder.addLeaf(filterNode, "angle: " + bevelFilter.getAngle());
            SWFTreeBuilder.addLeaf(filterNode, "distance: " + bevelFilter.getDistance());
            SWFTreeBuilder.addLeaf(filterNode, "strength: " + bevelFilter.getStrength());
            SWFTreeBuilder.addLeaf(filterNode, "quality: " + bevelFilter.getQuality());
            SWFTreeBuilder.addLeaf(filterNode, "inner: " + bevelFilter.isInner());
            SWFTreeBuilder.addLeaf(filterNode, "knockout: " + bevelFilter.isKnockout());
            SWFTreeBuilder.addLeaf(filterNode, "onTop: " + bevelFilter.isOnTop());
        } else if (filter instanceof GradientGlowFilter) {
            GradientGlowFilter gradientGlowFilter = (GradientGlowFilter)filter;
            DefaultMutableTreeNode filterNode = SWFTreeBuilder.addParentNode(node, "GradientGlowFilter");
            RGBA[] colors = gradientGlowFilter.getColors();
            short[] ratios = gradientGlowFilter.getRatios();
            int controlPointsCount = colors.length;
            DefaultMutableTreeNode controlPointsNode = SWFTreeBuilder.addParentNode(filterNode, "control points[" + controlPointsCount + "]");
            int i = 0;
            while (i < controlPointsCount) {
                SWFTreeBuilder.addLeaf(controlPointsNode, "color " + i + ": " + colors[i] + " ratio: " + ratios[i]);
                ++i;
            }
            SWFTreeBuilder.addLeaf(filterNode, "x: " + gradientGlowFilter.getX());
            SWFTreeBuilder.addLeaf(filterNode, "y: " + gradientGlowFilter.getY());
            SWFTreeBuilder.addLeaf(filterNode, "angle: " + gradientGlowFilter.getAngle());
            SWFTreeBuilder.addLeaf(filterNode, "distance: " + gradientGlowFilter.getDistance());
            SWFTreeBuilder.addLeaf(filterNode, "strength: " + gradientGlowFilter.getStrength());
            SWFTreeBuilder.addLeaf(filterNode, "quality: " + gradientGlowFilter.getQuality());
            SWFTreeBuilder.addLeaf(filterNode, "inner: " + gradientGlowFilter.isInner());
            SWFTreeBuilder.addLeaf(filterNode, "knockout: " + gradientGlowFilter.isKnockout());
            SWFTreeBuilder.addLeaf(filterNode, "onTop: " + gradientGlowFilter.isOnTop());
        } else if (filter instanceof GradientBevelFilter) {
            GradientBevelFilter gradientBevelFilter = (GradientBevelFilter)filter;
            DefaultMutableTreeNode filterNode = SWFTreeBuilder.addParentNode(node, "GradientBevelFilter");
            RGBA[] colors = gradientBevelFilter.getColors();
            short[] ratios = gradientBevelFilter.getRatios();
            int controlPointsCount = colors.length;
            DefaultMutableTreeNode controlPointsNode = SWFTreeBuilder.addParentNode(filterNode, "control points[" + controlPointsCount + "]");
            int i = 0;
            while (i < controlPointsCount) {
                SWFTreeBuilder.addLeaf(controlPointsNode, "color " + i + ": " + colors[i] + " ratio: " + ratios[i]);
                ++i;
            }
            SWFTreeBuilder.addLeaf(filterNode, "x: " + gradientBevelFilter.getX());
            SWFTreeBuilder.addLeaf(filterNode, "y: " + gradientBevelFilter.getY());
            SWFTreeBuilder.addLeaf(filterNode, "angle: " + gradientBevelFilter.getAngle());
            SWFTreeBuilder.addLeaf(filterNode, "distance: " + gradientBevelFilter.getDistance());
            SWFTreeBuilder.addLeaf(filterNode, "strength: " + gradientBevelFilter.getStrength());
            SWFTreeBuilder.addLeaf(filterNode, "quality: " + gradientBevelFilter.getQuality());
            SWFTreeBuilder.addLeaf(filterNode, "inner: " + gradientBevelFilter.isInner());
            SWFTreeBuilder.addLeaf(filterNode, "knockout: " + gradientBevelFilter.isKnockout());
            SWFTreeBuilder.addLeaf(filterNode, "onTop: " + gradientBevelFilter.isOnTop());
        }
    }

    private static void addNode(DefaultMutableTreeNode node, String var, ClipActions clipActions) {
        DefaultMutableTreeNode newNode = SWFTreeBuilder.addParentNode(node, var + "ClipActions");
        SWFTreeBuilder.addNode(newNode, "allEventFlags: ", clipActions.getEventFlags());
        List records = clipActions.getClipActionRecords();
        int i = 0;
        while (i < records.size()) {
            SWFTreeBuilder.addNode(newNode, (ClipActionRecord)records.get(i));
            ++i;
        }
    }

    private static void addNode(DefaultMutableTreeNode node, ClipActionRecord clipActionRecord) {
        DefaultMutableTreeNode newNode = SWFTreeBuilder.addParentNode(node, "ClipActionRecord");
        SWFTreeBuilder.addNode(newNode, "eventFlags: ", clipActionRecord.getEventFlags());
        if (clipActionRecord.getEventFlags().isKeyPress()) {
            SWFTreeBuilder.addLeaf(newNode, "keyCode: " + clipActionRecord.getKeyCode());
        }
        SWFTreeBuilder.addNode(newNode, "actions: ", clipActionRecord.getActions());
    }

    private static void addNode(DefaultMutableTreeNode node, String var, ActionBlock actionBlock) {
        List actionRecords = actionBlock.getActions();
        DefaultMutableTreeNode newNode = SWFTreeBuilder.addParentNode(node, var + actionRecords.size() + " actions; size : " + actionBlock.getSize());
        int i = 0;
        while (i < actionRecords.size()) {
            SWFTreeBuilder.addNode(newNode, (Action)actionRecords.get(i));
            ++i;
        }
    }

    private static void addNode(DefaultMutableTreeNode node, Action action) {
        String actionDescription = "<html>";
        if (action.getLabel() != null) {
            actionDescription = actionDescription + "<code>" + action.getLabel() + "</code> @ ";
        }
        actionDescription = actionDescription + action.getOffset() + " (" + action.getSize() + "): ";
        switch (action.getCode()) {
            case 150: {
                actionDescription = actionDescription + SWFTreeBuilder.getPushDescription((Push)action);
                break;
            }
            case 143: {
                actionDescription = actionDescription + "Try";
                break;
            }
            case 157: {
                actionDescription = actionDescription + "If branchLabel: <code>" + ((If)action).getBranchLabel() + "</code> " + "branchOffset: " + ((If)action).getBranchOffset();
                break;
            }
            case 153: {
                actionDescription = actionDescription + "Jump branchLabel: <code>" + ((Jump)action).getBranchLabel() + "</code> " + "branchOffset: " + ((Jump)action).getBranchOffset();
                break;
            }
            default: {
                actionDescription = actionDescription + action.toString();
            }
        }
        actionDescription = actionDescription + "</html>";
        DefaultMutableTreeNode actionNode = SWFTreeBuilder.addParentNode(node, actionDescription);
        switch (action.getCode()) {
            case 136: {
                ConstantPool constantPool = (ConstantPool)action;
                constants = constantPool.getConstants();
                String constStr = "c" + (constants.size() > 255 ? "16" : "8") + "[";
                int i = 0;
                while (i < constants.size()) {
                    SWFTreeBuilder.addLeaf(actionNode, constStr + i + "]: " + constants.get(i));
                    ++i;
                }
                break;
            }
            case 148: {
                SWFTreeBuilder.addNode(actionNode, (With)action);
                break;
            }
            case 143: {
                SWFTreeBuilder.addNode(actionNode, (Try)action);
                break;
            }
            case 155: {
                SWFTreeBuilder.addNode(actionNode, (DefineFunction)action);
                break;
            }
            case 142: {
                SWFTreeBuilder.addNode(actionNode, (DefineFunction2)action);
                break;
            }
        }
    }

    private static void addNode(DefaultMutableTreeNode node, With action) {
        SWFTreeBuilder.addNode(node, "withBlock: ", action.getWithBlock());
    }

    private static void addNode(DefaultMutableTreeNode node, Try action) {
        boolean catchInRegister = action.catchInRegister();
        SWFTreeBuilder.addLeaf(node, "catchInRegister: " + catchInRegister);
        if (catchInRegister) {
            SWFTreeBuilder.addLeaf(node, "catchRegister: " + action.getCatchRegister());
        } else {
            SWFTreeBuilder.addLeaf(node, "catchVariable: " + action.getCatchVariable());
        }
        SWFTreeBuilder.addNode(node, "tryBlock: ", action.getTryBlock());
        if (action.hasCatchBlock()) {
            SWFTreeBuilder.addNode(node, "catchBlock: ", action.getCatchBlock());
        }
        if (action.hasFinallyBlock()) {
            SWFTreeBuilder.addNode(node, "finallyBlock: ", action.getFinallyBlock());
        }
    }

    private static void addNode(DefaultMutableTreeNode node, DefineFunction defineFunction) {
        String[] parameters = defineFunction.getParameters();
        String paramList = "";
        int i = 0;
        while (i < parameters.length) {
            paramList = paramList + parameters[i];
            if (i != parameters.length - 1) {
                paramList = paramList + ", ";
            }
            ++i;
        }
        SWFTreeBuilder.addLeaf(node, "parameters: " + paramList);
        SWFTreeBuilder.addNode(node, "body: ", defineFunction.getBody());
    }

    private static void addNode(DefaultMutableTreeNode node, DefineFunction2 defineFunction2) {
        DefaultMutableTreeNode headerNode = SWFTreeBuilder.addParentNode(node, "header");
        RegisterParam[] regParameters = defineFunction2.getParameters();
        DefaultMutableTreeNode paramsNode = SWFTreeBuilder.addParentNode(headerNode, "parameters: RegisterParam[" + regParameters.length + "]");
        int i = 0;
        while (i < regParameters.length) {
            DefaultMutableTreeNode paramNode = SWFTreeBuilder.addParentNode(paramsNode, "RegisterParam");
            RegisterParam regParam = regParameters[i];
            SWFTreeBuilder.addLeaf(paramNode, "register: " + regParam.getRegister());
            SWFTreeBuilder.addLeaf(paramNode, "paramName: " + regParam.getParamName());
            ++i;
        }
        SWFTreeBuilder.addLeaf(headerNode, "registerCount: " + defineFunction2.getRegisterCount());
        SWFTreeBuilder.addLeaf(headerNode, "suppressThis: " + defineFunction2.suppressesThis());
        SWFTreeBuilder.addLeaf(headerNode, "preloadThis: " + defineFunction2.preloadsThis());
        SWFTreeBuilder.addLeaf(headerNode, "suppressArguments: " + defineFunction2.suppressesArguments());
        SWFTreeBuilder.addLeaf(headerNode, "preloadArguments: " + defineFunction2.preloadsArguments());
        SWFTreeBuilder.addLeaf(headerNode, "suppressSuper: " + defineFunction2.suppressesSuper());
        SWFTreeBuilder.addLeaf(headerNode, "preloadSuper: " + defineFunction2.preloadsSuper());
        SWFTreeBuilder.addLeaf(headerNode, "preloadRoot: " + defineFunction2.preloadsRoot());
        SWFTreeBuilder.addLeaf(headerNode, "preloadParent: " + defineFunction2.preloadsParent());
        SWFTreeBuilder.addLeaf(headerNode, "preloadGlobal: " + defineFunction2.preloadsGlobal());
        SWFTreeBuilder.addNode(node, "body: ", defineFunction2.getBody());
    }

    private static void addNode(DefaultMutableTreeNode node, String var, ClipEventFlags clipEventFlags) {
        DefaultMutableTreeNode newNode = SWFTreeBuilder.addParentNode(node, var + "ClipEventFlags");
        SWFTreeBuilder.addLeaf(newNode, "keyUp: " + clipEventFlags.isKeyUp());
        SWFTreeBuilder.addLeaf(newNode, "keyDown: " + clipEventFlags.isKeyDown());
        SWFTreeBuilder.addLeaf(newNode, "mouseUp: " + clipEventFlags.isMouseUp());
        SWFTreeBuilder.addLeaf(newNode, "mouseDown: " + clipEventFlags.isMouseDown());
        SWFTreeBuilder.addLeaf(newNode, "mouseMove: " + clipEventFlags.isMouseMove());
        SWFTreeBuilder.addLeaf(newNode, "unload: " + clipEventFlags.isUnload());
        SWFTreeBuilder.addLeaf(newNode, "enterFrame: " + clipEventFlags.isEnterFrame());
        SWFTreeBuilder.addLeaf(newNode, "load: " + clipEventFlags.isLoad());
        SWFTreeBuilder.addLeaf(newNode, "dragOver: " + clipEventFlags.isDragOver());
        SWFTreeBuilder.addLeaf(newNode, "rollOut: " + clipEventFlags.isRollOut());
        SWFTreeBuilder.addLeaf(newNode, "rollOver: " + clipEventFlags.isRollOver());
        SWFTreeBuilder.addLeaf(newNode, "releaseOutside: " + clipEventFlags.isReleaseOutside());
        SWFTreeBuilder.addLeaf(newNode, "release: " + clipEventFlags.isRelease());
        SWFTreeBuilder.addLeaf(newNode, "press: " + clipEventFlags.isPress());
        SWFTreeBuilder.addLeaf(newNode, "initialize: " + clipEventFlags.isInitialize());
        SWFTreeBuilder.addLeaf(newNode, "data: " + clipEventFlags.isData());
        SWFTreeBuilder.addLeaf(newNode, "construct: " + clipEventFlags.isConstruct());
        SWFTreeBuilder.addLeaf(newNode, "keyPress: " + clipEventFlags.isKeyPress());
        SWFTreeBuilder.addLeaf(newNode, "dragOut: " + clipEventFlags.isDragOut());
    }

    private static void addNode(DefaultMutableTreeNode node, Protect tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatControlTag("Protect"));
        String password = tag.getPassword();
        if (password == null) {
            SWFTreeBuilder.addLeaf(tagNode, "No password");
        } else {
            SWFTreeBuilder.addLeaf(tagNode, "password: " + password);
        }
    }

    private static void addNode(DefaultMutableTreeNode node, RemoveObject tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatControlTag("RemoveObject"));
        SWFTreeBuilder.addLeaf(tagNode, "characterId: " + tag.getCharacterId());
        SWFTreeBuilder.addLeaf(tagNode, "depth: " + tag.getDepth());
    }

    private static void addNode(DefaultMutableTreeNode node, RemoveObject2 tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatControlTag("RemoveObject2"));
        SWFTreeBuilder.addLeaf(tagNode, "depth: " + tag.getDepth());
    }

    private static void addNode(DefaultMutableTreeNode node, ScriptLimits tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatControlTag("ScriptLimits"));
        SWFTreeBuilder.addLeaf(tagNode, "maxRecursionDepth: " + tag.getMaxRecursionDepth());
        SWFTreeBuilder.addLeaf(tagNode, "scriptTimeoutSeconds: " + tag.getScriptTimeoutSeconds());
    }

    private static void addNode(DefaultMutableTreeNode node, SetBackgroundColor tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatControlTag("SetBackgroundColor"));
        SWFTreeBuilder.addLeaf(tagNode, "color: " + tag.getColor());
    }

    private static void addNode(DefaultMutableTreeNode node, SetTabIndex tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatControlTag("SetTabIndex"));
        SWFTreeBuilder.addLeaf(tagNode, "depth: " + tag.getDepth());
        SWFTreeBuilder.addLeaf(tagNode, "tabIndex: " + tag.getTabIndex());
    }

    private static void addNode(DefaultMutableTreeNode node, ShowFrame tag) {
        SWFTreeBuilder.addLeaf(node, SWFTreeBuilder.formatControlTag("ShowFrame"));
    }

    private static void addNode(DefaultMutableTreeNode node, SoundStreamBlock tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatControlTag("SoundStreamBlock"));
        SWFTreeBuilder.addLeaf(tagNode, "streamSoundData: byte[" + tag.getStreamSoundData().length + "]");
    }

    private static void addNode(DefaultMutableTreeNode node, Scale9Grid tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatControlTag("Scale9Grid"));
        SWFTreeBuilder.addLeaf(tagNode, "characterId: " + tag.getCharacterId());
        SWFTreeBuilder.addLeaf(tagNode, "grid: " + tag.getGrid());
    }

    private static void addNode(DefaultMutableTreeNode node, SoundStreamHead tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatControlTag("SoundStreamHead"));
        byte rate = tag.getPlaybackRate();
        SWFTreeBuilder.addLeaf(tagNode, "playbackRate: " + SWFTreeBuilder.getSoundRateString(rate));
        String type = tag.isPlaybackStereo() ? "stereo" : "mono";
        SWFTreeBuilder.addLeaf(tagNode, "playbackType: " + type);
        byte format = tag.getStreamFormat();
        SWFTreeBuilder.addLeaf(tagNode, "streamFormat: " + SWFTreeBuilder.getSoundFormatString(format));
        rate = tag.getStreamRate();
        SWFTreeBuilder.addLeaf(tagNode, "streamRate: " + SWFTreeBuilder.getSoundRateString(rate));
        type = tag.isStreamStereo() ? "stereo" : "mono";
        SWFTreeBuilder.addLeaf(tagNode, "streamType: " + type);
        SWFTreeBuilder.addLeaf(tagNode, "streamSampleCount: " + tag.getStreamSampleCount());
        if (format == 2) {
            SWFTreeBuilder.addLeaf(tagNode, "latencySeek: " + tag.getLatencySeek());
        }
    }

    private static void addNode(DefaultMutableTreeNode node, SoundStreamHead2 tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatControlTag("SoundStreamHead2"));
        byte rate = tag.getPlaybackRate();
        SWFTreeBuilder.addLeaf(tagNode, "playbackRate: " + SWFTreeBuilder.getSoundRateString(rate));
        String size = tag.isPlayback16BitSample() ? "16 bit" : "8 bit";
        SWFTreeBuilder.addLeaf(tagNode, "playbackSize: " + size);
        String type = tag.isPlaybackStereo() ? "stereo" : "mono";
        SWFTreeBuilder.addLeaf(tagNode, "playbackType: " + type);
        byte format = tag.getStreamFormat();
        SWFTreeBuilder.addLeaf(tagNode, "streamFormat: " + SWFTreeBuilder.getSoundFormatString(format));
        rate = tag.getStreamRate();
        SWFTreeBuilder.addLeaf(tagNode, "streamRate: " + SWFTreeBuilder.getSoundRateString(rate));
        size = tag.isStream16BitSample() ? "16 bit" : "8 bit";
        SWFTreeBuilder.addLeaf(tagNode, "playbackSize: " + size);
        type = tag.isStreamStereo() ? "stereo" : "mono";
        SWFTreeBuilder.addLeaf(tagNode, "streamType: " + type);
        SWFTreeBuilder.addLeaf(tagNode, "streamSampleCount: " + tag.getStreamSampleCount());
        if (format == 2) {
            SWFTreeBuilder.addLeaf(tagNode, "latencySeek: " + tag.getLatencySeek());
        }
    }

    private static void addNode(DefaultMutableTreeNode node, StartSound tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatControlTag("StartSound"));
        SWFTreeBuilder.addLeaf(tagNode, "soundId: " + tag.getSoundId());
        SWFTreeBuilder.addNode(tagNode, "soundInfo: ", tag.getSoundInfo());
    }

    private static void addNode(DefaultMutableTreeNode node, String var, SoundInfo info) {
        DefaultMutableTreeNode siNode = SWFTreeBuilder.addParentNode(node, var + "SoundInfo");
        SWFTreeBuilder.addLeaf(siNode, "syncStop: " + info.isSyncStop());
        SWFTreeBuilder.addLeaf(siNode, "syncNoMultiple: " + info.isSyncNoMultiple());
        if (info.getInPoint() != 0L) {
            SWFTreeBuilder.addLeaf(siNode, "inPoint: " + info.getInPoint());
        }
        if (info.getOutPoint() != 0L) {
            SWFTreeBuilder.addLeaf(siNode, "outPoint: " + info.getOutPoint());
        }
        if (info.getLoopCount() != 0) {
            SWFTreeBuilder.addLeaf(siNode, "loopCount: " + info.getLoopCount());
        }
        if (info.getEnvelopeRecords() != null) {
            SoundEnvelope[] records = info.getEnvelopeRecords();
            DefaultMutableTreeNode envRecordsNode = SWFTreeBuilder.addParentNode(siNode, "envelopeRecords: SoundEnvelope[" + records.length + "]");
            int i = 0;
            while (i < records.length) {
                SoundEnvelope env = records[i];
                DefaultMutableTreeNode recNode = SWFTreeBuilder.addParentNode(envRecordsNode, "SoundEnvelope");
                SWFTreeBuilder.addLeaf(recNode, "pos44: " + env.getPos44());
                SWFTreeBuilder.addLeaf(recNode, "leftLevel: " + env.getLeftLevel());
                SWFTreeBuilder.addLeaf(recNode, "rightLevel: " + env.getRightLevel());
                ++i;
            }
        }
    }

    private static void addNode(DefaultMutableTreeNode node, UnknownTag tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatControlTag("Unknown tag (" + tag.getCode() + ")"));
        byte[] data = tag.getData();
        SWFTreeBuilder.addLeaf(tagNode, "size: " + data.length);
        SWFTreeBuilder.addLeaf(tagNode, "data: " + HexUtils.toHex(data));
    }

    private static void addNode(DefaultMutableTreeNode node, VideoFrame tag) {
        DefaultMutableTreeNode tagNode = SWFTreeBuilder.addParentNode(node, SWFTreeBuilder.formatControlTag("VideoFrame"));
        SWFTreeBuilder.addLeaf(tagNode, "streamId: " + tag.getStreamId());
        SWFTreeBuilder.addLeaf(tagNode, "frameNum: " + tag.getFrameNum());
        SWFTreeBuilder.addLeaf(tagNode, "videoData: " + tag.getVideoData().length + " bytes");
    }

    private static DefaultMutableTreeNode addParentNode(DefaultMutableTreeNode node, String string) {
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(string);
        node.insert(newNode, node.getChildCount());
        ++nodes;
        return newNode;
    }

    private static String formatControlTag(String tagName) {
        return "<html><font color=\"#0000B0\">" + tagName + "</font></html>";
    }

    private static String formatDefTag(String tagName) {
        return "<html><font color=\"#B00000\">" + tagName + "</font></html>";
    }

    SWFTreeBuilder() {
    }
}

