/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.investigator;

import java.awt.Frame;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dss.graph.flash.jswiff.investigator.Investigator;
import oracle.dss.graph.flash.jswiff.investigator.ProgressDialog;
import oracle.dss.graph.flash.jswiff.investigator.SWFTreeBuilder;
import oracle.dss.graph.flash.jswiff.listeners.SWFListener;
import oracle.dss.graph.flash.jswiff.swfrecords.SWFHeader;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.ActionBlock;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.Tag;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.TagConstants;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.TagHeader;

final class SWFTreeListener
extends SWFListener {
    private DefaultMutableTreeNode treeNode;
    private Frame parent;
    private ProgressDialog progressDialog;
    private int tagCount;
    private int malformedTagCount;
    private boolean isProtected;

    SWFTreeListener(DefaultMutableTreeNode treeNode, Frame parent) {
        this.treeNode = treeNode;
        this.parent = parent;
    }

    public void postProcess() {
        this.progressDialog.close();
        if (this.malformedTagCount != 0) {
            String message = this.malformedTagCount + " of " + this.tagCount + " parsed tags are malformed!";
            JOptionPane.showMessageDialog(this.parent, message, "Malformed tags", 2);
            ((Investigator)this.parent).find("Malformed tag");
        } else {
            ((Investigator)this.parent).expandRoot();
        }
    }

    public void preProcess() {
        ActionBlock.resetInstanceCounter();
    }

    public void processHeader(SWFHeader header) {
        this.progressDialog = new ProgressDialog(this.parent, "Parsing Flash file...", "Reading file header...", "", 0, (int)header.getFileLength(), false);
        SWFTreeBuilder.setNodes(0);
        SWFTreeBuilder.addNode(this.treeNode, header);
        this.progressDialog.setProgressValue(21);
        this.progressDialog.setNote("Done.");
    }

    public void processHeaderReadError(Exception e) {
        String message = "Malformed file header - parsing aborted.";
        System.out.println(message);
        JOptionPane.showMessageDialog(this.parent, message, "Read error", 0);
        e.printStackTrace();
    }

    public void processTag(Tag tag, long offset) {
        this.progressDialog.setMessage(this.tagCount++ + " tags read");
        SWFTreeBuilder.addNode(this.treeNode, tag);
        this.progressDialog.setProgressValue((int)offset);
        this.progressDialog.setNote(TagConstants.getTagName(tag.getCode()));
        if (tag.getCode() == 24) {
            this.isProtected = true;
        }
    }

    public void processTagHeaderReadError(Exception e) {
        String message = "Malformed tag header - parsing aborted.";
        System.err.println(message);
        JOptionPane.showMessageDialog(this.parent, message, "Read error", 0);
        e.printStackTrace();
    }

    public boolean processTagReadError(TagHeader tagHeader, byte[] tagData, Exception e) {
        ++this.malformedTagCount;
        e.printStackTrace();
        return false;
    }

    int getNodeNumber() {
        return SWFTreeBuilder.getNodes();
    }

    boolean isProtected() {
        return this.isProtected;
    }
}

