/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.io;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;

public final class InputBitStream {
    private InputStream stream;
    private int bitBuffer;
    private int bitCursor;
    private boolean compressed;
    private long offset;
    private boolean ansi;
    private boolean shiftJIS;

    private void $init$() {
        this.bitCursor = 8;
        this.compressed = false;
    }

    public InputBitStream(InputStream stream) {
        this.$init$();
        this.stream = stream;
        this.offset = 0L;
    }

    public InputBitStream(byte[] buffer) {
        this(new ByteArrayInputStream(buffer));
    }

    public void setANSI(boolean ansi) {
        this.ansi = ansi;
    }

    public boolean isANSI() {
        return this.ansi;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setShiftJIS(boolean shiftJIS) {
        this.shiftJIS = shiftJIS;
    }

    public boolean isShiftJIS() {
        return this.shiftJIS;
    }

    public void align() {
        this.bitCursor = 8;
    }

    public int available() throws IOException {
        if (this.compressed) {
            throw new IllegalStateException("Don't use available() on compressed streams!");
        }
        return this.stream.available();
    }

    public void close() throws IOException {
        this.stream.close();
    }

    public void enableCompression() {
        if (!this.compressed) {
            this.stream = new BufferedInputStream(new InflaterInputStream(this.stream));
        }
        this.compressed = true;
    }

    public void move(long delta) throws IOException {
        this.offset += delta;
        this.stream.reset();
        this.stream.skip(this.offset);
    }

    public boolean readBooleanBit() throws IOException {
        return this.readUnsignedBits(1) == 1L;
    }

    public byte[] readBytes(int length) throws IOException {
        byte[] result;
        if (length > 0) {
            result = new byte[length];
            int totalRead = 0;
            while (totalRead < length) {
                int read = this.stream.read(result, totalRead, length - totalRead);
                if (read < 0) {
                    this.endReached();
                    return null;
                }
                totalRead += read;
            }
        } else {
            return new byte[0];
        }
        this.offset += (long)length;
        this.align();
        return result;
    }

    public double readDouble() throws IOException {
        byte[] buffer = this.readBytes(8);
        long longBits = ((long)buffer[3] << 56) + ((long)(buffer[2] & 0xFF) << 48) + ((long)(buffer[1] & 0xFF) << 40) + ((long)(buffer[0] & 0xFF) << 32) + ((long)(buffer[7] & 0xFF) << 24) + (long)((buffer[6] & 0xFF) << 16) + (long)((buffer[5] & 0xFF) << 8) + (long)((buffer[4] & 0xFF) << 0);
        return Double.longBitsToDouble(longBits);
    }

    public double readFP16() throws IOException {
        short value = this.readSI16();
        return (double)value / 256.0;
    }

    public double readFP32() throws IOException {
        int value = this.readSI32();
        return (double)value / 65536.0;
    }

    public double readFPBits(int nBits) throws IOException {
        long longNumber = this.readSignedBits(nBits);
        return (double)longNumber / 65536.0;
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readSI32());
    }

    public float readFloat16() throws IOException {
        int bits16 = this.readUI16();
        int sign = (bits16 & 0x8000) >> 15;
        int exponent16 = (bits16 & 0x7C00) >> 10;
        int mantissa16 = bits16 & 0x3FF;
        int exponent32 = 0;
        if (exponent16 != 0) {
            exponent32 = exponent16 == 31 ? 255 : exponent16 - 15 + 127;
        }
        int mantissa32 = mantissa16 << 13;
        int bits32 = sign << 31;
        bits32 |= exponent32 << 23;
        return Float.intBitsToFloat(bits32 |= mantissa32);
    }

    public short readSI16() throws IOException {
        return (short)this.readUI16();
    }

    public int readSI32() throws IOException {
        return (int)this.readUI32();
    }

    public byte readSI8() throws IOException {
        return (byte)this.readUI8();
    }

    public long readSignedBits(int nBits) throws IOException {
        long result = this.readUnsignedBits(nBits);
        if ((result & 1L << nBits - 1) != 0L) {
            result |= (long)-1 << nBits;
        }
        return result;
    }

    public String readString() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.fillBitBuffer();
        while (this.bitBuffer != 0) {
            baos.write(this.bitBuffer);
            this.fillBitBuffer();
        }
        byte[] buffer = baos.toByteArray();
        String encoding = this.shiftJIS ? "SJIS" : (this.ansi ? "cp1252" : "UTF-8");
        return new String(buffer, encoding);
    }

    public int readUI16() throws IOException {
        this.fillBitBuffer();
        int result = this.bitBuffer;
        this.fillBitBuffer();
        this.align();
        return result |= this.bitBuffer << 8;
    }

    public long readUI32() throws IOException {
        this.fillBitBuffer();
        long result = this.bitBuffer;
        this.fillBitBuffer();
        result |= (long)(this.bitBuffer << 8);
        this.fillBitBuffer();
        result |= (long)(this.bitBuffer << 16);
        this.fillBitBuffer();
        this.align();
        return result |= (long)(this.bitBuffer << 24);
    }

    public short readUI8() throws IOException {
        this.fillBitBuffer();
        short result = (short)this.bitBuffer;
        this.align();
        return result;
    }

    public long readUnsignedBits(int nBits) throws IOException {
        if (nBits == 0) {
            return 0L;
        }
        int bitsLeft = nBits;
        long result = 0L;
        while (bitsLeft > 0) {
            if (this.bitCursor == 8) {
                this.fillBitBuffer();
            }
            if ((this.bitBuffer & 1 << 7 - this.bitCursor) != 0) {
                result |= 1L << bitsLeft - 1;
            }
            ++this.bitCursor;
            --bitsLeft;
        }
        return result;
    }

    private void endReached() throws IOException {
        throw new IOException("Input data stream ended unexpectedly!");
    }

    private void fillBitBuffer() throws IOException {
        this.bitBuffer = this.stream.read();
        ++this.offset;
        if (this.bitBuffer < 0) {
            this.endReached();
        }
        this.bitCursor = 0;
    }
}

