/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.io;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public final class OutputBitStream {
    private OutputStream stream;
    private ByteArrayOutputStream memoryStream;
    private int bitBuffer;
    private int bitCursor;
    private boolean compressed;
    private long offset;
    private boolean isMemoryStream;
    private boolean ansi;
    private boolean shiftJIS;

    private void $init$() {
        this.compressed = false;
    }

    public OutputBitStream(OutputStream stream) {
        this.$init$();
        this.stream = stream;
    }

    public OutputBitStream() {
        this.$init$();
        this.memoryStream = new ByteArrayOutputStream();
        this.stream = this.memoryStream;
        this.isMemoryStream = true;
    }

    public void setANSI(boolean ansi) {
        this.ansi = ansi;
    }

    public boolean isANSI() {
        return this.ansi;
    }

    public byte[] getData() {
        if (!this.isMemoryStream) {
            throw new IllegalStateException("Use this method only with memory streams!");
        }
        try {
            this.stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.memoryStream.toByteArray();
    }

    public static int getFPBitsLength(double value) {
        if (value == 0.0) {
            return 1;
        }
        long fpBits = (long)(value * 65536.0);
        return OutputBitStream.getSignedBitsLength(fpBits);
    }

    public long getOffset() {
        return this.offset;
    }

    public static int getSignedBitsLength(long value) {
        int nBits = value == 0L ? 0 : (int)(Math.floor(Math.log(Math.abs(value)) / Math.log(2.0)) + 2.0);
        return nBits;
    }

    public static int getUnsignedBitsLength(long value) {
        if (value < 1L) {
            return 0;
        }
        return (int)(Math.floor(Math.log(value) / Math.log(2.0)) + 1.0);
    }

    public void setShiftJIS(boolean shiftJIS) {
        this.shiftJIS = shiftJIS;
    }

    public boolean isShiftJIS() {
        return this.shiftJIS;
    }

    public void align() throws IOException {
        if (this.bitCursor > 0) {
            this.stream.write(this.bitBuffer);
            ++this.offset;
            this.bitCursor = 0;
            this.bitBuffer = 0;
        }
    }

    public void close() throws IOException {
        this.align();
        this.stream.close();
    }

    public void enableCompression() {
        if (!this.compressed) {
            this.stream = new BufferedOutputStream(new DeflaterOutputStream(this.stream, new Deflater(9)));
            this.compressed = true;
        }
    }

    public void flush() throws IOException {
        this.stream.flush();
    }

    public void writeBooleanBit(boolean value) throws IOException {
        this.writeUnsignedBits(value ? 1 : 0, 1);
    }

    public void writeBytes(byte[] buffer) throws IOException {
        this.align();
        if (buffer == null) {
            return;
        }
        this.stream.write(buffer);
        this.offset += (long)buffer.length;
    }

    public void writeDouble(double value) throws IOException {
        long longBits = Double.doubleToLongBits(value);
        byte[] buffer = new byte[]{(byte)(longBits >> 32), (byte)(longBits >> 40), (byte)(longBits >> 48), (byte)(longBits >> 56), (byte)longBits, (byte)(longBits >> 8), (byte)(longBits >> 16), (byte)(longBits >> 24)};
        this.writeBytes(buffer);
    }

    public void writeFP16(double value) throws IOException {
        this.writeSI16((short)(value * 256.0));
    }

    public void writeFP32(double value) throws IOException {
        this.writeSI32((int)(value * 65536.0));
    }

    public void writeFPBits(double value, int nBits) throws IOException {
        long fpBits = (long)(value * 65536.0);
        this.writeSignedBits(fpBits, nBits);
    }

    public void writeFloat(float value) throws IOException {
        this.writeSI32(Float.floatToIntBits(value));
    }

    public void writeFloat16(float value) throws IOException {
        int bits32 = Float.floatToIntBits(value);
        int sign = Math.abs((bits32 & Integer.MIN_VALUE) >> 31);
        int exponent32 = (bits32 & 0x7F800000) >> 23;
        int mantissa32 = bits32 & 0x7FFFFF;
        int exponent16 = 0;
        if (exponent32 != 0) {
            exponent16 = exponent32 == 255 ? 31 : exponent32 - 127 + 15;
        }
        int mantissa16 = 0;
        if (exponent16 < 0) {
            exponent16 = 0;
        } else if (exponent16 > 31) {
            exponent16 = 31;
        } else {
            mantissa16 = mantissa32 >> 13;
        }
        int bits16 = sign << 15;
        bits16 |= exponent16 << 10;
        this.writeUI16(bits16 |= mantissa16);
    }

    public void writeSI16(short value) throws IOException {
        this.align();
        this.stream.write(value & 0xFF);
        this.stream.write(value >> 8);
        this.offset += (long)2;
    }

    public void writeSI32(int value) throws IOException {
        this.align();
        this.stream.write(value & 0xFF);
        this.stream.write(value >> 8);
        this.stream.write(value >> 16);
        this.stream.write(value >> 24);
        this.offset += (long)4;
    }

    public void writeSI8(byte value) throws IOException {
        this.align();
        this.stream.write(value);
        ++this.offset;
    }

    public void writeSignedBits(long value, int nBits) throws IOException {
        int bitsNeeded = OutputBitStream.getSignedBitsLength(value);
        if (nBits < bitsNeeded) {
            throw new IOException("At least " + bitsNeeded + " bits needed for representation of " + value);
        }
        this.writeInteger(value, nBits);
    }

    public void writeString(String string) throws IOException {
        String encoding = this.shiftJIS ? "SJIS" : (this.ansi ? "cp1252" : "UTF-8");
        this.writeBytes(string.getBytes(encoding));
        this.stream.write(0);
        ++this.offset;
    }

    public void writeUI16(int value) throws IOException {
        this.align();
        this.stream.write(value & 0xFF);
        this.stream.write(value >> 8);
        this.offset += (long)2;
    }

    public void writeUI32(long value) throws IOException {
        this.align();
        this.stream.write((int)(value & 0xFFL));
        this.stream.write((int)(value >> 8));
        this.stream.write((int)(value >> 16));
        this.stream.write((int)(value >> 24));
        this.offset += (long)4;
    }

    public void writeUI8(short value) throws IOException {
        this.align();
        this.stream.write(value);
        ++this.offset;
    }

    public void writeUnsignedBits(long value, int nBits) throws IOException {
        int bitsNeeded = OutputBitStream.getUnsignedBitsLength(value);
        if (nBits < bitsNeeded) {
            throw new IOException("At least " + bitsNeeded + " bits needed for representation of " + value + ". Used bits: " + nBits);
        }
        this.writeInteger(value, nBits);
    }

    private void writeInteger(long value, int nBits) throws IOException {
        int bitsLeft = nBits;
        while (bitsLeft > 0) {
            ++this.bitCursor;
            if ((1L << bitsLeft - 1 & value) != 0L) {
                this.bitBuffer |= 1 << 8 - this.bitCursor;
            }
            if (this.bitCursor == 8) {
                this.stream.write(this.bitBuffer);
                ++this.offset;
                this.bitCursor = 0;
                this.bitBuffer = 0;
            }
            --bitsLeft;
        }
    }
}

