/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords;

import java.io.IOException;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.RGBA;
import oracle.dss.graph.flash.jswiff.swfrecords.ZlibBitmapData;

public final class AlphaColorMapData
extends ZlibBitmapData {
    private RGBA[] colorTableRGBA;
    private short[] colorMapPixelData;

    public AlphaColorMapData(RGBA[] colorTableRGBA, short[] colorMapPixelData) {
        this.colorTableRGBA = colorTableRGBA;
        this.colorMapPixelData = colorMapPixelData;
    }

    public AlphaColorMapData(InputBitStream stream, short colorTableSize, int width, int height) throws IOException {
        this.colorTableRGBA = new RGBA[colorTableSize];
        int i = 0;
        while (i < colorTableSize) {
            this.colorTableRGBA[i] = new RGBA(stream);
            ++i;
        }
        int imageDataSize = (width + AlphaColorMapData.getScanlinePadLength(width)) * height;
        this.colorMapPixelData = new short[imageDataSize];
        int i2 = 0;
        while (i2 < imageDataSize) {
            this.colorMapPixelData[i2] = stream.readUI8();
            ++i2;
        }
    }

    public static int getScanlinePadLength(int width) {
        int pad = 0;
        if ((width & 3) != 0) {
            pad = 4 - (width & 3);
        }
        return pad;
    }

    public short[] getColorMapPixelData() {
        return this.colorMapPixelData;
    }

    public RGBA[] getColorTableRGBA() {
        return this.colorTableRGBA;
    }

    public void write(OutputBitStream stream) throws IOException {
        int i = 0;
        while (i < this.colorTableRGBA.length) {
            this.colorTableRGBA[i].write(stream);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.colorMapPixelData.length) {
            stream.writeUI8(this.colorMapPixelData[i2]);
            ++i2;
        }
    }
}

