/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords;

import java.io.IOException;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.Filter;
import oracle.dss.graph.flash.jswiff.swfrecords.RGBA;

public final class BevelFilter
extends Filter {
    private RGBA highlightColor;
    private RGBA shadowColor;
    private double x;
    private double y;
    private double angle;
    private double distance;
    private double strength;
    private boolean inner;
    private int quality;
    private boolean knockout;
    private boolean onTop;

    public BevelFilter() {
        this.initDefaults();
    }

    public BevelFilter(InputBitStream stream) throws IOException {
        this.highlightColor = new RGBA(stream);
        this.shadowColor = new RGBA(stream);
        this.x = stream.readFP32();
        this.y = stream.readFP32();
        this.angle = stream.readFP32();
        this.distance = stream.readFP32();
        this.strength = stream.readFP16();
        this.inner = stream.readBooleanBit();
        this.knockout = stream.readBooleanBit();
        stream.readBooleanBit();
        this.onTop = stream.readBooleanBit();
        this.quality = (int)stream.readUnsignedBits(4);
    }

    public void setAngle(double angle) {
        this.angle = angle;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public double getDistance() {
        return this.distance;
    }

    public void setHighlightColor(RGBA color) {
        this.highlightColor = color;
    }

    public RGBA getHighlightColor() {
        return this.highlightColor;
    }

    public void setInner(boolean inner) {
        this.inner = inner;
    }

    public boolean isInner() {
        return this.inner;
    }

    public void setKnockout(boolean knockout) {
        this.knockout = knockout;
    }

    public boolean isKnockout() {
        return this.knockout;
    }

    public void setOnTop(boolean onTop) {
        this.onTop = onTop;
    }

    public boolean isOnTop() {
        return this.onTop;
    }

    public void setQuality(int quality) {
        this.quality = quality;
    }

    public int getQuality() {
        return this.quality;
    }

    public void setShadowColor(RGBA color) {
        this.shadowColor = color;
    }

    public RGBA getShadowColor() {
        return this.shadowColor;
    }

    public void setStrength(double strength) {
        this.strength = strength;
    }

    public double getStrength() {
        return this.strength;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getX() {
        return this.x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getY() {
        return this.y;
    }

    public void write(OutputBitStream stream) throws IOException {
        this.highlightColor.write(stream);
        this.shadowColor.write(stream);
        stream.writeFP32(this.x);
        stream.writeFP32(this.y);
        stream.writeFP32(this.angle);
        stream.writeFP32(this.distance);
        stream.writeFP16(this.strength);
        stream.writeBooleanBit(this.inner);
        stream.writeBooleanBit(this.knockout);
        stream.writeBooleanBit(true);
        stream.writeBooleanBit(this.onTop);
        stream.writeUnsignedBits(this.quality, 4);
    }

    private void initDefaults() {
        this.highlightColor = RGBA.WHITE;
        this.shadowColor = RGBA.BLACK;
        this.x = 4.0;
        this.y = 4.0;
        this.angle = 0.7853981633974483;
        this.distance = 4.0;
        this.strength = 1.0;
        this.quality = 1;
        this.inner = true;
    }
}

