/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords;

import java.io.IOException;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.BitmapPixelData;
import oracle.dss.graph.flash.jswiff.swfrecords.Pix15;
import oracle.dss.graph.flash.jswiff.swfrecords.Pix24;
import oracle.dss.graph.flash.jswiff.swfrecords.ZlibBitmapData;

public final class BitmapData
extends ZlibBitmapData {
    private BitmapPixelData[] bitmapPixelData;

    public BitmapData(BitmapPixelData[] bitmapPixelData) {
        this.bitmapPixelData = bitmapPixelData;
    }

    public BitmapData(InputBitStream stream, short bitmapFormat, int width, int height) throws IOException {
        int imageDataSize = 0;
        switch (bitmapFormat) {
            case 4: {
                imageDataSize = (width + BitmapData.getScanlinePadLength(width)) * height;
                this.bitmapPixelData = new Pix15[imageDataSize];
                int i = 0;
                while (i < imageDataSize) {
                    this.bitmapPixelData[i] = new Pix15(stream);
                    ++i;
                }
                break;
            }
            case 5: {
                imageDataSize = width * height;
                this.bitmapPixelData = new Pix24[imageDataSize];
                int i = 0;
                while (i < imageDataSize) {
                    this.bitmapPixelData[i] = new Pix24(stream);
                    ++i;
                }
                break;
            }
        }
    }

    public static int getScanlinePadLength(int width) {
        return width & 1;
    }

    public BitmapPixelData[] getBitmapPixelData() {
        return this.bitmapPixelData;
    }

    public void write(OutputBitStream stream) throws IOException {
        int i = 0;
        while (i < this.bitmapPixelData.length) {
            this.bitmapPixelData[i].write(stream);
            ++i;
        }
    }
}

