/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords;

import java.io.IOException;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.Filter;

public final class BlurFilter
extends Filter {
    private double x;
    private double y;
    private int quality;

    public BlurFilter(double x, double y) {
        this.x = x;
        this.y = y;
        this.quality = 1;
    }

    public BlurFilter(InputBitStream stream) throws IOException {
        this.x = stream.readFP32();
        this.y = stream.readFP32();
        this.quality = (int)stream.readUnsignedBits(5);
        stream.align();
    }

    public void write(OutputBitStream stream) throws IOException {
        stream.writeFP32(this.x);
        stream.writeFP32(this.y);
        stream.writeUnsignedBits(this.quality, 5);
        stream.writeUnsignedBits(0L, 3);
    }

    public void setQuality(int quality) {
        if (quality < 0 || quality > 15) {
            throw new IllegalArgumentException("quality must be between 0 and 15");
        }
        this.quality = quality;
    }

    public int getQuality() {
        return this.quality;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getX() {
        return this.x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getY() {
        return this.y;
    }
}

