/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.CXformWithAlpha;
import oracle.dss.graph.flash.jswiff.swfrecords.Filter;
import oracle.dss.graph.flash.jswiff.swfrecords.Matrix;

public final class ButtonRecord
implements Serializable {
    private boolean hitState;
    private boolean downState;
    private boolean overState;
    private boolean upState;
    private int characterId;
    private int placeDepth;
    private Matrix placeMatrix;
    private CXformWithAlpha colorTransform;
    private boolean hasBlendMode;
    private boolean hasFilters;
    private List filters;
    private short blendMode;

    public ButtonRecord(int characterId, int placeDepth, Matrix placeMatrix, boolean upState, boolean overState, boolean downState, boolean hitState) {
        if (!(upState || overState || downState || hitState)) {
            throw new IllegalArgumentException("At least one of the button state flags must be set!");
        }
        this.characterId = characterId;
        this.placeDepth = placeDepth;
        this.placeMatrix = placeMatrix;
        this.upState = upState;
        this.overState = overState;
        this.downState = downState;
        this.hitState = hitState;
    }

    public ButtonRecord(InputBitStream stream, boolean hasColorTransform) throws IOException {
        stream.readUnsignedBits(2);
        this.hasBlendMode = stream.readBooleanBit();
        this.hasFilters = stream.readBooleanBit();
        this.hitState = stream.readBooleanBit();
        this.downState = stream.readBooleanBit();
        this.overState = stream.readBooleanBit();
        this.upState = stream.readBooleanBit();
        this.characterId = stream.readUI16();
        this.placeDepth = stream.readUI16();
        this.placeMatrix = new Matrix(stream);
        if (hasColorTransform) {
            this.colorTransform = new CXformWithAlpha(stream);
        }
        if (this.hasFilters) {
            this.filters = Filter.readFilters(stream);
        }
        if (this.hasBlendMode) {
            this.blendMode = stream.readUI8();
            if (this.blendMode == 0) {
                this.blendMode = 1;
            }
        }
    }

    public void setBlendMode(short blendMode) {
        this.blendMode = blendMode;
        this.hasBlendMode = true;
    }

    public short getBlendMode() {
        return this.blendMode;
    }

    public int getCharacterId() {
        return this.characterId;
    }

    public void setColorTransform(CXformWithAlpha colorTransform) {
        this.colorTransform = colorTransform;
    }

    public CXformWithAlpha getColorTransform() {
        return this.colorTransform;
    }

    public boolean isDownState() {
        return this.downState;
    }

    public void setFilters(List filters) {
        this.filters = filters;
        this.hasFilters = filters != null;
    }

    public List getFilters() {
        return this.filters;
    }

    public boolean isHitState() {
        return this.hitState;
    }

    public boolean isOverState() {
        return this.overState;
    }

    public int getPlaceDepth() {
        return this.placeDepth;
    }

    public Matrix getPlaceMatrix() {
        return this.placeMatrix;
    }

    public boolean isUpState() {
        return this.upState;
    }

    public boolean hasBlendMode() {
        return this.hasBlendMode;
    }

    public boolean hasFilters() {
        return this.hasFilters;
    }

    public void write(OutputBitStream stream, boolean hasColorTransform) throws IOException {
        stream.writeUnsignedBits(0L, 2);
        stream.writeBooleanBit(this.hasBlendMode);
        stream.writeBooleanBit(this.hasFilters);
        stream.writeBooleanBit(this.hitState);
        stream.writeBooleanBit(this.downState);
        stream.writeBooleanBit(this.overState);
        stream.writeBooleanBit(this.upState);
        stream.writeUI16(this.characterId);
        stream.writeUI16(this.placeDepth);
        this.placeMatrix.write(stream);
        if (hasColorTransform) {
            if (this.colorTransform != null) {
                this.colorTransform.write(stream);
            } else {
                new CXformWithAlpha().write(stream);
            }
        }
        if (this.hasFilters) {
            Filter.writeFilters(this.filters, stream);
        }
        if (this.hasBlendMode) {
            stream.writeUI8(this.blendMode);
        }
    }
}

