/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords;

import java.io.IOException;
import java.io.Serializable;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;

public final class CXformWithAlpha
implements Serializable {
    private int redMultTerm;
    private int greenMultTerm;
    private int blueMultTerm;
    private int alphaMultTerm;
    private int redAddTerm;
    private int greenAddTerm;
    private int blueAddTerm;
    private int alphaAddTerm;
    private boolean hasMultTerms;
    private boolean hasAddTerms;

    private void $init$() {
        this.redMultTerm = 256;
        this.greenMultTerm = 256;
        this.blueMultTerm = 256;
        this.alphaMultTerm = 256;
        this.redAddTerm = 0;
        this.greenAddTerm = 0;
        this.blueAddTerm = 0;
        this.alphaAddTerm = 0;
    }

    public CXformWithAlpha() {
        this.$init$();
    }

    public CXformWithAlpha(InputBitStream stream) throws IOException {
        this.$init$();
        this.hasAddTerms = stream.readBooleanBit();
        this.hasMultTerms = stream.readBooleanBit();
        int nBits = (int)stream.readUnsignedBits(4);
        if (this.hasMultTerms) {
            this.redMultTerm = (int)stream.readSignedBits(nBits);
            this.greenMultTerm = (int)stream.readSignedBits(nBits);
            this.blueMultTerm = (int)stream.readSignedBits(nBits);
            this.alphaMultTerm = (int)stream.readSignedBits(nBits);
        }
        if (this.hasAddTerms) {
            this.redAddTerm = (int)stream.readSignedBits(nBits);
            this.greenAddTerm = (int)stream.readSignedBits(nBits);
            this.blueAddTerm = (int)stream.readSignedBits(nBits);
            this.alphaAddTerm = (int)stream.readSignedBits(nBits);
        }
        stream.align();
    }

    public void setAddTerms(int redAddTerm, int greenAddTerm, int blueAddTerm, int alphaAddTerm) {
        this.redAddTerm = redAddTerm;
        this.greenAddTerm = greenAddTerm;
        this.blueAddTerm = blueAddTerm;
        this.alphaAddTerm = alphaAddTerm;
        this.hasAddTerms = true;
    }

    public int getAlphaAddTerm() {
        return this.alphaAddTerm;
    }

    public int getAlphaMultTerm() {
        return this.alphaMultTerm;
    }

    public int getBlueAddTerm() {
        return this.blueAddTerm;
    }

    public int getBlueMultTerm() {
        return this.blueMultTerm;
    }

    public int getGreenAddTerm() {
        return this.greenAddTerm;
    }

    public int getGreenMultTerm() {
        return this.greenMultTerm;
    }

    public void setMultTerms(int redMultTerm, int greenMultTerm, int blueMultTerm, int alphaMultTerm) {
        this.redMultTerm = redMultTerm;
        this.greenMultTerm = greenMultTerm;
        this.blueMultTerm = blueMultTerm;
        this.alphaMultTerm = alphaMultTerm;
        this.hasMultTerms = true;
    }

    public int getRedAddTerm() {
        return this.redAddTerm;
    }

    public int getRedMultTerm() {
        return this.redMultTerm;
    }

    public boolean hasAddTerms() {
        return this.hasAddTerms;
    }

    public boolean hasMultTerms() {
        return this.hasMultTerms;
    }

    public void write(OutputBitStream stream) throws IOException {
        stream.writeBooleanBit(this.hasAddTerms);
        stream.writeBooleanBit(this.hasMultTerms);
        int nBits = 0;
        if (this.hasAddTerms) {
            nBits = Math.max(nBits, OutputBitStream.getSignedBitsLength(this.redAddTerm));
            nBits = Math.max(nBits, OutputBitStream.getSignedBitsLength(this.greenAddTerm));
            nBits = Math.max(nBits, OutputBitStream.getSignedBitsLength(this.blueAddTerm));
            nBits = Math.max(nBits, OutputBitStream.getSignedBitsLength(this.alphaAddTerm));
        }
        if (this.hasMultTerms) {
            nBits = Math.max(nBits, OutputBitStream.getSignedBitsLength(this.redMultTerm));
            nBits = Math.max(nBits, OutputBitStream.getSignedBitsLength(this.greenMultTerm));
            nBits = Math.max(nBits, OutputBitStream.getSignedBitsLength(this.blueMultTerm));
            nBits = Math.max(nBits, OutputBitStream.getSignedBitsLength(this.alphaMultTerm));
        }
        stream.writeUnsignedBits(nBits, 4);
        if (this.hasMultTerms) {
            stream.writeSignedBits(this.redMultTerm, nBits);
            stream.writeSignedBits(this.greenMultTerm, nBits);
            stream.writeSignedBits(this.blueMultTerm, nBits);
            stream.writeSignedBits(this.alphaMultTerm, nBits);
        }
        if (this.hasAddTerms) {
            stream.writeSignedBits(this.redAddTerm, nBits);
            stream.writeSignedBits(this.greenAddTerm, nBits);
            stream.writeSignedBits(this.blueAddTerm, nBits);
            stream.writeSignedBits(this.alphaAddTerm, nBits);
        }
        stream.align();
    }
}

