/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords;

import java.io.IOException;
import java.io.Serializable;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.ClipEventFlags;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.ActionBlock;

public final class ClipActionRecord
implements Serializable {
    private ClipEventFlags eventFlags;
    private short keyCode;
    private ActionBlock actions;

    public ClipActionRecord(ClipEventFlags eventFlags) {
        this.eventFlags = eventFlags;
        this.actions = new ActionBlock();
    }

    public ClipActionRecord(InputBitStream stream, short swfVersion) throws IOException {
        this.eventFlags = new ClipEventFlags(stream, swfVersion);
        int actionRecordSize = (int)stream.readUI32();
        if (swfVersion >= 6 && this.eventFlags.isKeyPress()) {
            this.keyCode = stream.readUI8();
            --actionRecordSize;
        }
        InputBitStream actionStream = new InputBitStream(stream.readBytes(actionRecordSize));
        actionStream.setANSI(stream.isANSI());
        actionStream.setShiftJIS(stream.isShiftJIS());
        this.actions = new ActionBlock(actionStream);
    }

    public ActionBlock getActions() {
        return this.actions;
    }

    public ClipEventFlags getEventFlags() {
        return this.eventFlags;
    }

    public void setKeyCode(short keyCode) {
        this.keyCode = keyCode;
    }

    public short getKeyCode() {
        return this.keyCode;
    }

    public void write(OutputBitStream stream, short swfVersion) throws IOException {
        this.eventFlags.write(stream, swfVersion);
        OutputBitStream actionStream = new OutputBitStream();
        actionStream.setANSI(stream.isANSI());
        actionStream.setShiftJIS(stream.isShiftJIS());
        this.actions.write(actionStream, true);
        byte[] actionBuffer = actionStream.getData();
        int actionRecordSize = actionBuffer.length;
        if (this.eventFlags.isKeyPress()) {
            ++actionRecordSize;
        }
        stream.writeUI32(actionRecordSize);
        if (this.eventFlags.isKeyPress()) {
            stream.writeUI8(this.keyCode);
        }
        stream.writeBytes(actionBuffer);
    }
}

