/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords;

import java.io.IOException;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.RGB;
import oracle.dss.graph.flash.jswiff.swfrecords.ZlibBitmapData;

public final class ColorMapData
extends ZlibBitmapData {
    private RGB[] colorTableRGB;
    private short[] colorMapPixelData;

    public ColorMapData(RGB[] colorTableRGB, short[] colorMapPixelData) {
        this.colorTableRGB = colorTableRGB;
        this.colorMapPixelData = colorMapPixelData;
    }

    public ColorMapData(InputBitStream stream, short colorTableSize, int width, int height) throws IOException {
        this.colorTableRGB = new RGB[colorTableSize];
        int i = 0;
        while (i < colorTableSize) {
            this.colorTableRGB[i] = new RGB(stream);
            ++i;
        }
        int imageDataSize = (width + ColorMapData.getScanlinePadLength(width)) * height;
        this.colorMapPixelData = new short[imageDataSize];
        int i2 = 0;
        while (i2 < imageDataSize) {
            this.colorMapPixelData[i2] = stream.readUI8();
            ++i2;
        }
    }

    public static int getScanlinePadLength(int width) {
        int pad = 0;
        if ((width & 3) != 0) {
            pad = 4 - (width & 3);
        }
        return pad;
    }

    public short[] getColorMapPixelData() {
        return this.colorMapPixelData;
    }

    public RGB[] getColorTableRGB() {
        return this.colorTableRGB;
    }

    public void write(OutputBitStream stream) throws IOException {
        int i = 0;
        while (i < this.colorTableRGB.length) {
            this.colorTableRGB[i].write(stream);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.colorMapPixelData.length) {
            stream.writeUI8(this.colorMapPixelData[i2]);
            ++i2;
        }
    }
}

