/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords;

import java.io.IOException;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.Filter;

public final class ColorMatrixFilter
extends Filter {
    private float[] matrix;

    public ColorMatrixFilter(float[] matrix) {
        if (matrix.length != 20) {
            throw new IllegalArgumentException("matrix array length must be 20!");
        }
        this.matrix = matrix;
    }

    public ColorMatrixFilter(InputBitStream stream) throws IOException {
        this.matrix = new float[20];
        int i = 0;
        while (i < 20) {
            this.matrix[i] = stream.readFloat();
            ++i;
        }
    }

    public void setMatrix(float[] matrix) {
        this.matrix = matrix;
    }

    public float[] getMatrix() {
        return this.matrix;
    }

    public void write(OutputBitStream stream) throws IOException {
        int i = 0;
        while (i < this.matrix.length) {
            stream.writeFloat(this.matrix[i]);
            ++i;
        }
    }
}

