/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords;

import java.io.IOException;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.Filter;
import oracle.dss.graph.flash.jswiff.swfrecords.RGBA;

public final class ConvolutionFilter
extends Filter {
    private int matrixRows;
    private float[] matrix;
    private RGBA color;
    private float divisor;
    private float bias;
    private boolean clamp;
    private boolean preserveAlpha;

    public ConvolutionFilter(float[] matrix, int matrixRows) {
        this.setMatrix(matrix, matrixRows);
        this.initDefaults();
    }

    public ConvolutionFilter(InputBitStream stream) throws IOException {
        short matrixColumns = stream.readUI8();
        this.matrixRows = stream.readUI8();
        this.divisor = stream.readFloat();
        this.bias = stream.readFloat();
        int matrixSize = matrixColumns * this.matrixRows;
        this.matrix = new float[matrixSize];
        int i = 0;
        while (i < matrixSize) {
            this.matrix[i] = stream.readFloat();
            ++i;
        }
        this.color = new RGBA(stream);
        stream.readUnsignedBits(6);
        this.clamp = stream.readBooleanBit();
        this.preserveAlpha = stream.readBooleanBit();
    }

    public void write(OutputBitStream stream) throws IOException {
        int matrixSize = this.matrix.length;
        int matrixColumns = matrixSize / this.matrixRows;
        stream.writeUI8((short)matrixColumns);
        stream.writeUI8((short)this.matrixRows);
        stream.writeFloat(this.divisor);
        stream.writeFloat(this.bias);
        int i = 0;
        while (i < matrixSize) {
            stream.writeFloat(this.matrix[i]);
            ++i;
        }
        this.color.write(stream);
        stream.writeUnsignedBits(0L, 6);
        stream.writeBooleanBit(this.clamp);
        stream.writeBooleanBit(this.preserveAlpha);
    }

    public void setBias(float bias) {
        this.bias = bias;
    }

    public float getBias() {
        return this.bias;
    }

    public void setClamp(boolean clamp) {
        this.clamp = clamp;
    }

    public boolean isClamp() {
        return this.clamp;
    }

    public void setColor(RGBA color) {
        this.color = color;
    }

    public RGBA getColor() {
        return this.color;
    }

    public void setDivisor(float divisor) {
        this.divisor = divisor;
    }

    public float getDivisor() {
        return this.divisor;
    }

    public void setMatrix(float[] matrix, int matrixRows) {
        if (matrix.length % matrixRows != 0) {
            throw new IllegalArgumentException("matrix array length must be a multiple of the matrix width!");
        }
        this.matrix = matrix;
        this.matrixRows = matrixRows;
    }

    public float[] getMatrix() {
        return this.matrix;
    }

    public int getMatrixRows() {
        return this.matrixRows;
    }

    public void setPreserveAlpha(boolean preserveAlpha) {
        this.preserveAlpha = preserveAlpha;
    }

    public boolean isPreserveAlpha() {
        return this.preserveAlpha;
    }

    private void initDefaults() {
        this.color = RGBA.BLACK;
        this.divisor = 1.0f;
        this.preserveAlpha = true;
        this.clamp = true;
    }
}

