/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords;

import java.io.IOException;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.EdgeRecord;

public final class CurvedEdgeRecord
extends EdgeRecord {
    private int controlDeltaX;
    private int controlDeltaY;
    private int anchorDeltaX;
    private int anchorDeltaY;

    public CurvedEdgeRecord(int controlDeltaX, int controlDeltaY, int anchorDeltaX, int anchorDeltaY) {
        this.controlDeltaX = controlDeltaX;
        this.controlDeltaY = controlDeltaY;
        this.anchorDeltaX = anchorDeltaX;
        this.anchorDeltaY = anchorDeltaY;
    }

    public CurvedEdgeRecord(InputBitStream stream) throws IOException {
        int numBits = (int)stream.readUnsignedBits(4) + 2;
        this.controlDeltaX = (int)stream.readSignedBits(numBits);
        this.controlDeltaY = (int)stream.readSignedBits(numBits);
        this.anchorDeltaX = (int)stream.readSignedBits(numBits);
        this.anchorDeltaY = (int)stream.readSignedBits(numBits);
    }

    public int getAnchorDeltaX() {
        return this.anchorDeltaX;
    }

    public int getAnchorDeltaY() {
        return this.anchorDeltaY;
    }

    public int getControlDeltaX() {
        return this.controlDeltaX;
    }

    public int getControlDeltaY() {
        return this.controlDeltaY;
    }

    public void write(OutputBitStream stream) throws IOException {
        stream.writeUnsignedBits(1L, 1);
        stream.writeUnsignedBits(0L, 1);
        int numBits = 2;
        numBits = Math.max(numBits, OutputBitStream.getSignedBitsLength(this.controlDeltaX));
        numBits = Math.max(numBits, OutputBitStream.getSignedBitsLength(this.controlDeltaY));
        numBits = Math.max(numBits, OutputBitStream.getSignedBitsLength(this.anchorDeltaX));
        numBits = Math.max(numBits, OutputBitStream.getSignedBitsLength(this.anchorDeltaY));
        stream.writeUnsignedBits(numBits - 2, 4);
        stream.writeSignedBits(this.controlDeltaX, numBits);
        stream.writeSignedBits(this.controlDeltaY, numBits);
        stream.writeSignedBits(this.anchorDeltaX, numBits);
        stream.writeSignedBits(this.anchorDeltaY, numBits);
    }
}

