/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords;

import java.io.IOException;
import java.io.Serializable;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.Color;
import oracle.dss.graph.flash.jswiff.swfrecords.FocalGradient;
import oracle.dss.graph.flash.jswiff.swfrecords.Gradient;
import oracle.dss.graph.flash.jswiff.swfrecords.Matrix;
import oracle.dss.graph.flash.jswiff.swfrecords.RGB;
import oracle.dss.graph.flash.jswiff.swfrecords.RGBA;

public final class FillStyle
implements Serializable {
    public static final short TYPE_SOLID = 0;
    public static final short TYPE_LINEAR_GRADIENT = 16;
    public static final short TYPE_RADIAL_GRADIENT = 18;
    public static final short TYPE_FOCAL_RADIAL_GRADIENT = 19;
    public static final short TYPE_TILED_BITMAP = 64;
    public static final short TYPE_CLIPPED_BITMAP = 65;
    public static final short TYPE_NONSMOOTHED_TILED_BITMAP = 66;
    public static final short TYPE_NONSMOOTHED_CLIPPED_BITMAP = 67;
    private short type;
    private Color color;
    private Matrix gradientMatrix;
    private Gradient gradient;
    private int bitmapId;
    private Matrix bitmapMatrix;

    public FillStyle(Gradient gradient, Matrix gradientMatrix, short type) {
        if (type != 16 && type != 18 && type != 19) {
            throw new IllegalArgumentException("Illegal gradient type!");
        }
        this.type = type;
        this.gradient = gradient;
        this.gradientMatrix = gradientMatrix;
    }

    public FillStyle(Color color) {
        this.color = color;
        this.type = 0;
    }

    public FillStyle(int bitmapId, Matrix bitmapMatrix, short type) {
        if (type != 64 && type != 65 && type != 66 && type != 67) {
            throw new IllegalArgumentException("Illegal bitmap type");
        }
        this.bitmapId = bitmapId;
        this.bitmapMatrix = bitmapMatrix;
        this.type = type;
    }

    FillStyle(InputBitStream stream, boolean hasAlpha) throws IOException {
        this.type = stream.readUI8();
        switch (this.type) {
            case 0: {
                if (hasAlpha) {
                    this.color = new RGBA(stream);
                    break;
                }
                this.color = new RGB(stream);
                break;
            }
            case 16: 
            case 18: {
                this.gradientMatrix = new Matrix(stream);
                this.gradient = new Gradient(stream, hasAlpha);
                break;
            }
            case 19: {
                this.gradientMatrix = new Matrix(stream);
                this.gradient = new FocalGradient(stream);
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                this.bitmapId = stream.readUI16();
                this.bitmapMatrix = new Matrix(stream);
                break;
            }
            default: {
                throw new IOException("Illegal fill type: " + this.type);
            }
        }
    }

    public int getBitmapId() {
        return this.bitmapId;
    }

    public Matrix getBitmapMatrix() {
        return this.bitmapMatrix;
    }

    public Color getColor() {
        return this.color;
    }

    public Gradient getGradient() {
        return this.gradient;
    }

    public Matrix getGradientMatrix() {
        return this.gradientMatrix;
    }

    public short getType() {
        return this.type;
    }

    void write(OutputBitStream stream) throws IOException {
        stream.writeUI8(this.type);
        switch (this.type) {
            case 0: {
                this.color.write(stream);
                break;
            }
            case 16: 
            case 18: 
            case 19: {
                this.gradientMatrix.write(stream);
                this.gradient.write(stream);
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                stream.writeUI16(this.bitmapId);
                this.bitmapMatrix.write(stream);
            }
        }
    }
}

