/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.BevelFilter;
import oracle.dss.graph.flash.jswiff.swfrecords.BlurFilter;
import oracle.dss.graph.flash.jswiff.swfrecords.ColorMatrixFilter;
import oracle.dss.graph.flash.jswiff.swfrecords.ConvolutionFilter;
import oracle.dss.graph.flash.jswiff.swfrecords.DropShadowFilter;
import oracle.dss.graph.flash.jswiff.swfrecords.GlowFilter;
import oracle.dss.graph.flash.jswiff.swfrecords.GradientBevelFilter;
import oracle.dss.graph.flash.jswiff.swfrecords.GradientGlowFilter;

public abstract class Filter
implements Serializable {
    public static final int DROP_SHADOW = 0;
    public static final int BLUR = 1;
    public static final int GLOW = 2;
    public static final int BEVEL = 3;
    public static final int GRADIENT_GLOW = 4;
    public static final int CONVOLUTION = 5;
    public static final int COLOR_MATRIX = 6;
    public static final int GRADIENT_BEVEL = 7;

    public static List readFilters(InputBitStream stream) throws IOException {
        int count = stream.readUI8();
        ArrayList<BevelFilter> filters = new ArrayList<BevelFilter>(count);
        int i = 0;
        while (i < count) {
            Filter filter;
            short filterType = stream.readUI8();
            switch (filterType) {
                case 3: {
                    filter = new BevelFilter(stream);
                    break;
                }
                case 1: {
                    filter = new BlurFilter(stream);
                    break;
                }
                case 6: {
                    filter = new ColorMatrixFilter(stream);
                    break;
                }
                case 5: {
                    filter = new ConvolutionFilter(stream);
                    break;
                }
                case 0: {
                    filter = new DropShadowFilter(stream);
                    break;
                }
                case 2: {
                    filter = new GlowFilter(stream);
                    break;
                }
                case 7: {
                    filter = new GradientBevelFilter(stream);
                    break;
                }
                case 4: {
                    filter = new GradientGlowFilter(stream);
                    break;
                }
                default: {
                    throw new IOException("Unknown filter type: " + filterType);
                }
            }
            filters.add((BevelFilter)filter);
            ++i;
        }
        return filters;
    }

    public static void writeFilters(List filters, OutputBitStream stream) throws IOException {
        int count = filters.size();
        stream.writeUI8((short)count);
        int i = 0;
        while (i < count) {
            Object filter = filters.get(i);
            if (filter instanceof BevelFilter) {
                stream.writeUI8((short)3);
                ((BevelFilter)filter).write(stream);
            } else if (filter instanceof BlurFilter) {
                stream.writeUI8((short)1);
                ((BlurFilter)filter).write(stream);
            } else if (filter instanceof ColorMatrixFilter) {
                stream.writeUI8((short)6);
                ((ColorMatrixFilter)filter).write(stream);
            } else if (filter instanceof ConvolutionFilter) {
                stream.writeUI8((short)5);
                ((ConvolutionFilter)filter).write(stream);
            } else if (filter instanceof DropShadowFilter) {
                stream.writeUI8((short)0);
                ((DropShadowFilter)filter).write(stream);
            } else if (filter instanceof GlowFilter) {
                stream.writeUI8((short)2);
                ((GlowFilter)filter).write(stream);
            } else if (filter instanceof GradientBevelFilter) {
                stream.writeUI8((short)7);
                ((GradientBevelFilter)filter).write(stream);
            } else if (filter instanceof GradientGlowFilter) {
                stream.writeUI8((short)4);
                ((GradientGlowFilter)filter).write(stream);
            } else {
                throw new IllegalArgumentException("Filter list contains filter of unknown type: " + filter.getClass());
            }
            ++i;
        }
    }
}

