/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords;

import java.io.IOException;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.MorphGradRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.MorphGradient;

public final class FocalMorphGradient
extends MorphGradient {
    private double startFocalPointRatio;
    private double endFocalPointRatio;

    public FocalMorphGradient(MorphGradRecord[] gradientRecords, double startFocalPointRatio, double endFocalPointRatio) {
        super(gradientRecords);
        this.startFocalPointRatio = startFocalPointRatio;
        this.endFocalPointRatio = endFocalPointRatio;
    }

    FocalMorphGradient(InputBitStream stream) throws IOException {
        super(stream);
        this.startFocalPointRatio = stream.readFP16();
        this.endFocalPointRatio = stream.readFP16();
    }

    public void setEndFocalPointRatio(double endFocalPointRatio) {
        this.endFocalPointRatio = endFocalPointRatio;
    }

    public double getEndFocalPointRatio() {
        return this.endFocalPointRatio;
    }

    public void setStartFocalPointRatio(double startFocalPointRatio) {
        this.startFocalPointRatio = startFocalPointRatio;
    }

    public double getStartFocalPointRatio() {
        return this.startFocalPointRatio;
    }

    void write(OutputBitStream stream) throws IOException {
        super.write(stream);
        stream.writeFP16(this.startFocalPointRatio);
        stream.writeFP16(this.endFocalPointRatio);
    }
}

