/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords;

import java.io.IOException;
import java.io.Serializable;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;

public final class GlyphEntry
implements Serializable {
    private int glyphIndex;
    private int glyphAdvance;

    public GlyphEntry(int glyphIndex, int glyphAdvance) {
        this.glyphIndex = glyphIndex;
        this.glyphAdvance = glyphAdvance;
    }

    public GlyphEntry(InputBitStream stream, short glyphBits, short advanceBits) throws IOException {
        this.glyphIndex = (int)stream.readUnsignedBits(glyphBits);
        this.glyphAdvance = (int)stream.readSignedBits(advanceBits);
    }

    public int getGlyphAdvance() {
        return this.glyphAdvance;
    }

    public int getGlyphIndex() {
        return this.glyphIndex;
    }

    public void write(OutputBitStream stream, short glyphBits, short advanceBits) throws IOException {
        stream.writeUnsignedBits(this.glyphIndex, glyphBits);
        stream.writeSignedBits(this.glyphAdvance, advanceBits);
    }
}

