/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords;

import java.io.IOException;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.Filter;
import oracle.dss.graph.flash.jswiff.swfrecords.RGBA;

public final class GradientBevelFilter
extends Filter {
    private RGBA[] colors;
    private short[] ratios;
    private double x;
    private double y;
    private double angle;
    private double distance;
    private double strength;
    private boolean inner;
    private boolean knockout;
    private boolean onTop;
    private int quality;

    public GradientBevelFilter(RGBA[] colors, short[] ratios) {
        this.setControlPoints(colors, ratios);
        this.initDefaults();
    }

    public GradientBevelFilter(InputBitStream stream) throws IOException {
        int count = stream.readUI8();
        this.colors = new RGBA[count];
        this.ratios = new short[count];
        int i = 0;
        while (i < count) {
            this.colors[i] = new RGBA(stream);
            ++i;
        }
        int i2 = 0;
        while (i2 < count) {
            this.ratios[i2] = stream.readUI8();
            ++i2;
        }
        this.x = stream.readFP32();
        this.y = stream.readFP32();
        this.angle = stream.readFP32();
        this.distance = stream.readFP32();
        this.strength = stream.readFP16();
        this.inner = stream.readBooleanBit();
        this.knockout = stream.readBooleanBit();
        stream.readBooleanBit();
        this.onTop = stream.readBooleanBit();
        this.quality = (int)stream.readUnsignedBits(4);
    }

    public void setAngle(double angle) {
        this.angle = angle;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setControlPoints(RGBA[] colors, short[] ratios) {
        if (colors.length != ratios.length) {
            throw new IllegalArgumentException("colors and ratios arrays must have the same length!");
        }
        this.colors = colors;
        this.ratios = ratios;
    }

    public RGBA[] getColors() {
        return this.colors;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public double getDistance() {
        return this.distance;
    }

    public void setInner(boolean inner) {
        this.inner = inner;
    }

    public boolean isInner() {
        return this.inner;
    }

    public void setKnockout(boolean knockout) {
        this.knockout = knockout;
    }

    public boolean isKnockout() {
        return this.knockout;
    }

    public void setOnTop(boolean onTop) {
        this.onTop = onTop;
    }

    public boolean isOnTop() {
        return this.onTop;
    }

    public void setQuality(int quality) {
        this.quality = quality;
    }

    public int getQuality() {
        return this.quality;
    }

    public short[] getRatios() {
        return this.ratios;
    }

    public void setStrength(double strength) {
        this.strength = strength;
    }

    public double getStrength() {
        return this.strength;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getX() {
        return this.x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getY() {
        return this.y;
    }

    public void write(OutputBitStream stream) throws IOException {
        int count = this.colors.length;
        stream.writeUI8((short)count);
        int i = 0;
        while (i < count) {
            this.colors[i].write(stream);
            ++i;
        }
        int i2 = 0;
        while (i2 < count) {
            stream.writeUI8(this.ratios[i2]);
            ++i2;
        }
        stream.writeFP32(this.x);
        stream.writeFP32(this.y);
        stream.writeFP32(this.angle);
        stream.writeFP32(this.distance);
        stream.writeFP16(this.strength);
        stream.writeBooleanBit(this.inner);
        stream.writeBooleanBit(this.knockout);
        stream.writeBooleanBit(true);
        stream.writeBooleanBit(this.onTop);
        stream.writeUnsignedBits(this.quality, 4);
    }

    private void initDefaults() {
        this.x = 4.0;
        this.y = 4.0;
        this.angle = 0.7853981633974483;
        this.distance = 4.0;
        this.strength = 1.0;
        this.quality = 1;
        this.inner = true;
    }
}

