/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords;

import java.io.IOException;
import java.io.Serializable;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;

public final class Matrix
implements Serializable {
    private double scaleX;
    private double scaleY;
    private double rotateSkew0;
    private double rotateSkew1;
    private int translateX;
    private int translateY;
    private boolean hasScale;
    private boolean hasRotateSkew;

    private void $init$() {
        this.scaleX = 1.0;
        this.scaleY = 1.0;
        this.rotateSkew0 = 0.0;
        this.rotateSkew1 = 0.0;
        this.translateX = 0;
        this.translateY = 0;
    }

    public Matrix(int translateX, int translateY) {
        this.$init$();
        this.translateX = translateX;
        this.translateY = translateY;
    }

    public Matrix(InputBitStream stream) throws IOException {
        this.$init$();
        this.hasScale = stream.readBooleanBit();
        if (this.hasScale) {
            int nScaleBits = (int)stream.readUnsignedBits(5);
            this.scaleX = stream.readFPBits(nScaleBits);
            this.scaleY = stream.readFPBits(nScaleBits);
        }
        this.hasRotateSkew = stream.readBooleanBit();
        if (this.hasRotateSkew) {
            int nRotateBits = (int)stream.readUnsignedBits(5);
            this.rotateSkew0 = stream.readFPBits(nRotateBits);
            this.rotateSkew1 = stream.readFPBits(nRotateBits);
        }
        int nTranslateBits = (int)stream.readUnsignedBits(5);
        this.translateX = (int)stream.readSignedBits(nTranslateBits);
        this.translateY = (int)stream.readSignedBits(nTranslateBits);
        stream.align();
    }

    public void setRotateSkew(double rotateSkew0, double rotateSkew1) {
        this.rotateSkew0 = rotateSkew0;
        this.rotateSkew1 = rotateSkew1;
        this.hasRotateSkew = true;
    }

    public double getRotateSkew0() {
        return this.rotateSkew0;
    }

    public double getRotateSkew1() {
        return this.rotateSkew1;
    }

    public void setScale(double scaleX, double scaleY) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.hasScale = true;
    }

    public double getScaleX() {
        return this.scaleX;
    }

    public double getScaleY() {
        return this.scaleY;
    }

    public int getTranslateX() {
        return this.translateX;
    }

    public int getTranslateY() {
        return this.translateY;
    }

    public boolean hasRotateSkew() {
        return this.hasRotateSkew;
    }

    public boolean hasScale() {
        return this.hasScale;
    }

    public String toString() {
        return "Matrix (scaleX=" + this.scaleX + " scaleY=" + this.scaleY + " rotateSkew0=" + this.rotateSkew0 + " rotateSkew1=" + this.rotateSkew1 + " translateX=" + this.translateX + " translateY=" + this.translateY + ")";
    }

    public void write(OutputBitStream stream) throws IOException {
        stream.writeBooleanBit(this.hasScale);
        if (this.hasScale) {
            int nScaleBits = OutputBitStream.getFPBitsLength(this.scaleX);
            nScaleBits = Math.max(nScaleBits, OutputBitStream.getFPBitsLength(this.scaleY));
            stream.writeUnsignedBits(nScaleBits, 5);
            stream.writeFPBits(this.scaleX, nScaleBits);
            stream.writeFPBits(this.scaleY, nScaleBits);
        }
        stream.writeBooleanBit(this.hasRotateSkew);
        if (this.hasRotateSkew) {
            int nRotateBits = OutputBitStream.getFPBitsLength(this.rotateSkew0);
            nRotateBits = Math.max(nRotateBits, OutputBitStream.getFPBitsLength(this.rotateSkew1));
            stream.writeUnsignedBits(nRotateBits, 5);
            stream.writeFPBits(this.rotateSkew0, nRotateBits);
            stream.writeFPBits(this.rotateSkew1, nRotateBits);
        }
        int nTranslateBits = OutputBitStream.getSignedBitsLength(this.translateX);
        nTranslateBits = Math.max(nTranslateBits, OutputBitStream.getSignedBitsLength(this.translateY));
        stream.writeUnsignedBits(nTranslateBits, 5);
        stream.writeSignedBits(this.translateX, nTranslateBits);
        stream.writeSignedBits(this.translateY, nTranslateBits);
        stream.align();
    }
}

