/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords;

import java.io.IOException;
import java.io.Serializable;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.FocalMorphGradient;
import oracle.dss.graph.flash.jswiff.swfrecords.Matrix;
import oracle.dss.graph.flash.jswiff.swfrecords.MorphGradient;
import oracle.dss.graph.flash.jswiff.swfrecords.RGBA;

public final class MorphFillStyle
implements Serializable {
    public static final short TYPE_SOLID = 0;
    public static final short TYPE_LINEAR_GRADIENT = 16;
    public static final short TYPE_RADIAL_GRADIENT = 18;
    public static final short TYPE_FOCAL_RADIAL_GRADIENT = 19;
    public static final short TYPE_TILED_BITMAP = 64;
    public static final short TYPE_CLIPPED_BITMAP = 65;
    public static final short TYPE_NONSMOOTHED_TILED_BITMAP = 66;
    public static final short TYPE_NONSMOOTHED_CLIPPED_BITMAP = 67;
    private short type;
    private RGBA startColor;
    private RGBA endColor;
    private Matrix startGradientMatrix;
    private Matrix endGradientMatrix;
    private MorphGradient gradient;
    private int bitmapId;
    private Matrix startBitmapMatrix;
    private Matrix endBitmapMatrix;

    public MorphFillStyle(RGBA startColor, RGBA endColor) {
        this.startColor = startColor;
        this.endColor = endColor;
        this.type = 0;
    }

    public MorphFillStyle(MorphGradient gradient, Matrix startGradientMatrix, Matrix endGradientMatrix, short type) {
        if (type != 16 && type != 18 && type != 19) {
            throw new IllegalArgumentException("Illegal gradient type!");
        }
        this.gradient = gradient;
        this.startGradientMatrix = startGradientMatrix;
        this.endGradientMatrix = endGradientMatrix;
        this.type = type;
    }

    public MorphFillStyle(int bitmapId, Matrix startBitmapMatrix, Matrix endBitmapMatrix, short type) {
        if (type != 64 && type != 65 && type != 66 && type != 67) {
            throw new IllegalArgumentException("Illegal bitmap type");
        }
        this.bitmapId = bitmapId;
        this.startBitmapMatrix = startBitmapMatrix;
        this.endBitmapMatrix = endBitmapMatrix;
        this.type = type;
    }

    MorphFillStyle(InputBitStream stream) throws IOException {
        this.type = stream.readUI8();
        switch (this.type) {
            case 0: {
                this.startColor = new RGBA(stream);
                this.endColor = new RGBA(stream);
                break;
            }
            case 16: 
            case 18: {
                this.startGradientMatrix = new Matrix(stream);
                this.endGradientMatrix = new Matrix(stream);
                this.gradient = new MorphGradient(stream);
                break;
            }
            case 19: {
                this.startGradientMatrix = new Matrix(stream);
                this.endGradientMatrix = new Matrix(stream);
                this.gradient = new FocalMorphGradient(stream);
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                this.bitmapId = stream.readUI16();
                this.startBitmapMatrix = new Matrix(stream);
                this.endBitmapMatrix = new Matrix(stream);
                break;
            }
            default: {
                throw new IOException("Illegal morph fill type: " + this.type);
            }
        }
    }

    public int getBitmapId() {
        return this.bitmapId;
    }

    public Matrix getEndBitmapMatrix() {
        return this.endBitmapMatrix;
    }

    public RGBA getEndColor() {
        return this.endColor;
    }

    public Matrix getEndGradientMatrix() {
        return this.endGradientMatrix;
    }

    public MorphGradient getGradient() {
        return this.gradient;
    }

    public Matrix getStartBitmapMatrix() {
        return this.startBitmapMatrix;
    }

    public RGBA getStartColor() {
        return this.startColor;
    }

    public Matrix getStartGradientMatrix() {
        return this.startGradientMatrix;
    }

    public short getType() {
        return this.type;
    }

    void write(OutputBitStream stream) throws IOException {
        stream.writeUI8(this.type);
        switch (this.type) {
            case 0: {
                this.startColor.write(stream);
                this.endColor.write(stream);
                break;
            }
            case 16: 
            case 18: 
            case 19: {
                this.startGradientMatrix.write(stream);
                this.endGradientMatrix.write(stream);
                this.gradient.write(stream);
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                stream.writeUI16(this.bitmapId);
                this.startBitmapMatrix.write(stream);
                this.endBitmapMatrix.write(stream);
            }
        }
    }
}

