/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords;

import java.io.IOException;
import java.io.Serializable;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.RGBA;

public final class MorphGradRecord
implements Serializable {
    private short startRatio;
    private RGBA startColor;
    private short endRatio;
    private RGBA endColor;

    public MorphGradRecord(short startRatio, RGBA startColor, short endRatio, RGBA endColor) {
        this.startRatio = startRatio;
        this.startColor = startColor;
        this.endRatio = endRatio;
        this.endColor = endColor;
    }

    MorphGradRecord(InputBitStream stream) throws IOException {
        this.startRatio = stream.readUI8();
        this.startColor = new RGBA(stream);
        this.endRatio = stream.readUI8();
        this.endColor = new RGBA(stream);
    }

    public RGBA getEndColor() {
        return this.endColor;
    }

    public short getEndRatio() {
        return this.endRatio;
    }

    public RGBA getStartColor() {
        return this.startColor;
    }

    public short getStartRatio() {
        return this.startRatio;
    }

    void write(OutputBitStream stream) throws IOException {
        stream.writeUI8(this.startRatio);
        this.startColor.write(stream);
        stream.writeUI8(this.endRatio);
        this.endColor.write(stream);
    }
}

