/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords;

import java.io.IOException;
import java.io.Serializable;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.MorphGradRecord;

public class MorphGradient
implements Serializable {
    public static final byte SPREAD_PAD = 0;
    public static final byte SPREAD_REFLECT = 1;
    public static final byte SPREAD_REPEAT = 2;
    public static final byte INTERPOLATION_RGB = 0;
    public static final byte INTERPOLATION_LINEAR_RGB = 1;
    private MorphGradRecord[] gradientRecords;
    private byte spreadMethod;
    private byte interpolationMethod;

    public MorphGradient(MorphGradRecord[] gradientRecords) {
        this.gradientRecords = gradientRecords;
    }

    MorphGradient(InputBitStream stream) throws IOException {
        this.spreadMethod = (byte)stream.readUnsignedBits(2);
        this.interpolationMethod = (byte)stream.readUnsignedBits(2);
        int count = (int)stream.readUnsignedBits(4);
        this.gradientRecords = new MorphGradRecord[count];
        int i = 0;
        while (i < count) {
            this.gradientRecords[i] = new MorphGradRecord(stream);
            ++i;
        }
    }

    public MorphGradRecord[] getGradientRecords() {
        return this.gradientRecords;
    }

    void write(OutputBitStream stream) throws IOException {
        stream.writeUnsignedBits(this.spreadMethod, 2);
        stream.writeUnsignedBits(this.interpolationMethod, 2);
        int count = this.gradientRecords.length;
        stream.writeUnsignedBits(count, 4);
        int i = 0;
        while (i < count) {
            this.gradientRecords[i].write(stream);
            ++i;
        }
    }

    public byte getInterpolationMethod() {
        return this.interpolationMethod;
    }

    public void setInterpolationMethod(byte interpolationMethod) {
        this.interpolationMethod = interpolationMethod;
    }

    public byte getSpreadMethod() {
        return this.spreadMethod;
    }

    public void setSpreadMethod(byte spreadMethod) {
        this.spreadMethod = spreadMethod;
    }

    public void setGradientRecords(MorphGradRecord[] gradientRecords) {
        this.gradientRecords = gradientRecords;
    }
}

