/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords;

import java.io.IOException;
import java.io.Serializable;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.RGBA;

public final class MorphLineStyle
implements Serializable {
    private int startWidth;
    private int endWidth;
    private RGBA startColor;
    private RGBA endColor;

    public MorphLineStyle(int startWidth, RGBA startColor, int endWidth, RGBA endColor) {
        this.startWidth = startWidth;
        this.startColor = startColor;
        this.endWidth = endWidth;
        this.endColor = endColor;
    }

    MorphLineStyle(InputBitStream stream) throws IOException {
        this.startWidth = stream.readUI16();
        this.endWidth = stream.readUI16();
        this.startColor = new RGBA(stream);
        this.endColor = new RGBA(stream);
    }

    public RGBA getEndColor() {
        return this.endColor;
    }

    public int getEndWidth() {
        return this.endWidth;
    }

    public RGBA getStartColor() {
        return this.startColor;
    }

    public int getStartWidth() {
        return this.startWidth;
    }

    void write(OutputBitStream stream) throws IOException {
        stream.writeUI16(this.startWidth);
        stream.writeUI16(this.endWidth);
        this.startColor.write(stream);
        this.endColor.write(stream);
    }
}

