/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords;

import java.io.IOException;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.EnhancedStrokeStyle;
import oracle.dss.graph.flash.jswiff.swfrecords.MorphFillStyle;
import oracle.dss.graph.flash.jswiff.swfrecords.RGBA;

public final class MorphLineStyle2
extends EnhancedStrokeStyle {
    private int startWidth;
    private int endWidth;
    private byte startCapStyle;
    private byte endCapStyle;
    private byte jointStyle;
    private boolean pixelHinting;
    private boolean close;
    private byte scaleStroke;
    private double miterLimit;
    private RGBA startColor;
    private RGBA endColor;
    private MorphFillStyle fillStyle;

    private void $init$() {
        this.startCapStyle = 0;
        this.endCapStyle = 0;
        this.jointStyle = 0;
        this.close = true;
        this.scaleStroke = (byte)3;
        this.miterLimit = 3.0;
    }

    public MorphLineStyle2(int startWidth, RGBA startColor, int endWidth, RGBA endColor) {
        this.$init$();
        this.startWidth = startWidth;
        this.startColor = startColor;
        this.endWidth = endWidth;
        this.endColor = endColor;
    }

    public MorphLineStyle2(int startWidth, int endWidth, MorphFillStyle fillStyle) {
        this.$init$();
        this.startWidth = startWidth;
        this.endWidth = endWidth;
        this.fillStyle = fillStyle;
    }

    MorphLineStyle2(InputBitStream stream) throws IOException {
        this.$init$();
        this.startWidth = stream.readUI16();
        this.endWidth = stream.readUI16();
        this.startCapStyle = (byte)stream.readUnsignedBits(2);
        this.jointStyle = (byte)stream.readUnsignedBits(2);
        boolean hasFill = stream.readBooleanBit();
        boolean noHScale = stream.readBooleanBit();
        boolean noVScale = stream.readBooleanBit();
        this.scaleStroke = (byte)((noHScale ? 0 : 2) | (noVScale ? 0 : 1));
        this.pixelHinting = stream.readBooleanBit();
        stream.readUnsignedBits(5);
        this.close = stream.readBooleanBit() ^ true;
        this.endCapStyle = (byte)stream.readUnsignedBits(2);
        if (this.jointStyle == 2) {
            this.miterLimit = stream.readFP16();
        }
        if (hasFill) {
            this.fillStyle = new MorphFillStyle(stream);
        } else {
            this.startColor = new RGBA(stream);
            this.endColor = new RGBA(stream);
        }
    }

    public void setClose(boolean close) {
        this.close = close;
    }

    public boolean isClose() {
        return this.close;
    }

    public void setEndCapStyle(byte endCapStyle) {
        this.endCapStyle = endCapStyle;
    }

    public byte getEndCapStyle() {
        return this.endCapStyle;
    }

    public void setEndColor(RGBA endColor) {
        this.endColor = endColor;
        if (endColor != null) {
            this.fillStyle = null;
        }
    }

    public RGBA getEndColor() {
        return this.endColor;
    }

    public void setEndWidth(int endWidth) {
        this.endWidth = endWidth;
    }

    public int getEndWidth() {
        return this.endWidth;
    }

    public void setFillStyle(MorphFillStyle fillStyle) {
        this.fillStyle = fillStyle;
        if (fillStyle != null) {
            this.startColor = null;
            this.endColor = null;
        }
    }

    public MorphFillStyle getFillStyle() {
        return this.fillStyle;
    }

    public void setJointStyle(byte jointStyle) {
        this.jointStyle = jointStyle;
    }

    public byte getJointStyle() {
        return this.jointStyle;
    }

    public void setMiterLimit(double miterLimit) {
        this.miterLimit = miterLimit;
    }

    public double getMiterLimit() {
        return this.miterLimit;
    }

    public void setPixelHinting(boolean pixelHinting) {
        this.pixelHinting = pixelHinting;
    }

    public boolean isPixelHinting() {
        return this.pixelHinting;
    }

    public void setScaleStroke(byte scaleStroke) {
        this.scaleStroke = scaleStroke;
    }

    public byte getScaleStroke() {
        return this.scaleStroke;
    }

    public void setStartCapStyle(byte startCapStyle) {
        this.startCapStyle = startCapStyle;
    }

    public byte getStartCapStyle() {
        return this.startCapStyle;
    }

    public void setStartColor(RGBA startColor) {
        this.startColor = startColor;
        if (startColor != null) {
            this.fillStyle = null;
        }
    }

    public RGBA getStartColor() {
        return this.startColor;
    }

    public void setStartWidth(int startWidth) {
        this.startWidth = startWidth;
    }

    public int getStartWidth() {
        return this.startWidth;
    }

    void write(OutputBitStream stream) throws IOException {
        stream.writeUI16(this.startWidth);
        stream.writeUI16(this.endWidth);
        stream.writeUnsignedBits(this.startCapStyle, 2);
        stream.writeUnsignedBits(this.jointStyle, 2);
        boolean hasFill = this.fillStyle != null;
        stream.writeBooleanBit(hasFill);
        stream.writeBooleanBit(this.scaleStroke == 1 || this.scaleStroke == 0);
        stream.writeBooleanBit(this.scaleStroke == 2 || this.scaleStroke == 0);
        stream.writeBooleanBit(this.pixelHinting);
        stream.writeUnsignedBits(0L, 5);
        stream.writeBooleanBit(this.close ^ true);
        stream.writeUnsignedBits(this.endCapStyle, 2);
        if (this.jointStyle == 2) {
            stream.writeFP16(this.miterLimit);
        }
        if (hasFill) {
            this.fillStyle.write(stream);
        } else {
            this.startColor.write(stream);
            this.endColor.write(stream);
        }
    }
}

