/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords;

import java.io.IOException;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.Color;

public final class RGBA
extends Color {
    public static final RGBA BLACK = new RGBA(0, 0, 0, 255);
    public static final RGBA WHITE = new RGBA(255, 255, 255, 255);
    private short red;
    private short green;
    private short blue;
    private short alpha;

    public RGBA(short red, short green, short blue, short alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public RGBA(int red, int green, int blue, int alpha) {
        this.red = (short)red;
        this.green = (short)green;
        this.blue = (short)blue;
        this.alpha = (short)alpha;
    }

    public RGBA(InputBitStream stream) throws IOException {
        this.red = stream.readUI8();
        this.green = stream.readUI8();
        this.blue = stream.readUI8();
        this.alpha = stream.readUI8();
    }

    public static RGBA readARGB(InputBitStream stream) throws IOException {
        short a = stream.readUI8();
        short r = stream.readUI8();
        short g = stream.readUI8();
        short b = stream.readUI8();
        return new RGBA((int)r, (int)g, (int)b, (int)a);
    }

    public short getAlpha() {
        return this.alpha;
    }

    public short getBlue() {
        return this.blue;
    }

    public short getGreen() {
        return this.green;
    }

    public short getRed() {
        return this.red;
    }

    public String toString() {
        return "RGBA (" + this.red + "; " + this.green + "; " + this.blue + "; " + this.alpha + ")";
    }

    public void write(OutputBitStream stream) throws IOException {
        stream.writeUI8(this.red);
        stream.writeUI8(this.green);
        stream.writeUI8(this.blue);
        stream.writeUI8(this.alpha);
    }

    public void writeARGB(OutputBitStream stream) throws IOException {
        stream.writeUI8(this.alpha);
        stream.writeUI8(this.red);
        stream.writeUI8(this.green);
        stream.writeUI8(this.blue);
    }
}

