/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords;

import java.io.IOException;
import java.io.Serializable;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;

public final class Rect
implements Serializable {
    private long xMin;
    private long xMax;
    private long yMin;
    private long yMax;

    public Rect(long xMin, long xMax, long yMin, long yMax) {
        this.xMin = xMin;
        this.xMax = xMax;
        this.yMin = yMin;
        this.yMax = yMax;
    }

    public Rect(InputBitStream stream) throws IOException {
        int nBits = (int)stream.readUnsignedBits(5);
        this.xMin = stream.readSignedBits(nBits);
        this.xMax = stream.readSignedBits(nBits);
        this.yMin = stream.readSignedBits(nBits);
        this.yMax = stream.readSignedBits(nBits);
        stream.align();
    }

    public long getXMax() {
        return this.xMax;
    }

    public long getXMin() {
        return this.xMin;
    }

    public long getYMax() {
        return this.yMax;
    }

    public long getYMin() {
        return this.yMin;
    }

    public String toString() {
        return "Rect (" + this.xMin + ", " + this.xMax + ", " + this.yMin + ", " + this.yMax + ")";
    }

    public void write(OutputBitStream stream) throws IOException {
        int nBits = OutputBitStream.getSignedBitsLength(this.xMin);
        nBits = Math.max(nBits, OutputBitStream.getSignedBitsLength(this.xMax));
        nBits = Math.max(nBits, OutputBitStream.getSignedBitsLength(this.yMin));
        nBits = Math.max(nBits, OutputBitStream.getSignedBitsLength(this.yMax));
        stream.writeUnsignedBits(nBits, 5);
        stream.writeSignedBits(this.xMin, nBits);
        stream.writeSignedBits(this.xMax, nBits);
        stream.writeSignedBits(this.yMin, nBits);
        stream.writeSignedBits(this.yMax, nBits);
        stream.align();
    }
}

