/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords;

import java.io.IOException;
import java.io.Serializable;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.Rect;

public final class SWFHeader
implements Serializable {
    private boolean compressed;
    private short version;
    private long fileLength;
    private Rect frameSize;
    private short frameRate;
    private int frameCount;

    public SWFHeader() {
    }

    public SWFHeader(InputBitStream stream) throws IOException {
        this.read(stream);
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public void setFileLength(long fileLength) {
        this.fileLength = fileLength;
    }

    public long getFileLength() {
        return this.fileLength;
    }

    public void setFrameCount(int frameCount) {
        this.frameCount = frameCount;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public void setFrameRate(short frameRate) {
        this.frameRate = frameRate;
    }

    public short getFrameRate() {
        return this.frameRate;
    }

    public void setFrameSize(Rect frameSize) {
        this.frameSize = frameSize;
    }

    public Rect getFrameSize() {
        return this.frameSize;
    }

    public void setVersion(short version) {
        this.version = version;
    }

    public short getVersion() {
        return this.version;
    }

    private void read(InputBitStream stream) throws IOException {
        short compressionByte = stream.readUI8();
        if (compressionByte != 67 && compressionByte != 70 || stream.readUI8() != 87 || stream.readUI8() != 83) {
            throw new IOException("Invalid SWF file signature!");
        }
        if (compressionByte == 67) {
            this.compressed = true;
        }
        this.version = (byte)stream.readUI8();
        this.fileLength = stream.readUI32();
        if (this.compressed) {
            stream.enableCompression();
        }
        this.frameSize = new Rect(stream);
        stream.readUI8();
        this.frameRate = stream.readUI8();
        this.frameCount = stream.readUI16();
    }
}

