/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.CurvedEdgeRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.ShapeRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.StraightEdgeRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.StyleChangeRecord;

public class Shape
implements Serializable {
    protected byte numFillBits;
    protected byte numLineBits;
    protected ShapeRecord[] shapeRecords;

    public Shape(ShapeRecord[] shapeRecords) {
        this.shapeRecords = shapeRecords;
    }

    public Shape(InputBitStream stream) throws IOException {
        this.read(stream, false, false);
    }

    Shape() {
    }

    public ShapeRecord[] getShapeRecords() {
        return this.shapeRecords;
    }

    public void write(OutputBitStream stream) throws IOException {
        this.computeNumBits();
        byte currentNumFillBits = this.numFillBits;
        byte currentNumLineBits = this.numLineBits;
        stream.writeUnsignedBits(currentNumFillBits, 4);
        stream.writeUnsignedBits(currentNumLineBits, 4);
        int i = 0;
        while (i < this.shapeRecords.length) {
            ShapeRecord record = this.shapeRecords[i];
            if (record instanceof StyleChangeRecord) {
                StyleChangeRecord changeRecord = (StyleChangeRecord)record;
                changeRecord.write(stream, currentNumFillBits, currentNumLineBits);
                if (changeRecord.hasNewStyles()) {
                    currentNumFillBits = changeRecord.getNumFillBits();
                    currentNumLineBits = changeRecord.getNumLineBits();
                }
            } else if (record instanceof StraightEdgeRecord) {
                ((StraightEdgeRecord)record).write(stream);
            } else {
                ((CurvedEdgeRecord)record).write(stream);
            }
            ++i;
        }
        stream.writeUnsignedBits(0L, 6);
        stream.align();
    }

    protected void read(InputBitStream stream, boolean useNewLineStyle, boolean hasAlpha) throws IOException {
        this.numFillBits = (byte)stream.readUnsignedBits(4);
        this.numLineBits = (byte)stream.readUnsignedBits(4);
        byte currentNumFillBits = this.numFillBits;
        byte currentNumLineBits = this.numLineBits;
        Vector<ShapeRecord> shapeRecordVector = new Vector<ShapeRecord>();
        while (true) {
            int typeFlag;
            if ((typeFlag = (int)stream.readUnsignedBits(1)) == 0) {
                byte flags = (byte)stream.readUnsignedBits(5);
                if (flags == 0) break;
                StyleChangeRecord record = new StyleChangeRecord(stream, flags, currentNumFillBits, currentNumLineBits, useNewLineStyle, hasAlpha);
                currentNumFillBits = record.getNumFillBits();
                currentNumLineBits = record.getNumLineBits();
                shapeRecordVector.add(record);
                continue;
            }
            int straightFlag = (int)stream.readUnsignedBits(1);
            if (straightFlag == 1) {
                StraightEdgeRecord record = new StraightEdgeRecord(stream);
                shapeRecordVector.add(record);
                continue;
            }
            CurvedEdgeRecord record = new CurvedEdgeRecord(stream);
            shapeRecordVector.add(record);
        }
        stream.align();
        this.shapeRecords = new ShapeRecord[shapeRecordVector.size()];
        shapeRecordVector.copyInto(this.shapeRecords);
    }

    void setNumFillBits(byte numFillBits) {
        this.numFillBits = numFillBits;
    }

    byte getNumFillBits() {
        return this.numFillBits;
    }

    void setNumLineBits(byte numLineBits) {
        this.numLineBits = numLineBits;
    }

    byte getNumLineBits() {
        return this.numLineBits;
    }

    private void computeNumBits() {
        ArrayList<ShapeRecord> changeRecords = new ArrayList<ShapeRecord>();
        int i = 0;
        while (i < this.shapeRecords.length) {
            ShapeRecord record = this.shapeRecords[i];
            if (record instanceof StyleChangeRecord) {
                changeRecords.add(this.shapeRecords[i]);
            }
            ++i;
        }
        if (changeRecords.size() == 0) {
            return;
        }
        byte fillBits = 0;
        byte lineBits = 0;
        int groupStartIndex = -1;
        int i2 = 0;
        while (i2 < changeRecords.size()) {
            StyleChangeRecord record = (StyleChangeRecord)changeRecords.get(i2);
            if (record.hasFillStyle0()) {
                fillBits = (byte)Math.max(fillBits, OutputBitStream.getUnsignedBitsLength(record.getFillStyle0()));
            }
            if (record.hasFillStyle1()) {
                fillBits = (byte)Math.max(fillBits, OutputBitStream.getUnsignedBitsLength(record.getFillStyle1()));
            }
            if (record.hasLineStyle()) {
                lineBits = (byte)Math.max(lineBits, OutputBitStream.getUnsignedBitsLength(record.getLineStyle()));
            }
            if (record.hasNewStyles()) {
                this.storeNumBits(groupStartIndex, fillBits, lineBits, changeRecords);
                groupStartIndex = i2;
                fillBits = 0;
                lineBits = 0;
            }
            ++i2;
        }
        this.storeNumBits(groupStartIndex, fillBits, lineBits, changeRecords);
    }

    private void storeNumBits(int groupStartIndex, byte fillBits, byte lineBits, List changeRecords) {
        if (groupStartIndex > -1) {
            StyleChangeRecord groupStartRecord = (StyleChangeRecord)changeRecords.get(groupStartIndex);
            groupStartRecord.setNumFillBits(fillBits);
            groupStartRecord.setNumLineBits(lineBits);
        } else {
            this.numFillBits = fillBits;
            this.numLineBits = lineBits;
        }
    }
}

