/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords;

import java.io.IOException;
import java.io.Serializable;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.SoundEnvelope;

public final class SoundInfo
implements Serializable {
    private boolean syncStop;
    private boolean syncNoMultiple;
    private long inPoint;
    private long outPoint;
    private int loopCount;
    private SoundEnvelope[] envelopeRecords;
    private boolean hasEnvelope;
    private boolean hasLoops;
    private boolean hasOutPoint;
    private boolean hasInPoint;

    public SoundInfo() {
    }

    public SoundInfo(InputBitStream stream) throws IOException {
        stream.readUnsignedBits(2);
        this.syncStop = stream.readBooleanBit();
        this.syncNoMultiple = stream.readBooleanBit();
        this.hasEnvelope = stream.readBooleanBit();
        this.hasLoops = stream.readBooleanBit();
        this.hasOutPoint = stream.readBooleanBit();
        this.hasInPoint = stream.readBooleanBit();
        if (this.hasInPoint) {
            this.inPoint = stream.readUI32();
        }
        if (this.hasOutPoint) {
            this.outPoint = stream.readUI32();
        }
        if (this.hasLoops) {
            this.loopCount = stream.readUI16();
        }
        if (this.hasEnvelope) {
            int envPoints = stream.readUI8();
            this.envelopeRecords = new SoundEnvelope[envPoints];
            int i = 0;
            while (i < envPoints) {
                this.envelopeRecords[i] = new SoundEnvelope(stream);
                ++i;
            }
        }
    }

    public void setEnvelopeRecords(SoundEnvelope[] envelopeRecords) {
        this.envelopeRecords = envelopeRecords;
        if (envelopeRecords != null) {
            this.hasEnvelope = true;
        }
    }

    public SoundEnvelope[] getEnvelopeRecords() {
        return this.envelopeRecords;
    }

    public void setInPoint(long inPoint) {
        this.hasInPoint = true;
        this.inPoint = inPoint;
    }

    public long getInPoint() {
        return this.inPoint;
    }

    public void setLoopCount(int loopCount) {
        this.hasLoops = true;
        this.loopCount = loopCount;
    }

    public int getLoopCount() {
        return this.loopCount;
    }

    public void setOutPoint(long outPoint) {
        this.hasOutPoint = true;
        this.outPoint = outPoint;
    }

    public long getOutPoint() {
        return this.outPoint;
    }

    public void setSyncNoMultiple() {
        this.syncNoMultiple = true;
    }

    public boolean isSyncNoMultiple() {
        return this.syncNoMultiple;
    }

    public void setSyncStop() {
        this.syncStop = true;
    }

    public boolean isSyncStop() {
        return this.syncStop;
    }

    public boolean hasEnvelope() {
        return this.hasEnvelope;
    }

    public boolean hasInPoint() {
        return this.hasInPoint;
    }

    public boolean hasLoops() {
        return this.hasLoops;
    }

    public boolean hasOutPoint() {
        return this.hasOutPoint;
    }

    public void write(OutputBitStream stream) throws IOException {
        this.hasEnvelope = this.envelopeRecords != null;
        this.hasLoops = this.loopCount != 0;
        this.hasOutPoint = this.outPoint != 0L;
        this.hasInPoint = this.inPoint != 0L;
        stream.writeUnsignedBits(0L, 2);
        stream.writeBooleanBit(this.syncStop);
        stream.writeBooleanBit(this.syncNoMultiple);
        stream.writeBooleanBit(this.hasEnvelope);
        stream.writeBooleanBit(this.hasLoops);
        stream.writeBooleanBit(this.hasOutPoint);
        stream.writeBooleanBit(this.hasInPoint);
        if (this.hasInPoint) {
            stream.writeUI32(this.inPoint);
        }
        if (this.hasOutPoint) {
            stream.writeUI32(this.outPoint);
        }
        if (this.hasLoops) {
            stream.writeUI16(this.loopCount);
        }
        if (this.hasEnvelope) {
            stream.writeUI8((short)this.envelopeRecords.length);
            int i = 0;
            while (i < this.envelopeRecords.length) {
                this.envelopeRecords[i].write(stream);
                ++i;
            }
        }
    }
}

