/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords;

import java.io.IOException;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.EdgeRecord;

public final class StraightEdgeRecord
extends EdgeRecord {
    private int deltaX;
    private int deltaY;

    public StraightEdgeRecord(int deltaX, int deltaY) {
        this.deltaX = deltaX;
        this.deltaY = deltaY;
    }

    public StraightEdgeRecord(InputBitStream stream) throws IOException {
        byte numBits = (byte)stream.readUnsignedBits(4);
        boolean generalLineFlag = stream.readBooleanBit();
        if (generalLineFlag) {
            this.deltaX = (int)stream.readSignedBits(numBits + 2);
            this.deltaY = (int)stream.readSignedBits(numBits + 2);
        } else {
            boolean vertLineFlag = stream.readBooleanBit();
            if (vertLineFlag) {
                this.deltaY = (int)stream.readSignedBits(numBits + 2);
            } else {
                this.deltaX = (int)stream.readSignedBits(numBits + 2);
            }
        }
    }

    public int getDeltaX() {
        return this.deltaX;
    }

    public int getDeltaY() {
        return this.deltaY;
    }

    public void write(OutputBitStream stream) throws IOException {
        stream.writeUnsignedBits(1L, 1);
        stream.writeUnsignedBits(1L, 1);
        int numBits = 2;
        numBits = Math.max(numBits, OutputBitStream.getSignedBitsLength(this.deltaX));
        numBits = Math.max(numBits, OutputBitStream.getSignedBitsLength(this.deltaY));
        stream.writeUnsignedBits(numBits - 2, 4);
        boolean generalLineFlag = this.deltaX != 0 && this.deltaY != 0;
        stream.writeBooleanBit(generalLineFlag);
        if (generalLineFlag) {
            stream.writeSignedBits(this.deltaX, numBits);
            stream.writeSignedBits(this.deltaY, numBits);
        } else {
            boolean vertLineFlag = this.deltaX == 0;
            stream.writeBooleanBit(vertLineFlag);
            if (vertLineFlag) {
                stream.writeSignedBits(this.deltaY, numBits);
            } else {
                stream.writeSignedBits(this.deltaX, numBits);
            }
        }
    }
}

