/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords;

import java.io.IOException;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.FillStyleArray;
import oracle.dss.graph.flash.jswiff.swfrecords.LineStyleArray;
import oracle.dss.graph.flash.jswiff.swfrecords.ShapeRecord;

public final class StyleChangeRecord
extends ShapeRecord {
    private int moveToX;
    private int moveToY;
    private int fillStyle0;
    private int fillStyle1;
    private int lineStyle;
    private FillStyleArray fillStyles;
    private LineStyleArray lineStyles;
    private byte numFillBits;
    private byte numLineBits;
    private boolean hasNewStyles;
    private boolean hasLineStyle;
    private boolean hasFillStyle1;
    private boolean hasFillStyle0;
    private boolean hasMoveTo;

    public StyleChangeRecord() {
    }

    StyleChangeRecord(InputBitStream stream, byte flags, byte numFillBits, byte numLineBits, boolean useNewLineStyle, boolean hasAlpha) throws IOException {
        this.hasNewStyles = (flags & 0x10) != 0;
        this.hasLineStyle = (flags & 8) != 0;
        this.hasFillStyle1 = (flags & 4) != 0;
        this.hasFillStyle0 = (flags & 2) != 0;
        boolean bl = this.hasMoveTo = (flags & 1) != 0;
        if (this.hasMoveTo) {
            int moveBits = (int)stream.readUnsignedBits(5);
            this.moveToX = (int)stream.readSignedBits(moveBits);
            this.moveToY = (int)stream.readSignedBits(moveBits);
        }
        if (this.hasFillStyle0) {
            this.fillStyle0 = (int)stream.readUnsignedBits(numFillBits);
        }
        if (this.hasFillStyle1) {
            this.fillStyle1 = (int)stream.readUnsignedBits(numFillBits);
        }
        if (this.hasLineStyle) {
            this.lineStyle = (int)stream.readUnsignedBits(numLineBits);
        }
        if (this.hasNewStyles) {
            this.fillStyles = new FillStyleArray(stream, hasAlpha);
            this.lineStyles = useNewLineStyle ? new LineStyleArray(stream) : new LineStyleArray(stream, hasAlpha);
            this.numFillBits = (byte)stream.readUnsignedBits(4);
            this.numLineBits = (byte)stream.readUnsignedBits(4);
        } else {
            this.numFillBits = numFillBits;
            this.numLineBits = numLineBits;
        }
    }

    public void setFillStyle0(int fillStyle0) {
        this.fillStyle0 = fillStyle0;
        this.hasFillStyle0 = true;
    }

    public int getFillStyle0() {
        return this.fillStyle0;
    }

    public void setFillStyle1(int fillStyle1) {
        this.fillStyle1 = fillStyle1;
        this.hasFillStyle1 = true;
    }

    public int getFillStyle1() {
        return this.fillStyle1;
    }

    public void setLineStyle(int lineStyle) {
        this.lineStyle = lineStyle;
        this.hasLineStyle = true;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public void setMoveTo(int x, int y) {
        this.moveToX = x;
        this.moveToY = y;
        this.hasMoveTo = true;
    }

    public int getMoveToX() {
        return this.moveToX;
    }

    public int getMoveToY() {
        return this.moveToY;
    }

    public FillStyleArray getNewFillStyles() {
        return this.fillStyles;
    }

    public LineStyleArray getNewLineStyles() {
        return this.lineStyles;
    }

    public void setNewStyles(LineStyleArray lineStyles, FillStyleArray fillStyles) {
        this.lineStyles = lineStyles;
        this.fillStyles = fillStyles;
        this.hasNewStyles = true;
    }

    public boolean hasFillStyle0() {
        return this.hasFillStyle0;
    }

    public boolean hasFillStyle1() {
        return this.hasFillStyle1;
    }

    public boolean hasLineStyle() {
        return this.hasLineStyle;
    }

    public boolean hasMoveTo() {
        return this.hasMoveTo;
    }

    public boolean hasNewStyles() {
        return this.hasNewStyles;
    }

    void setNumFillBits(byte numFillBits) {
        this.numFillBits = numFillBits;
    }

    byte getNumFillBits() {
        return this.numFillBits;
    }

    void setNumLineBits(byte numLineBits) {
        this.numLineBits = numLineBits;
    }

    byte getNumLineBits() {
        return this.numLineBits;
    }

    void write(OutputBitStream stream, byte fillBits, byte lineBits) throws IOException {
        stream.writeUnsignedBits(0L, 1);
        stream.writeBooleanBit(this.hasNewStyles);
        stream.writeBooleanBit(this.hasLineStyle);
        stream.writeBooleanBit(this.hasFillStyle1);
        stream.writeBooleanBit(this.hasFillStyle0);
        stream.writeBooleanBit(this.hasMoveTo);
        if (this.hasMoveTo) {
            int moveBits = OutputBitStream.getSignedBitsLength(this.moveToX);
            moveBits = Math.max(moveBits, OutputBitStream.getSignedBitsLength(this.moveToY));
            stream.writeUnsignedBits(moveBits, 5);
            stream.writeSignedBits(this.moveToX, moveBits);
            stream.writeSignedBits(this.moveToY, moveBits);
        }
        if (this.hasFillStyle0) {
            stream.writeUnsignedBits(this.fillStyle0, fillBits);
        }
        if (this.hasFillStyle1) {
            stream.writeUnsignedBits(this.fillStyle1, fillBits);
        }
        if (this.hasLineStyle) {
            stream.writeUnsignedBits(this.lineStyle, lineBits);
        }
        if (this.hasNewStyles) {
            this.fillStyles.write(stream);
            this.lineStyles.write(stream);
            stream.writeUnsignedBits(this.numFillBits, 4);
            stream.writeUnsignedBits(this.numLineBits, 4);
        }
    }
}

