/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords;

import java.io.IOException;
import java.io.Serializable;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.Color;
import oracle.dss.graph.flash.jswiff.swfrecords.GlyphEntry;
import oracle.dss.graph.flash.jswiff.swfrecords.RGB;
import oracle.dss.graph.flash.jswiff.swfrecords.RGBA;

public final class TextRecord
implements Serializable {
    private boolean hasXOffset;
    private short xOffset;
    private boolean hasYOffset;
    private short yOffset;
    private boolean hasFont;
    private int fontId;
    private int textHeight;
    private boolean hasColor;
    private Color textColor;
    private GlyphEntry[] glyphEntries;

    public TextRecord(GlyphEntry[] glyphEntries) {
        this.glyphEntries = glyphEntries;
    }

    public TextRecord(InputBitStream stream, short glyphBits, short advanceBits, boolean hasAlpha) throws IOException {
        stream.readUnsignedBits(4);
        this.hasFont = stream.readBooleanBit();
        this.hasColor = stream.readBooleanBit();
        this.hasYOffset = stream.readBooleanBit();
        this.hasXOffset = stream.readBooleanBit();
        if (this.hasFont) {
            this.fontId = stream.readUI16();
        }
        if (this.hasColor) {
            Color color = this.textColor = hasAlpha ? (Color)new RGBA(stream) : (Color)new RGB(stream);
        }
        if (this.hasXOffset) {
            this.xOffset = stream.readSI16();
        }
        if (this.hasYOffset) {
            this.yOffset = stream.readSI16();
        }
        if (this.hasFont) {
            this.textHeight = stream.readUI16();
        }
        int glyphCount = stream.readUI8();
        this.glyphEntries = new GlyphEntry[glyphCount];
        int i = 0;
        while (i < glyphCount) {
            this.glyphEntries[i] = new GlyphEntry(stream, glyphBits, advanceBits);
            ++i;
        }
        stream.align();
    }

    public void setFont(int fontId, int textHeight) {
        this.fontId = fontId;
        this.textHeight = textHeight;
        this.hasFont = true;
    }

    public int getFontId() {
        return this.fontId;
    }

    public GlyphEntry[] getGlyphEntries() {
        return this.glyphEntries;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
        this.hasColor = true;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public int getTextHeight() {
        return this.textHeight;
    }

    public void setXOffset(short offset) {
        this.xOffset = offset;
        this.hasXOffset = true;
    }

    public short getXOffset() {
        return this.xOffset;
    }

    public void setYOffset(short offset) {
        this.yOffset = offset;
        this.hasYOffset = true;
    }

    public short getYOffset() {
        return this.yOffset;
    }

    public boolean hasColor() {
        return this.hasColor;
    }

    public boolean hasFont() {
        return this.hasFont;
    }

    public boolean hasXOffset() {
        return this.hasXOffset;
    }

    public boolean hasYOffset() {
        return this.hasYOffset;
    }

    public void write(OutputBitStream stream, short glyphBits, short advanceBits) throws IOException {
        stream.writeUnsignedBits(1L, 1);
        stream.writeUnsignedBits(0L, 3);
        stream.writeBooleanBit(this.hasFont);
        stream.writeBooleanBit(this.hasColor);
        stream.writeBooleanBit(this.hasYOffset);
        stream.writeBooleanBit(this.hasXOffset);
        if (this.hasFont) {
            stream.writeUI16(this.fontId);
        }
        if (this.hasColor) {
            this.textColor.write(stream);
        }
        if (this.hasXOffset) {
            stream.writeSI16(this.xOffset);
        }
        if (this.hasYOffset) {
            stream.writeSI16(this.yOffset);
        }
        if (this.hasFont) {
            stream.writeUI16(this.textHeight);
        }
        stream.writeUI8((short)this.glyphEntries.length);
        int i = 0;
        while (i < this.glyphEntries.length) {
            this.glyphEntries[i].write(stream, glyphBits, advanceBits);
            ++i;
        }
        stream.align();
    }
}

