/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords.actions;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;

public abstract class Action
implements Serializable {
    protected short code;
    private int offset;
    private String label;

    public short getCode() {
        return this.code;
    }

    public Action copy() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            Action action = (Action)ois.readObject();
            return action;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getSize() {
        return 1;
    }

    protected void writeData(OutputBitStream dataStream, OutputBitStream mainStream) throws IOException {
        throw new IOException("Override this method for actions with code >= 0x80!");
    }

    void setOffset(int offset) {
        this.offset = offset;
    }

    void write(OutputBitStream stream) throws IOException {
        stream.writeUI8(this.code);
        if (this.code >= 128) {
            OutputBitStream dataStream = new OutputBitStream();
            dataStream.setANSI(stream.isANSI());
            dataStream.setShiftJIS(stream.isShiftJIS());
            OutputBitStream mainStream = new OutputBitStream();
            mainStream.setANSI(stream.isANSI());
            mainStream.setShiftJIS(stream.isShiftJIS());
            this.writeData(dataStream, mainStream);
            byte[] actionData = dataStream.getData();
            stream.writeUI16(actionData.length);
            stream.writeBytes(actionData);
            stream.writeBytes(mainStream.getData());
        }
    }
}

