/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords.actions;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Action;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.ActionReader;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Branch;

public final class ActionBlock
implements Serializable {
    public static String LABEL_END = "__end";
    public static String LABEL_OUT = "__out";
    private static int instCounter = 0;
    private List actions;
    private Map labelMap;
    private Map inverseLabelMap;

    private void $init$() {
        this.actions = new ArrayList();
        this.labelMap = new HashMap();
        this.inverseLabelMap = new HashMap();
    }

    public ActionBlock() {
        this.$init$();
    }

    public ActionBlock(InputBitStream stream) throws IOException {
        this.$init$();
        int startOffset = (int)stream.getOffset();
        boolean hasEndAction = false;
        while (stream.available() > 0) {
            Action record = ActionReader.readRecord(stream);
            if (record.code != 0) {
                this.actions.add(record);
                continue;
            }
            hasEndAction = true;
            break;
        }
        if (this.actions.size() == 0) {
            return;
        }
        int relativeEndOffset = (int)stream.getOffset() - startOffset - (hasEndAction ? 1 : 0);
        int labelCounter = 0;
        HashMap<Integer, Action> actionMap = new HashMap<Integer, Action>();
        int i = 0;
        while (i < this.actions.size()) {
            Action action = (Action)this.actions.get(i);
            int newOffset = action.getOffset() - startOffset;
            action.setOffset(newOffset);
            actionMap.put(new Integer(newOffset), action);
            if (action.getCode() == 157 || action.getCode() == 153) {
                String branchLabel;
                Branch branchAction = (Branch)action;
                int branchOffset = this.getBranchOffset(branchAction);
                if (branchOffset < relativeEndOffset) {
                    Integer branchOffsetObj = new Integer(branchOffset);
                    String oldLabel = (String)this.inverseLabelMap.get(branchOffsetObj);
                    if (oldLabel == null) {
                        branchLabel = "L_" + instCounter + "_" + labelCounter++;
                        this.labelMap.put(branchLabel, branchOffsetObj);
                        this.inverseLabelMap.put(branchOffsetObj, branchLabel);
                    } else {
                        branchLabel = oldLabel;
                    }
                } else {
                    branchLabel = branchOffset == relativeEndOffset ? LABEL_END : LABEL_OUT;
                }
                branchAction.setBranchLabel(branchLabel);
            }
            ++i;
        }
        Set keys = this.labelMap.keySet();
        for (String label : keys) {
            Object branchOffset = this.labelMap.get(label);
            Action action = (Action)actionMap.get(branchOffset);
            if (action == null) continue;
            action.setLabel(label);
            this.labelMap.put(label, action);
        }
        ++instCounter;
    }

    public static void resetInstanceCounter() {
        instCounter = 0;
    }

    public List getActions() {
        return this.actions;
    }

    public int getSize() {
        int size = 0;
        Iterator i = this.actions.iterator();
        while (i.hasNext()) {
            size += ((Action)i.next()).getSize();
        }
        return size;
    }

    public void addAction(Action action) {
        this.actions.add(action);
    }

    public boolean removeAction(Action action) {
        return this.actions.remove(action);
    }

    public Action removeAction(int index) {
        return (Action)this.actions.remove(index);
    }

    public void write(OutputBitStream stream, boolean writeEndAction) throws IOException {
        int currentOffset = 0;
        for (Action action : this.actions) {
            action.setOffset(currentOffset);
            currentOffset += action.getSize();
            String label = action.getLabel();
            if (label == null) continue;
            this.labelMap.put(label, action);
        }
        for (Action action : this.actions) {
            switch (action.getCode()) {
                case 153: 
                case 157: {
                    this.replaceBranchLabelWithRelOffset((Branch)action);
                    break;
                }
            }
            action.write(stream);
        }
        if (writeEndAction) {
            stream.writeUI8((short)0);
        }
    }

    private Action getAction(String label) {
        Object action = this.labelMap.get(label);
        if (action instanceof Action) {
            return (Action)action;
        }
        throw new IllegalArgumentException("Label '" + label + "' points at non-existent action!");
    }

    private int getBranchOffset(Branch action) {
        int branchOffset = 0;
        branchOffset = action.getBranchOffset();
        return branchOffset += action.getOffset() + action.getSize();
    }

    private int getOffset(String label) {
        if (label.equals(LABEL_END)) {
            return this.getSize();
        }
        Action action = this.getAction(label);
        if (action == null) {
            throw new IllegalArgumentException("Label " + label + " not defined!");
        }
        return action.getOffset();
    }

    private void replaceBranchLabelWithRelOffset(Branch action) {
        short branchOffset = (short)this.getOffset(action.getBranchLabel());
        branchOffset = (short)(branchOffset - (action.getOffset() + action.getSize()));
        action.setBranchOffset(branchOffset);
    }
}

