/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords.actions;

import java.io.IOException;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Action;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Add;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Add2;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.And;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.AsciiToChar;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.BitAnd;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.BitLShift;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.BitOr;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.BitRShift;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.BitURShift;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.BitXor;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Call;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.CallFunction;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.CallMethod;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.CastOp;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.CharToAscii;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.CloneSprite;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.ConstantPool;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Decrement;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.DefineFunction;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.DefineFunction2;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.DefineLocal;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.DefineLocal2;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Delete;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Delete2;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Divide;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.End;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.EndDrag;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Enumerate;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Enumerate2;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Equals;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Equals2;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Extends;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.GetMember;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.GetProperty;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.GetTime;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.GetURL;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.GetURL2;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.GetVariable;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.GoToFrame;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.GoToFrame2;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.GoToLabel;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Greater;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.If;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.ImplementsOp;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Increment;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.InitArray;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.InitObject;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.InstanceOf;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Jump;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Less;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Less2;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.MBAsciiToChar;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.MBCharToAscii;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.MBStringExtract;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.MBStringLength;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Modulo;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Multiply;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.NewMethod;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.NewObject;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.NextFrame;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Not;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Or;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Play;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Pop;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.PreviousFrame;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Push;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.PushDuplicate;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.RandomNumber;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.RemoveSprite;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Return;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.SetMember;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.SetProperty;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.SetTarget;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.SetTarget2;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.SetVariable;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.StackSwap;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.StartDrag;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Stop;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.StopSounds;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.StoreRegister;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.StrictEquals;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.StringAdd;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.StringEquals;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.StringExtract;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.StringGreater;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.StringLength;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.StringLess;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Subtract;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.TargetPath;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Throw;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.ToInteger;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.ToNumber;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.ToString;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.ToggleQuality;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Trace;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Try;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.TypeOf;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.UnknownAction;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.WaitForFrame;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.WaitForFrame2;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.With;

final class ActionReader {
    private ActionReader() {
    }

    static Action readRecord(InputBitStream stream) throws IOException {
        Action action;
        int length;
        InputBitStream actionStream = null;
        int offset = (int)stream.getOffset();
        short actionCode = stream.readUI8();
        boolean longHeader = actionCode >= 128;
        int n = length = longHeader ? stream.readUI16() : 0;
        if (length > 0) {
            actionStream = new InputBitStream(stream.readBytes(length));
            actionStream.setANSI(stream.isANSI());
            actionStream.setShiftJIS(stream.isShiftJIS());
        }
        switch (actionCode) {
            case 10: {
                action = new Add();
                break;
            }
            case 71: {
                action = new Add2();
                break;
            }
            case 16: {
                action = new And();
                break;
            }
            case 51: {
                action = new AsciiToChar();
                break;
            }
            case 96: {
                action = new BitAnd();
                break;
            }
            case 99: {
                action = new BitLShift();
                break;
            }
            case 97: {
                action = new BitOr();
                break;
            }
            case 100: {
                action = new BitRShift();
                break;
            }
            case 101: {
                action = new BitURShift();
                break;
            }
            case 98: {
                action = new BitXor();
                break;
            }
            case 158: {
                action = new Call();
                break;
            }
            case 61: {
                action = new CallFunction();
                break;
            }
            case 82: {
                action = new CallMethod();
                break;
            }
            case 43: {
                action = new CastOp();
                break;
            }
            case 50: {
                action = new CharToAscii();
                break;
            }
            case 36: {
                action = new CloneSprite();
                break;
            }
            case 136: {
                action = new ConstantPool(actionStream);
                break;
            }
            case 81: {
                action = new Decrement();
                break;
            }
            case 155: {
                action = new DefineFunction(actionStream, stream);
                break;
            }
            case 142: {
                action = new DefineFunction2(actionStream, stream);
                break;
            }
            case 60: {
                action = new DefineLocal();
                break;
            }
            case 65: {
                action = new DefineLocal2();
                break;
            }
            case 58: {
                action = new Delete();
                break;
            }
            case 59: {
                action = new Delete2();
                break;
            }
            case 13: {
                action = new Divide();
                break;
            }
            case 0: {
                action = new End();
                break;
            }
            case 40: {
                action = new EndDrag();
                break;
            }
            case 70: {
                action = new Enumerate();
                break;
            }
            case 85: {
                action = new Enumerate2();
                break;
            }
            case 14: {
                action = new Equals();
                break;
            }
            case 73: {
                action = new Equals2();
                break;
            }
            case 105: {
                action = new Extends();
                break;
            }
            case 78: {
                action = new GetMember();
                break;
            }
            case 34: {
                action = new GetProperty();
                break;
            }
            case 52: {
                action = new GetTime();
                break;
            }
            case 131: {
                action = new GetURL(actionStream);
                break;
            }
            case 154: {
                action = new GetURL2(actionStream);
                break;
            }
            case 28: {
                action = new GetVariable();
                break;
            }
            case 129: {
                action = new GoToFrame(actionStream);
                break;
            }
            case 159: {
                action = new GoToFrame2(actionStream);
                break;
            }
            case 140: {
                action = new GoToLabel(actionStream);
                break;
            }
            case 103: {
                action = new Greater();
                break;
            }
            case 157: {
                action = new If(actionStream);
                break;
            }
            case 44: {
                action = new ImplementsOp();
                break;
            }
            case 80: {
                action = new Increment();
                break;
            }
            case 66: {
                action = new InitArray();
                break;
            }
            case 67: {
                action = new InitObject();
                break;
            }
            case 84: {
                action = new InstanceOf();
                break;
            }
            case 153: {
                action = new Jump(actionStream);
                break;
            }
            case 15: {
                action = new Less();
                break;
            }
            case 72: {
                action = new Less2();
                break;
            }
            case 55: {
                action = new MBAsciiToChar();
                break;
            }
            case 54: {
                action = new MBCharToAscii();
                break;
            }
            case 53: {
                action = new MBStringExtract();
                break;
            }
            case 49: {
                action = new MBStringLength();
                break;
            }
            case 63: {
                action = new Modulo();
                break;
            }
            case 12: {
                action = new Multiply();
                break;
            }
            case 83: {
                action = new NewMethod();
                break;
            }
            case 64: {
                action = new NewObject();
                break;
            }
            case 4: {
                action = new NextFrame();
                break;
            }
            case 18: {
                action = new Not();
                break;
            }
            case 17: {
                action = new Or();
                break;
            }
            case 6: {
                action = new Play();
                break;
            }
            case 23: {
                action = new Pop();
                break;
            }
            case 5: {
                action = new PreviousFrame();
                break;
            }
            case 150: {
                action = new Push(actionStream);
                break;
            }
            case 76: {
                action = new PushDuplicate();
                break;
            }
            case 48: {
                action = new RandomNumber();
                break;
            }
            case 37: {
                action = new RemoveSprite();
                break;
            }
            case 62: {
                action = new Return();
                break;
            }
            case 79: {
                action = new SetMember();
                break;
            }
            case 35: {
                action = new SetProperty();
                break;
            }
            case 139: {
                action = new SetTarget(actionStream);
                break;
            }
            case 32: {
                action = new SetTarget2();
                break;
            }
            case 29: {
                action = new SetVariable();
                break;
            }
            case 77: {
                action = new StackSwap();
                break;
            }
            case 39: {
                action = new StartDrag();
                break;
            }
            case 7: {
                action = new Stop();
                break;
            }
            case 9: {
                action = new StopSounds();
                break;
            }
            case 135: {
                action = new StoreRegister(actionStream);
                break;
            }
            case 102: {
                action = new StrictEquals();
                break;
            }
            case 33: {
                action = new StringAdd();
                break;
            }
            case 19: {
                action = new StringEquals();
                break;
            }
            case 21: {
                action = new StringExtract();
                break;
            }
            case 104: {
                action = new StringGreater();
                break;
            }
            case 20: {
                action = new StringLength();
                break;
            }
            case 41: {
                action = new StringLess();
                break;
            }
            case 11: {
                action = new Subtract();
                break;
            }
            case 69: {
                action = new TargetPath();
                break;
            }
            case 42: {
                action = new Throw();
                break;
            }
            case 8: {
                action = new ToggleQuality();
                break;
            }
            case 24: {
                action = new ToInteger();
                break;
            }
            case 74: {
                action = new ToNumber();
                break;
            }
            case 75: {
                action = new ToString();
                break;
            }
            case 38: {
                action = new Trace();
                break;
            }
            case 143: {
                action = new Try(actionStream, stream);
                break;
            }
            case 68: {
                action = new TypeOf();
                break;
            }
            case 138: {
                action = new WaitForFrame(actionStream);
                break;
            }
            case 141: {
                action = new WaitForFrame2(actionStream);
                break;
            }
            case 148: {
                action = new With(actionStream, stream);
                break;
            }
            default: {
                action = new UnknownAction(actionStream, actionCode);
            }
        }
        int delta = action.getSize() - (length + (longHeader ? 3 : 1));
        if (delta < 0) {
            stream.move(delta);
        }
        action.setOffset(offset);
        return action;
    }
}

