/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords.actions;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Action;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.ActionBlock;

public final class DefineFunction
extends Action {
    private String name;
    private String[] parameters;
    private ActionBlock body;

    public DefineFunction(String functionName, String[] parameters) {
        this.code = (short)155;
        this.name = functionName;
        this.parameters = parameters;
        this.body = new ActionBlock();
    }

    DefineFunction(InputBitStream stream, InputBitStream mainStream) throws IOException {
        this.code = (short)155;
        this.name = stream.readString();
        int numParams = stream.readUI16();
        if (numParams >= 0) {
            this.parameters = new String[numParams];
            int i = 0;
            while (i < numParams) {
                this.parameters[i] = stream.readString();
                ++i;
            }
        }
        int codeSize = stream.readUI16();
        byte[] blockBuffer = mainStream.readBytes(codeSize);
        InputBitStream blockStream = new InputBitStream(blockBuffer);
        blockStream.setANSI(stream.isANSI());
        blockStream.setShiftJIS(stream.isShiftJIS());
        this.body = new ActionBlock(blockStream);
    }

    public ActionBlock getBody() {
        return this.body;
    }

    public String getName() {
        return this.name;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public int getSize() {
        int size = 8 + this.body.getSize();
        try {
            int paramLength = this.parameters == null ? 0 : this.parameters.length;
            size += this.name.getBytes("UTF-8").length + paramLength;
            int i = 0;
            while (i < paramLength) {
                size += this.parameters[i].getBytes("UTF-8").length;
                ++i;
            }
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        return size;
    }

    public void addAction(Action action) {
        this.body.addAction(action);
    }

    public String toString() {
        return "DefineFunction " + this.name;
    }

    protected void writeData(OutputBitStream dataStream, OutputBitStream mainStream) throws IOException {
        dataStream.writeString(this.name);
        dataStream.writeUI16(this.parameters == null ? 0 : this.parameters.length);
        if (this.parameters != null) {
            int i = 0;
            while (i < this.parameters.length) {
                dataStream.writeString(this.parameters[i]);
                ++i;
            }
        }
        dataStream.writeUI16(this.body.getSize());
        this.body.write(mainStream, false);
    }
}

