/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords.actions;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.RegisterParam;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Action;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.ActionBlock;

public final class DefineFunction2
extends Action {
    private String name;
    private short registerCount;
    private boolean preloadParent;
    private boolean preloadRoot;
    private boolean suppressSuper;
    private boolean preloadSuper;
    private boolean suppressArguments;
    private boolean preloadArguments;
    private boolean suppressThis;
    private boolean preloadThis;
    private boolean preloadGlobal;
    private RegisterParam[] parameters;
    private ActionBlock body;

    public DefineFunction2(String name, short registerCount, RegisterParam[] parameters) {
        this.code = (short)142;
        this.name = name;
        this.registerCount = registerCount;
        this.parameters = parameters;
        this.body = new ActionBlock();
    }

    DefineFunction2(InputBitStream stream, InputBitStream mainStream) throws IOException {
        this.code = (short)142;
        this.name = stream.readString();
        int numParams = stream.readUI16();
        this.registerCount = stream.readUI8();
        this.preloadParent = stream.readBooleanBit();
        this.preloadRoot = stream.readBooleanBit();
        this.suppressSuper = stream.readBooleanBit();
        this.preloadSuper = stream.readBooleanBit();
        this.suppressArguments = stream.readBooleanBit();
        this.preloadArguments = stream.readBooleanBit();
        this.suppressThis = stream.readBooleanBit();
        this.preloadThis = stream.readBooleanBit();
        this.preloadGlobal = (stream.readUI8() & 1) != 0;
        this.parameters = new RegisterParam[numParams];
        int i = 0;
        while (i < numParams) {
            this.parameters[i] = new RegisterParam(stream);
            ++i;
        }
        int codeSize = stream.readUI16();
        byte[] blockBuffer = mainStream.readBytes(codeSize);
        InputBitStream blockStream = new InputBitStream(blockBuffer);
        blockStream.setANSI(mainStream.isANSI());
        blockStream.setShiftJIS(mainStream.isShiftJIS());
        this.body = new ActionBlock(blockStream);
    }

    public ActionBlock getBody() {
        return this.body;
    }

    public String getName() {
        return this.name;
    }

    public RegisterParam[] getParameters() {
        return this.parameters;
    }

    public short getRegisterCount() {
        return this.registerCount;
    }

    public int getSize() {
        int size = 11 + this.body.getSize();
        try {
            size += this.name.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (this.parameters != null) {
            int i = 0;
            while (i < this.parameters.length) {
                size += this.parameters[i].getSize();
                ++i;
            }
        }
        return size;
    }

    public void addAction(Action action) {
        this.body.addAction(action);
    }

    public void preloadArguments() {
        this.preloadArguments = true;
    }

    public void preloadGlobal() {
        this.preloadGlobal = true;
    }

    public void preloadParent() {
        this.preloadParent = true;
    }

    public void preloadRoot() {
        this.preloadRoot = true;
    }

    public void preloadSuper() {
        this.preloadSuper = true;
    }

    public void preloadThis() {
        this.preloadThis = true;
    }

    public boolean preloadsArguments() {
        return this.preloadArguments;
    }

    public boolean preloadsGlobal() {
        return this.preloadGlobal;
    }

    public boolean preloadsParent() {
        return this.preloadParent;
    }

    public boolean preloadsRoot() {
        return this.preloadRoot;
    }

    public boolean preloadsSuper() {
        return this.preloadSuper;
    }

    public boolean preloadsThis() {
        return this.preloadThis;
    }

    public void suppressArguments() {
        this.suppressArguments = true;
    }

    public void suppressSuper() {
        this.suppressSuper = true;
    }

    public void suppressThis() {
        this.suppressThis = true;
    }

    public boolean suppressesArguments() {
        return this.suppressArguments;
    }

    public boolean suppressesSuper() {
        return this.suppressSuper;
    }

    public boolean suppressesThis() {
        return this.suppressThis;
    }

    public String toString() {
        return "DefineFunction2 " + this.name;
    }

    protected void writeData(OutputBitStream dataStream, OutputBitStream mainStream) throws IOException {
        dataStream.writeString(this.name);
        dataStream.writeUI16(this.parameters == null ? 0 : this.parameters.length);
        dataStream.writeUI8(this.registerCount);
        dataStream.writeBooleanBit(this.preloadParent);
        dataStream.writeBooleanBit(this.preloadRoot);
        dataStream.writeBooleanBit(this.suppressSuper);
        dataStream.writeBooleanBit(this.preloadSuper);
        dataStream.writeBooleanBit(this.suppressArguments);
        dataStream.writeBooleanBit(this.preloadArguments);
        dataStream.writeBooleanBit(this.suppressThis);
        dataStream.writeBooleanBit(this.preloadThis);
        dataStream.writeUI8((short)(this.preloadGlobal ? 1 : 0));
        if (this.parameters != null) {
            int i = 0;
            while (i < this.parameters.length) {
                this.parameters[i].write(dataStream);
                ++i;
            }
        }
        dataStream.writeUI16(this.body.getSize());
        this.body.write(mainStream, false);
    }
}

