/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords.actions;

import java.io.IOException;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Action;

public final class GoToFrame2
extends Action {
    private boolean play;
    private int sceneBias;

    public GoToFrame2(boolean play, int sceneBias) {
        this.code = (short)159;
        this.play = play;
        this.sceneBias = sceneBias;
    }

    GoToFrame2(InputBitStream stream) throws IOException {
        this.code = (short)159;
        short bits = stream.readUI8();
        boolean sceneBiasFlag = (bits & 2) != 0;
        boolean bl = this.play = (bits & 1) != 0;
        if (sceneBiasFlag) {
            this.sceneBias = stream.readUI16();
        }
    }

    public int getSceneBias() {
        return this.sceneBias;
    }

    public int getSize() {
        int size = 4;
        if (this.sceneBias > 0) {
            size += 2;
        }
        return size;
    }

    public boolean play() {
        return this.play;
    }

    public String toString() {
        String result = "GoToFrame2  play: " + this.play;
        if (this.sceneBias > 0) {
            result = result + " sceneBias: " + this.sceneBias;
        }
        return result;
    }

    protected void writeData(OutputBitStream dataStream, OutputBitStream mainStream) throws IOException {
        dataStream.writeUnsignedBits(0L, 6);
        boolean sceneBiasFlag = this.sceneBias > 0;
        dataStream.writeBooleanBit(sceneBiasFlag);
        dataStream.writeBooleanBit(this.play);
        if (sceneBiasFlag) {
            dataStream.writeUI16(this.sceneBias);
        }
    }
}

