/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords.actions;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Action;

public final class Push
extends Action {
    private List values;

    private void $init$() {
        this.values = new ArrayList();
    }

    public Push() {
        this.$init$();
        this.code = (short)150;
    }

    Push(InputBitStream stream) throws IOException {
        this.$init$();
        this.code = (short)150;
        while (stream.available() > 0) {
            StackValue value = new StackValue(stream);
            this.values.add(value);
        }
    }

    public int getSize() {
        int size = 3;
        int i = 0;
        while (i < this.values.size()) {
            size += ((StackValue)this.values.get(i)).getSize();
            ++i;
        }
        return size;
    }

    public List getValues() {
        return this.values;
    }

    public void addValue(StackValue value) {
        this.values.add(value);
    }

    public String toString() {
        return "Push";
    }

    protected void writeData(OutputBitStream dataStream, OutputBitStream mainStream) throws IOException {
        int i = 0;
        while (i < this.values.size()) {
            ((StackValue)this.values.get(i)).write(dataStream);
            ++i;
        }
    }

    public static class StackValue
    implements Serializable {
        public static final short TYPE_STRING = 0;
        public static final short TYPE_FLOAT = 1;
        public static final short TYPE_NULL = 2;
        public static final short TYPE_UNDEFINED = 3;
        public static final short TYPE_REGISTER = 4;
        public static final short TYPE_BOOLEAN = 5;
        public static final short TYPE_DOUBLE = 6;
        public static final short TYPE_INTEGER = 7;
        public static final short TYPE_CONSTANT_8 = 8;
        public static final short TYPE_CONSTANT_16 = 9;
        private short type;
        private String string;
        private float floatValue;
        private short registerNumber;
        private boolean booleanValue;
        private double doubleValue;
        private long integerValue;
        private short constant8;
        private int constant16;

        private void $init$() {
            this.type = (short)3;
        }

        public StackValue() {
            this.$init$();
        }

        StackValue(InputBitStream stream) throws IOException {
            this.$init$();
            this.type = stream.readUI8();
            switch (this.type) {
                case 0: {
                    this.string = stream.readString();
                    break;
                }
                case 1: {
                    this.floatValue = stream.readFloat();
                    break;
                }
                case 4: {
                    this.registerNumber = stream.readUI8();
                    break;
                }
                case 5: {
                    this.booleanValue = stream.readUI8() != 0;
                    break;
                }
                case 6: {
                    this.doubleValue = stream.readDouble();
                    break;
                }
                case 7: {
                    this.integerValue = stream.readUI32();
                    break;
                }
                case 8: {
                    this.constant8 = stream.readUI8();
                    break;
                }
                case 9: {
                    this.constant16 = stream.readUI16();
                    break;
                }
            }
        }

        public void setBoolean(boolean value) {
            this.booleanValue = value;
            this.type = (short)5;
        }

        public boolean getBoolean() {
            return this.booleanValue;
        }

        public void setConstant16(int value) {
            this.constant16 = value;
            this.type = (short)9;
        }

        public int getConstant16() {
            if (this.type != 9) {
                throw new IllegalStateException("Value type is not TYPE_CONSTANT_16!");
            }
            return this.constant16;
        }

        public void setConstant8(short value) {
            this.constant8 = value;
            this.type = (short)8;
        }

        public short getConstant8() {
            if (this.type != 8) {
                throw new IllegalStateException("Value type is not TYPE_CONSTANT_8!");
            }
            return this.constant8;
        }

        public void setDouble(double value) {
            this.doubleValue = value;
            this.type = (short)6;
        }

        public double getDouble() {
            if (this.type != 6) {
                throw new IllegalStateException("Value type is not TYPE_DOUBLE!");
            }
            return this.doubleValue;
        }

        public void setFloat(float value) {
            this.floatValue = value;
            this.type = 1;
        }

        public float getFloat() {
            if (this.type != 1) {
                throw new IllegalStateException("Value type is not TYPE_FLOAT!");
            }
            return this.floatValue;
        }

        public void setInteger(long value) {
            this.integerValue = value;
            this.type = (short)7;
        }

        public long getInteger() {
            if (this.type != 7) {
                throw new IllegalStateException("Value type is not TYPE_INTEGER!");
            }
            return this.integerValue;
        }

        public void setNull() {
            this.type = (short)2;
        }

        public boolean isNull() {
            return this.type == 2;
        }

        public void setRegisterNumber(short value) {
            this.registerNumber = value;
            this.type = (short)4;
        }

        public short getRegisterNumber() {
            if (this.type != 4) {
                throw new IllegalStateException("Value type is not TYPE_REGISTER!");
            }
            return this.registerNumber;
        }

        public void setString(String value) {
            this.string = value;
            this.type = 0;
        }

        public String getString() {
            if (this.type != 0) {
                throw new IllegalStateException("Value type is not TYPE_STRING!");
            }
            return this.string;
        }

        public short getType() {
            return this.type;
        }

        public void setUndefined() {
            this.type = (short)3;
        }

        public boolean isUndefined() {
            return this.type == 3;
        }

        public String toString() {
            String result = "";
            switch (this.type) {
                case 0: {
                    result = result + "string: '" + this.string + "'";
                    break;
                }
                case 1: {
                    result = result + "float: " + this.floatValue;
                    break;
                }
                case 4: {
                    result = result + "register: " + this.registerNumber;
                    break;
                }
                case 5: {
                    result = result + "boolean: " + this.booleanValue;
                    break;
                }
                case 6: {
                    result = result + "double: " + this.doubleValue;
                    break;
                }
                case 7: {
                    result = result + "integer: " + this.integerValue;
                    break;
                }
                case 8: {
                    result = result + "c8[" + this.constant8 + "]";
                    break;
                }
                case 9: {
                    result = result + "c16[" + this.constant16 + "]";
                    break;
                }
                case 3: {
                    result = result + "undefined";
                    break;
                }
                case 2: {
                    result = result + "null";
                    break;
                }
            }
            return result;
        }

        int getSize() {
            int size = 1;
            switch (this.type) {
                case 0: {
                    try {
                        size += this.string.getBytes("UTF-8").length + 1;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                    break;
                }
                case 1: {
                    size += 4;
                    break;
                }
                case 4: {
                    ++size;
                    break;
                }
                case 5: {
                    ++size;
                    break;
                }
                case 6: {
                    size += 8;
                    break;
                }
                case 7: {
                    size += 4;
                    break;
                }
                case 8: {
                    ++size;
                    break;
                }
                case 9: {
                    size += 2;
                    break;
                }
            }
            return size;
        }

        void write(OutputBitStream outStream) throws IOException {
            outStream.writeUI8(this.type);
            switch (this.type) {
                case 0: {
                    outStream.writeString(this.string);
                    break;
                }
                case 1: {
                    outStream.writeFloat(this.floatValue);
                    break;
                }
                case 4: {
                    outStream.writeUI8(this.registerNumber);
                    break;
                }
                case 5: {
                    outStream.writeUI8((short)(this.booleanValue ? 1 : 0));
                    break;
                }
                case 6: {
                    outStream.writeDouble(this.doubleValue);
                    break;
                }
                case 7: {
                    outStream.writeUI32(this.integerValue);
                    break;
                }
                case 8: {
                    outStream.writeUI8(this.constant8);
                    break;
                }
                case 9: {
                    outStream.writeUI16(this.constant16);
                    break;
                }
            }
        }
    }
}

