/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords.actions;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Action;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.ActionBlock;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Jump;

public final class Try
extends Action {
    private boolean catchInRegister;
    private String catchVariable;
    private short catchRegister;
    private ActionBlock tryBlock;
    private ActionBlock catchBlock;
    private ActionBlock finallyBlock;

    public Try(String catchVar) {
        this();
        this.catchVariable = catchVar;
    }

    public Try(short catchRegister) {
        this();
        this.catchRegister = catchRegister;
        this.catchInRegister = true;
    }

    Try(InputBitStream stream, InputBitStream mainStream) throws IOException {
        this.code = (short)143;
        short flags = stream.readUI8();
        this.catchInRegister = (flags & 4) != 0;
        boolean hasFinallyBlock = (flags & 2) != 0;
        boolean hasCatchBlock = (flags & 1) != 0;
        int trySize = stream.readUI16();
        int catchSize = stream.readUI16();
        int finallySize = stream.readUI16();
        if (this.catchInRegister) {
            this.catchRegister = stream.readUI8();
        } else {
            this.catchVariable = stream.readString();
        }
        byte[] blockBuffer = mainStream.readBytes(trySize);
        InputBitStream blockStream = new InputBitStream(blockBuffer);
        blockStream.setANSI(stream.isANSI());
        blockStream.setShiftJIS(stream.isShiftJIS());
        this.tryBlock = new ActionBlock(blockStream);
        this.removeTryJump();
        if (hasCatchBlock) {
            blockBuffer = mainStream.readBytes(catchSize);
            blockStream = new InputBitStream(blockBuffer);
            blockStream.setANSI(stream.isANSI());
            blockStream.setShiftJIS(stream.isShiftJIS());
            this.catchBlock = new ActionBlock(blockStream);
        } else {
            this.catchBlock = new ActionBlock();
        }
        if (hasFinallyBlock) {
            blockBuffer = mainStream.readBytes(finallySize);
            blockStream = new InputBitStream(blockBuffer);
            blockStream.setANSI(stream.isANSI());
            blockStream.setShiftJIS(stream.isShiftJIS());
            this.finallyBlock = new ActionBlock(blockStream);
        } else {
            this.finallyBlock = new ActionBlock();
        }
    }

    private Try() {
        this.code = (short)143;
        this.tryBlock = new ActionBlock();
        this.catchBlock = new ActionBlock();
        this.finallyBlock = new ActionBlock();
    }

    public ActionBlock getCatchBlock() {
        return this.catchBlock;
    }

    public short getCatchRegister() {
        return this.catchRegister;
    }

    public String getCatchVariable() {
        return this.catchVariable;
    }

    public ActionBlock getFinallyBlock() {
        return this.finallyBlock;
    }

    public int getSize() {
        int size = 10 + this.tryBlock.getSize() + this.catchBlock.getSize() + this.finallyBlock.getSize();
        if (this.catchInRegister) {
            ++size;
        } else {
            try {
                size += this.catchVariable.getBytes("UTF-8").length + 1;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return size;
    }

    public ActionBlock getTryBlock() {
        return this.tryBlock;
    }

    public void addToCatch(Action action) {
        this.catchBlock.addAction(action);
    }

    public void addToFinally(Action action) {
        this.finallyBlock.addAction(action);
    }

    public void addToTry(Action action) {
        this.tryBlock.addAction(action);
    }

    public boolean catchInRegister() {
        return this.catchInRegister;
    }

    public boolean hasCatchBlock() {
        return this.catchBlock.getActions().size() > 0;
    }

    public boolean hasFinallyBlock() {
        return this.finallyBlock.getActions().size() > 0;
    }

    protected void writeData(OutputBitStream dataStream, OutputBitStream mainStream) throws IOException {
        dataStream.writeUnsignedBits(0L, 5);
        dataStream.writeBooleanBit(this.catchInRegister);
        dataStream.writeBooleanBit(this.finallyBlock.getActions().size() > 0);
        dataStream.writeBooleanBit(this.catchBlock.getActions().size() > 0);
        dataStream.writeUI16(this.tryBlock.getSize());
        dataStream.writeUI16(this.catchBlock.getSize());
        dataStream.writeUI16(this.finallyBlock.getSize());
        if (this.catchInRegister) {
            dataStream.writeUI8(this.catchRegister);
        } else {
            dataStream.writeString(this.catchVariable);
        }
        this.tryBlock.write(mainStream, false);
        if (this.catchBlock.getActions().size() > 0) {
            new Jump((short)this.catchBlock.getSize()).write(mainStream);
        }
        this.catchBlock.write(mainStream, false);
        this.finallyBlock.write(mainStream, false);
    }

    private void removeTryJump() {
        Action lastAction;
        List actions = this.tryBlock.getActions();
        if (actions.size() > 0 && (lastAction = (Action)actions.get(actions.size() - 1)).getCode() == 153 && ((Jump)lastAction).getBranchLabel().equals(ActionBlock.LABEL_OUT)) {
            actions.remove(actions.size() - 1);
        }
    }
}

