/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords.tags;

import java.io.IOException;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefinitionTag;

public final class DefineBitsJPEG3
extends DefinitionTag {
    private byte[] jpegData;
    private byte[] bitmapAlphaData;

    public DefineBitsJPEG3(int characterId, byte[] jpegData, byte[] bitmapAlphaData) {
        this.code = (short)35;
        this.characterId = characterId;
        this.jpegData = jpegData;
        this.bitmapAlphaData = bitmapAlphaData;
    }

    DefineBitsJPEG3() {
    }

    public void setBitmapAlphaData(byte[] bitmapAlphaData) {
        this.bitmapAlphaData = bitmapAlphaData;
    }

    public byte[] getBitmapAlphaData() {
        return this.bitmapAlphaData;
    }

    public void setJpegData(byte[] jpegData) {
        this.jpegData = jpegData;
    }

    public byte[] getJpegData() {
        return this.jpegData;
    }

    protected void writeData(OutputBitStream outStream) throws IOException {
        this.forceLongHeader = true;
        outStream.writeUI16(this.characterId);
        outStream.writeUI32(this.jpegData.length);
        outStream.writeBytes(this.jpegData);
        outStream.writeBytes(this.bitmapAlphaData);
    }

    void setData(byte[] data) throws IOException {
        InputBitStream inStream = new InputBitStream(data);
        this.characterId = inStream.readUI16();
        int alphaDataOffset = (int)inStream.readUI32();
        this.jpegData = new byte[alphaDataOffset];
        System.arraycopy(data, 6, this.jpegData, 0, alphaDataOffset);
        int alphaDataSize = data.length - 6 - alphaDataOffset;
        this.bitmapAlphaData = new byte[alphaDataSize];
        System.arraycopy(data, 6 + alphaDataOffset, this.bitmapAlphaData, 0, alphaDataSize);
    }
}

